/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.workflow.log;

import com.google.common.util.concurrent.FutureCallback;
import hudson.console.LineTransformationOutputStream;
import hudson.model.Job;
import hudson.model.Run;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.Set;
import org.jenkinsci.plugins.workflow.cps.CpsFlowDefinition;
import org.jenkinsci.plugins.workflow.flow.FlowDefinition;
import org.jenkinsci.plugins.workflow.job.WorkflowJob;
import org.jenkinsci.plugins.workflow.job.WorkflowRun;
import org.jenkinsci.plugins.workflow.log.TaskListenerDecorator;
import org.jenkinsci.plugins.workflow.steps.BodyExecutionCallback;
import org.jenkinsci.plugins.workflow.steps.Step;
import org.jenkinsci.plugins.workflow.steps.StepContext;
import org.jenkinsci.plugins.workflow.steps.StepDescriptor;
import org.jenkinsci.plugins.workflow.steps.StepExecution;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.jvnet.hudson.test.BuildWatcher;
import org.jvnet.hudson.test.JenkinsRule;
import org.jvnet.hudson.test.TestExtension;
import org.kohsuke.stapler.DataBoundConstructor;

public final class TaskListenerDecoratorTest {
    @ClassRule
    public static BuildWatcher buildWatcher = new BuildWatcher();
    @Rule
    public JenkinsRule r = new JenkinsRule();

    @Test
    public void brokenMergedTaskListenerDecorator() throws Exception {
        WorkflowJob p = (WorkflowJob)this.r.createProject(WorkflowJob.class, "p");
        p.setDefinition((FlowDefinition)new CpsFlowDefinition("mask {broken {echo 'please mask s3cr3t'}}; broken {mask {echo 'please also mask s3cr3t'}}", true));
        WorkflowRun b = (WorkflowRun)this.r.buildAndAssertSuccess((Job)p);
        this.r.assertLogNotContains("s3cr3t", (Run)b);
        this.r.assertLogContains("please mask ****", (Run)b);
        this.r.assertLogContains("please also mask ****", (Run)b);
        this.r.assertLogContains("IllegalStateException: oops", (Run)b);
        this.r.assertLogContains(BrokenStep.BrokenDecorator.class.getName(), (Run)b);
    }

    public static final class BrokenStep
    extends Step {
        @DataBoundConstructor
        public BrokenStep() {
        }

        public StepExecution start(StepContext context) throws Exception {
            return new Execution(context);
        }

        private static final class Execution
        extends StepExecution {
            private static final long serialVersionUID = 1L;

            Execution(StepContext context) {
                super(context);
            }

            public boolean start() throws Exception {
                this.getContext().newBodyInvoker().withContext((Object)TaskListenerDecorator.merge((TaskListenerDecorator)((TaskListenerDecorator)this.getContext().get(TaskListenerDecorator.class)), (TaskListenerDecorator)new BrokenDecorator())).withCallback(BodyExecutionCallback.wrap((FutureCallback)this.getContext())).start();
                return false;
            }
        }

        @TestExtension(value={"brokenMergedTaskListenerDecorator"})
        public static final class DescriptorImpl
        extends StepDescriptor {
            public Set<? extends Class<?>> getRequiredContext() {
                return Set.of();
            }

            public String getFunctionName() {
                return "broken";
            }

            public boolean takesImplicitBlockArgument() {
                return true;
            }
        }

        private static final class BrokenDecorator
        extends TaskListenerDecorator {
            private BrokenDecorator() {
            }

            public OutputStream decorate(OutputStream logger) throws IOException, InterruptedException {
                throw new IllegalStateException("oops");
            }
        }
    }

    public static final class MaskStep
    extends Step {
        @DataBoundConstructor
        public MaskStep() {
        }

        public StepExecution start(StepContext context) throws Exception {
            return new Execution(context);
        }

        private static final class Execution
        extends StepExecution {
            private static final long serialVersionUID = 1L;

            Execution(StepContext context) {
                super(context);
            }

            public boolean start() throws Exception {
                this.getContext().newBodyInvoker().withContext((Object)TaskListenerDecorator.merge((TaskListenerDecorator)((TaskListenerDecorator)this.getContext().get(TaskListenerDecorator.class)), (TaskListenerDecorator)new MaskingDecorator())).withCallback(BodyExecutionCallback.wrap((FutureCallback)this.getContext())).start();
                return false;
            }
        }

        @TestExtension(value={"brokenMergedTaskListenerDecorator"})
        public static final class DescriptorImpl
        extends StepDescriptor {
            public Set<? extends Class<?>> getRequiredContext() {
                return Set.of();
            }

            public String getFunctionName() {
                return "mask";
            }

            public boolean takesImplicitBlockArgument() {
                return true;
            }
        }

        private static final class MaskingDecorator
        extends TaskListenerDecorator {
            private MaskingDecorator() {
            }

            public OutputStream decorate(OutputStream logger) throws IOException, InterruptedException {
                return new LineTransformationOutputStream.Delegating(logger){

                    protected void eol(byte[] b, int len) throws IOException {
                        this.out.write(new String(b, 0, len, StandardCharsets.UTF_8).replace("s3cr3t", "****").getBytes(StandardCharsets.UTF_8));
                    }
                };
            }
        }
    }
}

