/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.workflow;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.AbortException;
import hudson.EnvVars;
import hudson.ExtensionList;
import hudson.FilePath;
import hudson.Functions;
import hudson.Launcher;
import hudson.Util;
import hudson.model.FreeStyleBuild;
import hudson.model.FreeStyleProject;
import hudson.model.Node;
import hudson.model.Run;
import hudson.model.Slave;
import hudson.model.TaskListener;
import hudson.model.TopLevelItem;
import hudson.remoting.Callable;
import hudson.slaves.DumbSlave;
import hudson.tasks.ArtifactArchiver;
import hudson.util.StreamTaskListener;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.logging.Level;
import jenkins.model.ArtifactManagerConfiguration;
import jenkins.model.ArtifactManagerFactory;
import jenkins.model.StandardArtifactManager;
import jenkins.security.MasterToSlaveCallable;
import jenkins.util.VirtualFile;
import org.apache.commons.io.IOUtils;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.jenkinsci.plugins.workflow.flow.StashManager;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.jvnet.hudson.test.JenkinsRule;
import org.jvnet.hudson.test.LoggerRule;
import test.ssh_agent.OutboundAgent;

public class ArtifactManagerTest {
    @Rule
    public JenkinsRule r = new JenkinsRule();
    @Rule
    public LoggerRule logging = new LoggerRule();

    private static void wrapInContainer(@NonNull JenkinsRule r, @CheckForNull ArtifactManagerFactory factory, boolean weirdCharacters, TestFunction f) throws Exception {
        if (factory != null) {
            ArtifactManagerConfiguration.get().getArtifactManagerFactories().add((Object)factory);
        }
        try (OutboundAgent outboundAgent = new OutboundAgent();){
            OutboundAgent.createAgent((JenkinsRule)r, (String)"remote", (OutboundAgent.ConnectionDetails)outboundAgent.start());
            DumbSlave agent = (DumbSlave)r.jenkins.getNode("remote");
            r.waitOnline((Slave)agent);
            FreeStyleProject p = r.createFreeStyleProject();
            p.setAssignedNode((Node)agent);
            FilePath ws = agent.getWorkspaceFor((TopLevelItem)p);
            ArtifactManagerTest.setUpWorkspace(ws, weirdCharacters);
            ArtifactArchiver aa = new ArtifactArchiver("**");
            aa.setDefaultExcludes(false);
            p.getPublishersList().add((Object)aa);
            FreeStyleBuild b = r.buildAndAssertSuccess(p);
            f.apply(agent, p, b, ws);
        }
    }

    public static void artifactArchive(@NonNull JenkinsRule r, @CheckForNull ArtifactManagerFactory factory, boolean weirdCharacters) throws Exception {
        ArtifactManagerTest.wrapInContainer(r, factory, weirdCharacters, (agent, p, b, ws) -> {
            VirtualFile root = b.getArtifactManager().root();
            new Verify(agent, root, weirdCharacters).run();
            Assert.assertFalse((boolean)b.getArtifactManager().delete());
            Assert.assertTrue((boolean)b.getArtifactManager().root().child("file").isFile());
        });
    }

    public static void artifactArchiveAndDelete(@NonNull JenkinsRule r, @CheckForNull ArtifactManagerFactory factory, boolean weirdCharacters) throws Exception {
        ArtifactManagerTest.wrapInContainer(r, factory, weirdCharacters, (agent, p, b, ws) -> {
            VirtualFile root = b.getArtifactManager().root();
            new Verify(agent, root, weirdCharacters).run();
            Assert.assertTrue((boolean)b.getArtifactManager().delete());
            Assert.assertFalse((boolean)b.getArtifactManager().root().child("file").isFile());
            Assert.assertFalse((boolean)b.getArtifactManager().delete());
        });
    }

    public static void artifactStash(@NonNull JenkinsRule r, @CheckForNull ArtifactManagerFactory factory, boolean weirdCharacters) throws Exception {
        ArtifactManagerTest.wrapInContainer(r, factory, weirdCharacters, new StashFunction(r, weirdCharacters, (p, b, ws, launcher, env, listener) -> {
            StashManager.unstash((Run)b, (String)"stuff", (FilePath)ws, (Launcher)launcher, (EnvVars)env, (TaskListener)listener);
            Assert.assertTrue((boolean)ws.child("file").exists());
        }));
    }

    public static void artifactStashAndDelete(@NonNull JenkinsRule r, @CheckForNull ArtifactManagerFactory factory, boolean weirdCharacters) throws Exception {
        ArtifactManagerTest.wrapInContainer(r, factory, weirdCharacters, new StashFunction(r, weirdCharacters, (p, b, ws, launcher, env, listener) -> {
            try {
                StashManager.unstash((Run)b, (String)"stuff", (FilePath)ws, (Launcher)launcher, (EnvVars)env, (TaskListener)listener);
                Assert.fail((String)"should not have succeeded in unstashing");
            }
            catch (AbortException x) {
                System.err.println("caught as expected: " + String.valueOf((Object)x));
            }
            Assert.assertFalse((boolean)ws.child("file").exists());
        }));
    }

    private static void setUpWorkspace(FilePath workspace, boolean weirdCharacters) throws Exception {
        workspace.child("file").write("content", null);
        workspace.child("some/deeply/nested/dir/subfile").write("content", null);
        workspace.child(".git/config").write("whatever", null);
        workspace.child("otherdir/somefile~").write("whatever", null);
        if (weirdCharacters) {
            Assert.assertEquals((Object)"UTF-8 vs. UTF-8", (Object)workspace.getChannel().call((Callable)new FindEncoding()));
            workspace.child("otherdir/xxx#?:$&'\"<>\u010d\u0950").write("whatever", null);
        }
    }

    private static void assertDir(VirtualFile f) throws IOException {
        System.err.println("Asserting dir: " + String.valueOf(f));
        Assert.assertFalse((String)("Unexpected file: " + String.valueOf(f)), (boolean)f.isFile());
        Assert.assertTrue((String)("Not a directory: " + String.valueOf(f)), (boolean)f.isDirectory());
        Assert.assertTrue((String)("Does not exist: " + String.valueOf(f)), (boolean)f.exists());
    }

    private static void assertNonexistent(VirtualFile f) throws IOException {
        System.err.println("Asserting nonexistent: " + String.valueOf(f));
        Assert.assertFalse((String)("Unexpected file: " + String.valueOf(f)), (boolean)f.isFile());
        Assert.assertFalse((String)("Unexpected dir: " + String.valueOf(f)), (boolean)f.isDirectory());
        Assert.assertFalse((String)("Unexpectedly exists: " + String.valueOf(f)), (boolean)f.exists());
        try {
            Assert.assertEquals((long)0L, (long)f.length());
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            Assert.assertEquals((long)0L, (long)f.lastModified());
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Test
    public void standard() throws Exception {
        this.logging.record(StandardArtifactManager.class, Level.FINE);
        ArtifactManagerTest.artifactArchiveAndDelete(this.r, null, !Functions.isWindows());
    }

    @FunctionalInterface
    private static interface TestFunction {
        public void apply(DumbSlave var1, FreeStyleProject var2, FreeStyleBuild var3, FilePath var4) throws Exception;
    }

    private static class StashFunction
    implements TestFunction {
        private final JenkinsRule r;
        private final boolean weirdCharacters;
        private final TestStashFunction f;

        StashFunction(@NonNull JenkinsRule r, boolean weirdCharacters, TestStashFunction f) {
            this.r = r;
            this.weirdCharacters = weirdCharacters;
            this.f = f;
        }

        @Override
        public void apply(DumbSlave agent, FreeStyleProject p, FreeStyleBuild b, FilePath ws) throws Exception {
            StreamTaskListener listener = StreamTaskListener.fromStderr();
            Launcher launcher = agent.createLauncher((TaskListener)listener);
            EnvVars env = agent.toComputer().getEnvironment();
            env.putAll((Map)agent.toComputer().buildEnvironment((TaskListener)listener));
            StashManager.stash((Run)b, (String)"stuff", (FilePath)ws, (Launcher)launcher, (EnvVars)env, (TaskListener)listener, (String)"file", null, (boolean)false, (boolean)false);
            StashManager.stash((Run)b, (String)"empty", (FilePath)ws, (Launcher)launcher, (EnvVars)env, (TaskListener)listener, (String)"nada", null, (boolean)false, (boolean)true);
            try {
                StashManager.stash((Run)b, (String)"empty", (FilePath)ws, (Launcher)launcher, (EnvVars)env, (TaskListener)listener, (String)"nada", null, (boolean)false, (boolean)false);
            }
            catch (AbortException x) {
                System.err.println("good, allowEmpty is being enforced: " + x.getMessage());
            }
            ws.child("file").delete();
            StashManager.unstash((Run)b, (String)"stuff", (FilePath)ws, (Launcher)launcher, (EnvVars)env, (TaskListener)listener);
            Assert.assertEquals((Object)"content", (Object)ws.child("file").readToString());
            ws.child("file").delete();
            StashManager.unstash((Run)b, (String)"empty", (FilePath)ws, (Launcher)launcher, (EnvVars)env, (TaskListener)listener);
            p.getPublishersList().clear();
            FreeStyleBuild b2 = this.r.buildAndAssertSuccess(p);
            ((StashManager.CopyStashesAndArtifacts)ExtensionList.lookupSingleton(StashManager.CopyStashesAndArtifacts.class)).copy((Run)b, (Run)b2, (TaskListener)listener);
            StashManager.unstash((Run)b2, (String)"stuff", (FilePath)ws, (Launcher)launcher, (EnvVars)env, (TaskListener)listener);
            Assert.assertEquals((Object)"content", (Object)ws.child("file").readToString());
            StashManager.unstash((Run)b2, (String)"empty", (FilePath)ws, (Launcher)launcher, (EnvVars)env, (TaskListener)listener);
            VirtualFile root = b2.getArtifactManager().root();
            new Verify(agent, root, this.weirdCharacters).run();
            StashManager.clearAll((Run)b, (TaskListener)listener);
            Assert.assertTrue((boolean)b.getArtifactManager().root().child("file").isFile());
            ws.deleteContents();
            Assert.assertFalse((boolean)ws.child("file").exists());
            this.f.apply(p, b, ws, launcher, env, (TaskListener)listener);
        }
    }

    @FunctionalInterface
    private static interface TestStashFunction {
        public void apply(FreeStyleProject var1, FreeStyleBuild var2, FilePath var3, Launcher var4, EnvVars var5, TaskListener var6) throws Exception;
    }

    private static class FindEncoding
    extends MasterToSlaveCallable<String, Exception> {
        private FindEncoding() {
        }

        public String call() {
            return System.getProperty("file.encoding") + " vs. " + System.getProperty("sun.jnu.encoding");
        }
    }

    private static class Verify {
        private final DumbSlave agent;
        private final VirtualFile root;
        private final boolean weirdCharacters;

        Verify(DumbSlave agent, VirtualFile root, boolean weirdCharacters) {
            this.agent = agent;
            this.root = root;
            this.weirdCharacters = weirdCharacters;
        }

        void run() throws Exception {
            this.test();
            if (Util.isOverridden(VirtualFile.class, this.root.getClass(), (String)"run", (Class[])new Class[]{Callable.class})) {
                for (VirtualFile f : Arrays.asList(this.root, this.root.child("some"), this.root.child("file"), this.root.child("does-not-exist"))) {
                    System.err.println("testing batch operations starting from " + String.valueOf(f));
                    f.run((Callable)new VerifyBatch(this));
                }
            }
        }

        private void test() throws Exception {
            MatcherAssert.assertThat((String)"root name is unspecified generally", (Object)this.root.getName(), (Matcher)Matchers.not((Matcher)Matchers.endsWith((String)"/")));
            VirtualFile file = this.root.child("file");
            Assert.assertEquals((Object)"file", (Object)file.getName());
            this.assertFile(file, "content");
            Assert.assertEquals((Object)this.root, (Object)file.getParent());
            VirtualFile some = this.root.child("some");
            Assert.assertEquals((Object)"some", (Object)some.getName());
            ArtifactManagerTest.assertDir(some);
            Assert.assertEquals((Object)this.root, (Object)some.getParent());
            MatcherAssert.assertThat((Object)this.root.list(), (Matcher)Matchers.arrayContainingInAnyOrder((Object[])new VirtualFile[]{file, some, this.root.child("otherdir"), this.root.child(".git")}));
            MatcherAssert.assertThat((Object)this.root.list("file", null, false), (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"file"}));
            VirtualFile subfile = this.root.child("some/deeply/nested/dir/subfile");
            Assert.assertEquals((Object)"subfile", (Object)subfile.getName());
            this.assertFile(subfile, "content");
            VirtualFile someDeeplyNestedDir = some.child("deeply/nested/dir");
            Assert.assertEquals((Object)"dir", (Object)someDeeplyNestedDir.getName());
            ArtifactManagerTest.assertDir(someDeeplyNestedDir);
            Assert.assertEquals((Object)some, (Object)someDeeplyNestedDir.getParent().getParent().getParent());
            Assert.assertEquals(Collections.singletonList(subfile), Arrays.asList(someDeeplyNestedDir.list()));
            MatcherAssert.assertThat((Object)someDeeplyNestedDir.list("subfile", null, false), (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"subfile"}));
            MatcherAssert.assertThat((Object)this.root.list("**/*file", null, false), (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"file", "some/deeply/nested/dir/subfile"}));
            MatcherAssert.assertThat((Object)some.list("**/*file", null, false), (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"deeply/nested/dir/subfile"}));
            MatcherAssert.assertThat((Object)this.root.list("**", "**/xxx*", true), (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"file", "some/deeply/nested/dir/subfile"}));
            if (this.weirdCharacters) {
                this.assertFile(this.root.child("otherdir/xxx#?:$&'\"<>\u010d\u0950"), "whatever");
            }
            ArtifactManagerTest.assertNonexistent(this.root.child("does-not-exist"));
            ArtifactManagerTest.assertNonexistent(this.root.child("some/deeply/nested/dir/does-not-exist"));
        }

        private void assertFile(VirtualFile f, String contents) throws Exception {
            System.err.println("Asserting file: " + String.valueOf(f));
            Assert.assertTrue((String)("Not a file: " + String.valueOf(f)), (boolean)f.isFile());
            Assert.assertFalse((String)("Unexpected directory: " + String.valueOf(f)), (boolean)f.isDirectory());
            Assert.assertTrue((String)("Does not exist: " + String.valueOf(f)), (boolean)f.exists());
            Assert.assertEquals((long)contents.length(), (long)f.length());
            MatcherAssert.assertThat((Object)f.lastModified(), (Matcher)Matchers.not((Matcher)Matchers.is((Object)0)));
            try (InputStream is = f.open();){
                Assert.assertEquals((Object)contents, (Object)IOUtils.toString((InputStream)is, (Charset)StandardCharsets.UTF_8));
            }
            URL url = f.toExternalURL();
            if (url != null) {
                System.err.println("opening " + String.valueOf(url));
                Assert.assertEquals((Object)contents, (Object)this.agent.getChannel().call((Callable)new RemoteOpenURL(url)));
            }
        }

        private static class VerifyBatch
        extends MasterToSlaveCallable<Void, IOException> {
            private final Verify verification;

            VerifyBatch(Verify verification) {
                this.verification = verification;
            }

            public Void call() throws IOException {
                try {
                    this.verification.test();
                }
                catch (IOException | RuntimeException x) {
                    throw x;
                }
                catch (Exception x) {
                    throw new IOException(x);
                }
                return null;
            }
        }

        private static final class RemoteOpenURL
        extends MasterToSlaveCallable<String, IOException> {
            private final URL u;

            RemoteOpenURL(URL u) {
                this.u = u;
            }

            public String call() throws IOException {
                return IOUtils.toString((URL)this.u, (Charset)StandardCharsets.UTF_8);
            }
        }
    }
}

