/*
 * Decompiled with CFR 0.152.
 */
package com.microsoftopentechnologies.windowsazurestorage.helper;

import com.cloudbees.plugins.credentials.CredentialsMatcher;
import com.cloudbees.plugins.credentials.CredentialsMatchers;
import com.cloudbees.plugins.credentials.CredentialsProvider;
import com.cloudbees.plugins.credentials.CredentialsScope;
import com.cloudbees.plugins.credentials.impl.BaseStandardCredentials;
import com.microsoftopentechnologies.windowsazurestorage.Messages;
import com.microsoftopentechnologies.windowsazurestorage.beans.StorageAccountInfo;
import com.microsoftopentechnologies.windowsazurestorage.exceptions.WAStorageException;
import com.microsoftopentechnologies.windowsazurestorage.helper.AzureUtils;
import com.microsoftopentechnologies.windowsazurestorage.helper.Utils;
import hudson.Extension;
import hudson.model.Item;
import hudson.model.ItemGroup;
import hudson.security.ACL;
import hudson.util.FormValidation;
import hudson.util.Secret;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import jenkins.model.Jenkins;
import org.apache.commons.lang.StringUtils;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;
import org.springframework.security.core.Authentication;

public class AzureStorageAccount
extends BaseStandardCredentials {
    private static final List<String> LOCAL_ADDRESSES = Arrays.asList("127.0.0.1", "localhost", "::1", "0.0.0.0");
    private final StorageAccountCredential storageData;

    @DataBoundConstructor
    public AzureStorageAccount(CredentialsScope scope, String id, String description, String storageAccountName, String storageKey, String blobEndpointURL, String cdnEndpointURL) {
        super(scope, id, description);
        this.storageData = new StorageAccountCredential(storageAccountName, storageKey, blobEndpointURL, cdnEndpointURL);
    }

    public static StorageAccountCredential getStorageAccountCredential(Item owner, String storageCredentialId) {
        if (StringUtils.isBlank((String)storageCredentialId)) {
            return null;
        }
        AzureStorageAccount creds = (AzureStorageAccount)CredentialsMatchers.firstOrNull((Iterable)CredentialsProvider.lookupCredentialsInItem(AzureStorageAccount.class, (Item)owner, (Authentication)ACL.SYSTEM2, Collections.emptyList()), (CredentialsMatcher)CredentialsMatchers.withId((String)storageCredentialId));
        if (creds == null) {
            return new StorageAccountCredential();
        }
        return creds.storageData;
    }

    @Deprecated
    public static StorageAccountCredential getStorageAccountCredential(String storageCredentialId) {
        return AzureStorageAccount.getStorageAccountCredential(null, storageCredentialId);
    }

    @Deprecated
    public static StorageAccountCredential getStorageCreds(String credentialsId, String storageAccName) {
        try {
            if (credentialsId != null) {
                StorageAccountCredential credentials = AzureStorageAccount.getStorageAccountCredential(null, credentialsId);
                if (credentials != null) {
                    return credentials;
                }
            } else {
                List allCreds = CredentialsProvider.lookupCredentialsInItemGroup(AzureStorageAccount.class, (ItemGroup)Jenkins.getInstance(), (Authentication)ACL.SYSTEM2, Collections.emptyList());
                for (AzureStorageAccount cred : allCreds) {
                    if (!storageAccName.equals(cred.getStorageAccountName())) continue;
                    return cred.getStorageCred();
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public String getStorageAccountName() {
        return this.storageData.storageAccountName;
    }

    public String getPlainStorageKey() {
        return this.storageData.storageAccountKey.getPlainText();
    }

    public String getStorageKey() {
        return this.storageData.storageAccountKey.getEncryptedValue();
    }

    public String getBlobEndpointURL() {
        return this.storageData.getBlobEndpointURL();
    }

    public String getCdnEndpointURL() {
        return this.storageData.getCdnEndpointURL();
    }

    public StorageAccountCredential getStorageCred() {
        return this.storageData;
    }

    public static StorageAccountInfo convertToStorageAccountInfo(StorageAccountCredential storageCreds) {
        return new StorageAccountInfo(storageCreds.getStorageAccountName(), storageCreds.getStorageAccountKey(), storageCreds.getBlobEndpointURL(), storageCreds.getCdnEndpointURL());
    }

    public static class StorageAccountCredential
    implements Serializable {
        private final String storageAccountName;
        private final Secret storageAccountKey;
        private final String blobEndpointURL;
        private final String cdnEndpointURL;

        public StorageAccountCredential(String storageAccountName, String storageKey, String blobEndpointURL, String cdnEndpointURL) {
            this.storageAccountName = storageAccountName;
            this.storageAccountKey = Secret.fromString((String)storageKey);
            String url = blobEndpointURL;
            if (StringUtils.isBlank((String)blobEndpointURL)) {
                url = "https://blob.core.windows.net/";
            }
            this.blobEndpointURL = StorageAccountCredential.joinAccountNameAndEndpoint(storageAccountName, url);
            this.cdnEndpointURL = StringUtils.isBlank((String)cdnEndpointURL) ? "" : cdnEndpointURL;
        }

        private static String joinAccountNameAndEndpoint(String accountName, String urlSuffix) {
            block3: {
                block2: {
                    if (urlSuffix.contains(accountName)) break block2;
                    if (!LOCAL_ADDRESSES.stream().anyMatch(urlSuffix::contains)) break block3;
                }
                return urlSuffix;
            }
            return urlSuffix.replace("http://", "https://").replace("https://", String.format("https://%s.", accountName));
        }

        public StorageAccountCredential() {
            this.storageAccountName = "";
            this.storageAccountKey = Secret.fromString((String)"");
            this.blobEndpointURL = "https://blob.core.windows.net/";
            this.cdnEndpointURL = "";
        }

        public boolean isValidStorageCredential() throws WAStorageException {
            if (StringUtils.isBlank((String)this.storageAccountName)) {
                throw new WAStorageException("Error: Storage Account Name is missing");
            }
            if (StringUtils.isBlank((String)this.storageAccountKey.getPlainText())) {
                throw new WAStorageException("Error: Storage Account Key is missing");
            }
            if (StringUtils.isBlank((String)this.blobEndpointURL)) {
                throw new WAStorageException("Error: blobEndpointURL is invalid or missing");
            }
            return true;
        }

        public String getStorageAccountName() {
            return this.storageAccountName;
        }

        public String getStorageAccountKey() {
            return this.storageAccountKey.getPlainText();
        }

        protected Secret getSecureKey() {
            return this.storageAccountKey;
        }

        public String getBlobEndpointURL() {
            return StorageAccountCredential.joinAccountNameAndEndpoint(this.storageAccountName, this.blobEndpointURL);
        }

        public String getCdnEndpointURL() {
            return this.cdnEndpointURL;
        }

        public String getId() {
            String storageId = this.getStorageAccountName().concat(this.getStorageAccountKey());
            return Utils.getMD5(storageId);
        }
    }

    @Extension
    public static class DescriptorImpl
    extends BaseStandardCredentials.BaseStandardCredentialsDescriptor {
        public String getDisplayName() {
            return "Azure Storage";
        }

        public String getDefaultBlobURL() {
            return "https://blob.core.windows.net/";
        }

        public FormValidation doVerifyConfiguration(@QueryParameter String storageAccountName, @QueryParameter Secret storageKey, @QueryParameter String blobEndpointURL, @QueryParameter String cdnEndpointURL) {
            try {
                StorageAccountInfo storageAccount = new StorageAccountInfo(storageAccountName, storageKey.getPlainText(), blobEndpointURL, cdnEndpointURL);
                AzureUtils.validateStorageAccount(storageAccount, false);
            }
            catch (Exception e) {
                return FormValidation.error((Throwable)e, (String)e.getMessage());
            }
            return FormValidation.ok((String)Messages.WAStoragePublisher_SA_val());
        }
    }
}

