/*
 * Decompiled with CFR 0.152.
 */
package com.microsoftopentechnologies.windowsazurestorage;

import com.microsoftopentechnologies.windowsazurestorage.service.model.PartialBlobProperties;
import hudson.EnvVars;
import hudson.Extension;
import hudson.FilePath;
import hudson.Util;
import hudson.model.Describable;
import hudson.model.Descriptor;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import jenkins.model.Jenkins;
import org.apache.commons.lang.StringUtils;
import org.apache.tika.Tika;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;

public class AzureBlobProperties
implements Describable<AzureBlobProperties> {
    private String cacheControl;
    private String contentEncoding;
    private String contentLanguage;
    private String contentType;
    private boolean detectContentType = true;

    public AzureBlobProperties(String cacheControl, String contentEncoding, String contentLanguage, String contentType, boolean detectContentType) {
        this.cacheControl = Util.fixEmpty((String)cacheControl);
        this.contentEncoding = Util.fixEmpty((String)contentEncoding);
        this.contentLanguage = Util.fixEmpty((String)contentLanguage);
        this.contentType = Util.fixEmpty((String)contentType);
        this.detectContentType = detectContentType;
    }

    @DataBoundConstructor
    public AzureBlobProperties() {
    }

    public String getCacheControl() {
        return this.cacheControl;
    }

    public String getContentEncoding() {
        return this.contentEncoding;
    }

    public String getContentLanguage() {
        return this.contentLanguage;
    }

    public String getContentType() {
        return this.contentType;
    }

    public boolean getDetectContentType() {
        return this.detectContentType;
    }

    @DataBoundSetter
    public void setCacheControl(String cacheControl) {
        this.cacheControl = Util.fixEmpty((String)cacheControl);
    }

    @DataBoundSetter
    public void setContentEncoding(String contentEncoding) {
        this.contentEncoding = Util.fixEmpty((String)contentEncoding);
    }

    @DataBoundSetter
    public void setContentLanguage(String contentLanguage) {
        this.contentLanguage = Util.fixEmpty((String)contentLanguage);
    }

    @DataBoundSetter
    public void setContentType(String contentType) {
        this.contentType = Util.fixEmpty((String)contentType);
    }

    @DataBoundSetter
    public void setDetectContentType(boolean detectContentType) {
        this.detectContentType = detectContentType;
    }

    public PartialBlobProperties configure(FilePath src, EnvVars env) throws InterruptedException, IOException {
        String resolvedContentType = Util.replaceMacro((String)this.contentType, (Map)env);
        if (StringUtils.isBlank((String)resolvedContentType) && this.detectContentType) {
            resolvedContentType = this.detectContentType(src);
        }
        return new PartialBlobProperties(Util.replaceMacro((String)this.contentEncoding, (Map)env), Util.replaceMacro((String)this.contentLanguage, (Map)env), Util.replaceMacro((String)this.cacheControl, (Map)env), resolvedContentType);
    }

    private String detectContentType(FilePath file) throws InterruptedException, IOException {
        Tika tika = new Tika();
        try (InputStream stream = file.read();){
            if (file.getName().toLowerCase().endsWith(".js")) {
                String string = "application/javascript";
                return string;
            }
            String string = tika.detect(stream, file.getName());
            return string;
        }
    }

    public Descriptor<AzureBlobProperties> getDescriptor() {
        Jenkins instance = Jenkins.getInstance();
        return instance.getDescriptor(this.getClass());
    }

    @Extension
    public static final class DescriptorImpl
    extends Descriptor<AzureBlobProperties> {
    }
}

