/*
 * Decompiled with CFR 0.152.
 */
package com.microsoftopentechnologies.windowsazurestorage.service;

import com.azure.core.credential.AzureSasCredential;
import com.azure.core.http.rest.PagedIterable;
import com.azure.storage.file.share.ShareClient;
import com.azure.storage.file.share.ShareDirectoryClient;
import com.azure.storage.file.share.ShareFileClient;
import com.azure.storage.file.share.ShareServiceClient;
import com.azure.storage.file.share.ShareServiceClientBuilder;
import com.azure.storage.file.share.models.ShareFileItem;
import com.microsoftopentechnologies.windowsazurestorage.beans.StorageAccountInfo;
import com.microsoftopentechnologies.windowsazurestorage.exceptions.WAStorageException;
import com.microsoftopentechnologies.windowsazurestorage.helper.AzureUtils;
import com.microsoftopentechnologies.windowsazurestorage.service.UploadService;
import com.microsoftopentechnologies.windowsazurestorage.service.model.PartialBlobProperties;
import com.microsoftopentechnologies.windowsazurestorage.service.model.UploadServiceData;
import com.microsoftopentechnologies.windowsazurestorage.service.model.UploadType;
import hudson.FilePath;
import hudson.ProxyConfiguration;
import hudson.remoting.VirtualChannel;
import hudson.util.DirScanner;
import io.jenkins.plugins.azuresdk.HttpClientRetriever;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import jenkins.MasterToSlaveFileCallable;
import jenkins.model.Jenkins;
import org.apache.commons.lang.StringUtils;

public class UploadToFileService
extends UploadService {
    public UploadToFileService(UploadServiceData serviceData) {
        super(serviceData);
    }

    @Override
    protected void uploadIndividuals(String embeddedVP, FilePath[] paths, FilePath workspace) throws WAStorageException {
        this.uploadIndividuals(embeddedVP, paths);
    }

    @Override
    protected void uploadIndividuals(String embeddedVP, FilePath[] paths) throws WAStorageException {
        UploadServiceData serviceData = (UploadServiceData)this.getServiceData();
        FilePath workspace = ((UploadServiceData)this.getServiceData()).getRemoteWorkspace();
        try {
            ShareClient fileShare = this.getCloudFileShare();
            UploadType uploadType = serviceData.getUploadType();
            if (uploadType == UploadType.INDIVIDUAL || uploadType == UploadType.BOTH) {
                this.cleanupFileShare(fileShare);
            }
            ArrayList<UploadService.UploadObject> uploadObjects = new ArrayList<UploadService.UploadObject>();
            for (FilePath src : paths) {
                String filePath = this.getItemPath(src, embeddedVP, serviceData);
                ShareDirectoryClient rootDirectoryClient = fileShare.getRootDirectoryClient();
                ShareFileClient cloudFile = rootDirectoryClient.getFileClient(filePath);
                this.ensureDirExist(fileShare, filePath);
                UploadService.UploadObject uploadObject = this.generateUploadObject(src, serviceData.getStorageAccountInfo(), cloudFile, fileShare.getShareName(), null, this.updateMetadata(new HashMap<String, String>()));
                uploadObjects.add(uploadObject);
            }
            List results = (List)workspace.act((FilePath.FileCallable)new UploadOnAgent(Jenkins.get().getProxy(), uploadObjects));
            this.updateAzureBlobs(results, serviceData.getIndividualBlobs());
        }
        catch (IOException | InterruptedException | URISyntaxException e) {
            throw new WAStorageException("fail to upload individual files to azure file storage", e);
        }
    }

    private UploadService.UploadObject generateUploadObject(FilePath path, StorageAccountInfo accountInfo, ShareFileClient client, String shareName, PartialBlobProperties properties, Map<String, String> metadata) throws MalformedURLException, URISyntaxException {
        String sas = this.generateWriteSASURL(accountInfo, client.getFilePath(), "filestorage", shareName);
        return new UploadService.UploadObject(client.getFilePath(), path, client.getFileUrl(), sas, "filestorage", client.getAccountName(), shareName, properties, metadata);
    }

    @Override
    protected void uploadArchive(String archiveIncludes) throws WAStorageException {
        UploadServiceData serviceData = (UploadServiceData)this.getServiceData();
        try {
            ShareClient fileShare = this.getCloudFileShare();
            if (serviceData.getUploadType() == UploadType.ZIP) {
                this.cleanupFileShare(fileShare);
            }
            FilePath workspacePath = serviceData.getRemoteWorkspace();
            FilePath tempDir = workspacePath.createTempDir("artifactsArchive", null);
            FilePath zipPath = tempDir.child("archive.zip");
            DirScanner.Glob globScanner = new DirScanner.Glob(archiveIncludes, this.excludedFilesAndZip());
            workspacePath.zip(zipPath.write(), (DirScanner)globScanner);
            Object azureFileName = zipPath.getName();
            if (!StringUtils.isBlank((String)serviceData.getVirtualPath())) {
                azureFileName = serviceData.getVirtualPath() + (String)azureFileName;
            }
            ShareFileClient cloudFile = fileShare.getRootDirectoryClient().getFileClient((String)azureFileName);
            Future<?> archiveUploadFuture = this.getExecutorService().submit(new UploadService.FileUploadThread(cloudFile, zipPath, serviceData.getArchiveBlobs()));
            archiveUploadFuture.get();
            tempDir.deleteRecursive();
        }
        catch (IOException | InterruptedException | URISyntaxException | ExecutionException e) {
            throw new WAStorageException("Fail to upload individual files to blob", e);
        }
    }

    private ShareClient getCloudFileShare() throws URISyntaxException, MalformedURLException {
        UploadServiceData serviceData = (UploadServiceData)this.getServiceData();
        ShareServiceClient cloudStorageAccount = AzureUtils.getShareClient(serviceData.getStorageAccountInfo());
        ShareClient fileShare = cloudStorageAccount.getShareClient(serviceData.getFileShareName());
        if (!fileShare.exists().booleanValue()) {
            fileShare.create();
        }
        return fileShare;
    }

    private void cleanupFileShare(ShareClient fileShare) throws URISyntaxException {
        ShareDirectoryClient directory;
        UploadServiceData serviceData = (UploadServiceData)this.getServiceData();
        if (serviceData.isCleanUpContainerOrShare() && fileShare.exists().booleanValue()) {
            this.println("Clean up existing files in file share " + serviceData.getFileShareName());
            this.deleteFiles(fileShare, (PagedIterable<ShareFileItem>)fileShare.getRootDirectoryClient().listFilesAndDirectories());
        } else if (serviceData.isCleanUpVirtualPath() && StringUtils.isNotBlank((String)serviceData.getVirtualPath()) && fileShare.exists().booleanValue() && (directory = fileShare.getDirectoryClient(serviceData.getVirtualPath())).exists().booleanValue()) {
            this.println("Clean up existing files in file share directory " + serviceData.getVirtualPath());
            this.deleteFiles(fileShare, (PagedIterable<ShareFileItem>)directory.listFilesAndDirectories());
        }
    }

    private void ensureDirExist(ShareClient shareClient, String filePath) {
        String[] directories;
        ShareDirectoryClient rootDirectoryClient = shareClient.getRootDirectoryClient();
        if (!rootDirectoryClient.exists().booleanValue()) {
            rootDirectoryClient.create();
        }
        if ((directories = filePath.split("/")).length > 1) {
            if (!filePath.endsWith("/")) {
                directories = Arrays.copyOf(directories, directories.length - 1);
            }
            for (int i = 0; i < directories.length; ++i) {
                String path = this.getPath(directories, i);
                ShareDirectoryClient directoryClient = shareClient.getDirectoryClient(path);
                if (directoryClient.exists().booleanValue()) continue;
                directoryClient.create();
            }
        }
    }

    private String getPath(String[] directories, int i) {
        CharSequence[] partialDirPath = Arrays.copyOfRange(directories, 0, i + 1);
        return String.join((CharSequence)"/", partialDirPath);
    }

    private void deleteFiles(ShareClient fileShare, PagedIterable<ShareFileItem> fileItems) {
        for (ShareFileItem fileItem : fileItems) {
            if (fileItem.isDirectory()) {
                ShareDirectoryClient directory = fileShare.getDirectoryClient(fileItem.getName());
                this.deleteFiles(fileShare, (PagedIterable<ShareFileItem>)directory.listFilesAndDirectories());
                continue;
            }
            fileShare.getFileClient(fileItem.getName()).delete();
        }
    }

    static final class UploadOnAgent
    extends MasterToSlaveFileCallable<List<UploadService.UploadResult>> {
        private static final Logger LOGGER = Logger.getLogger(UploadOnAgent.class.getName());
        private static final int ERROR_ON_UPLOAD = 500;
        private final ProxyConfiguration proxy;
        private final List<UploadService.UploadObject> uploadObjects;

        UploadOnAgent(ProxyConfiguration proxy, List<UploadService.UploadObject> uploadObjects) {
            this.proxy = proxy;
            this.uploadObjects = uploadObjects;
        }

        private ShareServiceClient getFileShareClient(UploadService.UploadObject uploadObject) {
            return new ShareServiceClientBuilder().credential(new AzureSasCredential(uploadObject.getSas())).httpClient(HttpClientRetriever.get((ProxyConfiguration)this.proxy)).endpoint(uploadObject.getUrl()).buildClient();
        }

        public List<UploadService.UploadResult> invoke(File f, VirtualChannel channel) {
            return this.uploadObjects.parallelStream().map(uploadObject -> {
                ShareServiceClient fileShareClient = this.getFileShareClient((UploadService.UploadObject)uploadObject);
                ShareClient shareClient = fileShareClient.getShareClient(uploadObject.getContainerOrShareName());
                ShareFileClient fileClient = shareClient.getFileClient(uploadObject.getName());
                return this.uploadCloudFile(fileClient, (UploadService.UploadObject)uploadObject);
            }).collect(Collectors.toList());
        }

        private UploadService.UploadResult uploadCloudFile(ShareFileClient fileClient, UploadService.UploadObject uploadObject) {
            long startTime = System.currentTimeMillis();
            File file = new File(uploadObject.getSrc().getRemote());
            try {
                long bytes = Files.size(file.toPath());
                fileClient.create(bytes);
                fileClient.uploadFromFile(file.getAbsolutePath());
                long endTime = System.currentTimeMillis();
                return new UploadService.UploadResult(201, null, uploadObject.getName(), uploadObject.getUrl(), file.length(), uploadObject.getStorageType(), startTime, endTime);
            }
            catch (Exception e) {
                LOGGER.log(Level.SEVERE, "Failed uploading file", e);
                return new UploadService.UploadResult(500, null, file.getName(), uploadObject.getUrl(), file.length(), uploadObject.getStorageType(), startTime, 0L);
            }
        }
    }
}

