/*
 * Decompiled with CFR 0.152.
 */
package com.microsoftopentechnologies.windowsazurestorage.helper;

import com.microsoftopentechnologies.windowsazurestorage.helper.CredentialMigration;
import com.microsoftopentechnologies.windowsazurestorage.helper.Utils;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.io.FileUtils;

public final class CredentialRename {
    private static final String BACKUP_SUFFIX = ".backup";
    private static final String SOURCE_CONTENT = "com.microsoftopentechnologies.windowsazurestorage.helper.AzureCredentials";
    private static final String TARGET_CONTENT = "com.microsoftopentechnologies.windowsazurestorage.helper.AzureStorageAccount";
    private static final Logger LOGGER = Logger.getLogger(CredentialMigration.class.getName());

    private CredentialRename() {
    }

    private static File backupFile(String sourceFile) throws IOException {
        String backupFile = sourceFile + BACKUP_SUFFIX;
        LOGGER.log(Level.INFO, sourceFile + ".backup has been created for backup.");
        File backUp = new File(backupFile);
        FileUtils.copyFile((File)new File(sourceFile), (File)backUp);
        return backUp;
    }

    private static void recoverFile(String backupFile) throws IOException {
        String sourceFile = backupFile.substring(0, backupFile.length() - BACKUP_SUFFIX.length());
        LOGGER.info("Start to recover credentials.xml with " + backupFile);
        File source = new File(sourceFile);
        try {
            FileUtils.copyFile((File)new File(backupFile), (File)source);
        }
        catch (IOException e) {
            LOGGER.warning("Fail to recover credentials with backup file, please manually recover it.");
            throw e;
        }
        CredentialRename.removeFile(backupFile);
    }

    public static void renameStorageConfig() throws IOException {
        File sourceFile = new File(Utils.getWorkDirectory(), "credentials.xml");
        if (!sourceFile.exists()) {
            return;
        }
        Path path = Paths.get(sourceFile.getCanonicalPath(), new String[0]);
        if (CredentialRename.renameNotNeededFor(path)) {
            return;
        }
        LOGGER.log(Level.INFO, String.valueOf(sourceFile) + " exists, rename azure storage credential will start now...");
        File backUp = CredentialRename.backupFile(sourceFile.getCanonicalPath());
        try (Stream<String> stream = Files.lines(path);){
            List collect = stream.map(s -> s.replace(SOURCE_CONTENT, TARGET_CONTENT)).collect(Collectors.toList());
            Files.write(path, collect, new OpenOption[0]);
        }
        catch (IOException e) {
            LOGGER.warning("Failed to rename azure storage credential in credentials.xml file");
            CredentialRename.recoverFile(backUp.getCanonicalPath());
        }
        CredentialRename.removeFile(backUp.getCanonicalPath());
    }

    private static boolean renameNotNeededFor(Path path) throws IOException {
        try (Stream<String> stream = Files.lines(path);){
            boolean needRename = stream.anyMatch(s -> s.contains(SOURCE_CONTENT));
            if (!needRename) {
                boolean bl = true;
                return bl;
            }
        }
        return false;
    }

    private static void removeFile(String sourceFile) {
        File file = new File(sourceFile);
        if (file.delete()) {
            LOGGER.log(Level.INFO, file.getName() + " is deleted!");
        } else {
            LOGGER.log(Level.WARNING, file.getName() + "deletion is failed.");
        }
    }
}

