/*
 * Decompiled with CFR 0.152.
 */
package com.microsoftopentechnologies.windowsazurestorage.helper;

import com.cloudbees.plugins.credentials.Credentials;
import com.cloudbees.plugins.credentials.CredentialsMatcher;
import com.cloudbees.plugins.credentials.CredentialsMatchers;
import com.cloudbees.plugins.credentials.CredentialsProvider;
import com.cloudbees.plugins.credentials.CredentialsScope;
import com.cloudbees.plugins.credentials.CredentialsStore;
import com.cloudbees.plugins.credentials.domains.Domain;
import com.microsoftopentechnologies.windowsazurestorage.beans.StorageAccountInfo;
import com.microsoftopentechnologies.windowsazurestorage.helper.AzureStorageAccount;
import com.microsoftopentechnologies.windowsazurestorage.helper.Utils;
import hudson.model.ItemGroup;
import hudson.model.ModelObject;
import hudson.security.ACL;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import jenkins.model.Jenkins;
import org.apache.commons.io.FileUtils;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.security.core.context.SecurityContextHolder;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public final class CredentialMigration {
    private static final Logger LOGGER = Logger.getLogger(CredentialMigration.class.getName());

    protected static List<StorageAccountInfo> getOldStorageConfig(File inputFile) throws SAXException, IOException, ParserConfigurationException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = factory.newDocumentBuilder();
        Document document = builder.parse(inputFile);
        ArrayList<StorageAccountInfo> storages = new ArrayList<StorageAccountInfo>();
        NodeList nodeList = document.getElementsByTagName("com.microsoftopentechnologies.windowsazurestorage.beans.StorageAccountInfo");
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            if (node.getNodeType() != 1) continue;
            Element elem = (Element)node;
            String accName = elem.getElementsByTagName("storageAccName").item(0).getChildNodes().item(0).getNodeValue();
            String accKey = elem.getElementsByTagName("storageAccountKey").item(0).getChildNodes().item(0).getNodeValue();
            String blobURL = elem.getElementsByTagName("blobEndPointURL").item(0).getChildNodes().item(0).getNodeValue();
            storages.add(new StorageAccountInfo(accName, accKey, blobURL, ""));
        }
        return storages;
    }

    private static File backupFile(String sourceFile) throws IOException {
        String backupFile = sourceFile + ".backup";
        LOGGER.log(Level.INFO, sourceFile + ".backup has been created for backup.");
        File backUp = new File(backupFile);
        FileUtils.copyFile((File)new File(sourceFile), (File)backUp);
        return backUp;
    }

    private static void removeFile(String sourceFile) throws IOException {
        File file = new File(sourceFile);
        if (file.delete()) {
            LOGGER.log(Level.INFO, file.getName() + " is deleted!");
        } else {
            LOGGER.log(Level.WARNING, file.getName() + "deletion is failed.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void upgradeStorageConfig() throws Exception {
        File sourceFile = new File(Utils.getWorkDirectory(), "com.microsoftopentechnologies.windowsazurestorage.WAStoragePublisher.xml");
        try {
            if (!sourceFile.exists()) {
                return;
            }
            LOGGER.log(Level.INFO, String.valueOf(sourceFile) + " exists, upgrade will start now...");
            File backUp = CredentialMigration.backupFile(sourceFile.getCanonicalPath());
            List<StorageAccountInfo> oldStorages = CredentialMigration.getOldStorageConfig(sourceFile);
            for (StorageAccountInfo sa : oldStorages) {
                String storageAccount = sa.getStorageAccName();
                String storageAccountKey = sa.getStorageAccountKey();
                String storageBlobURL = sa.getBlobEndPointURL();
                AzureStorageAccount.StorageAccountCredential u = new AzureStorageAccount.StorageAccountCredential(storageAccount, storageAccountKey, storageBlobURL, "");
                AzureStorageAccount cred = (AzureStorageAccount)CredentialsMatchers.firstOrNull((Iterable)CredentialsProvider.lookupCredentialsInItemGroup(AzureStorageAccount.class, (ItemGroup)Jenkins.getInstance(), (Authentication)ACL.SYSTEM2, Collections.emptyList()), (CredentialsMatcher)CredentialsMatchers.withId((String)u.getId()));
                if (cred != null) {
                    return;
                }
                LOGGER.log(Level.INFO, "Moving Storage Account names and their keys to credential store, a creddential Id will be created for each pair of account name and key.");
                AzureStorageAccount tempCred = new AzureStorageAccount(CredentialsScope.GLOBAL, Utils.getMD5(storageAccount.concat(storageAccountKey)), "credential for " + storageAccount, storageAccount, storageAccountKey, storageBlobURL, "");
                SecurityContext securityContext = ACL.impersonate2((Authentication)ACL.SYSTEM2);
                try {
                    CredentialsStore s = (CredentialsStore)CredentialsProvider.lookupStores((ModelObject)Jenkins.getInstance()).iterator().next();
                    try {
                        s.addCredentials(Domain.global(), (Credentials)tempCred);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                finally {
                    SecurityContextHolder.setContext((SecurityContext)securityContext);
                }
            }
            LOGGER.log(Level.INFO, "Migrated successfully, deleting legacy config files...");
            CredentialMigration.removeFile(sourceFile.getCanonicalPath());
            CredentialMigration.removeFile(backUp.getCanonicalPath());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private CredentialMigration() {
    }
}

