/*
 * Decompiled with CFR 0.152.
 */
package com.microsoftopentechnologies.windowsazurestorage.service;

import com.azure.core.credential.AzureSasCredential;
import com.azure.core.http.rest.Response;
import com.azure.core.util.Context;
import com.azure.storage.blob.BlobClient;
import com.azure.storage.blob.BlobContainerClient;
import com.azure.storage.blob.BlobServiceClient;
import com.azure.storage.blob.BlobServiceClientBuilder;
import com.azure.storage.blob.BlobUrlParts;
import com.azure.storage.blob.models.BlobHttpHeaders;
import com.azure.storage.blob.options.BlobUploadFromFileOptions;
import com.azure.storage.blob.sas.BlobSasPermission;
import com.azure.storage.file.share.ShareFileClient;
import com.azure.storage.file.share.sas.ShareFileSasPermission;
import com.microsoftopentechnologies.windowsazurestorage.AzureBlob;
import com.microsoftopentechnologies.windowsazurestorage.AzureBlobMetadataPair;
import com.microsoftopentechnologies.windowsazurestorage.Messages;
import com.microsoftopentechnologies.windowsazurestorage.beans.StorageAccountInfo;
import com.microsoftopentechnologies.windowsazurestorage.exceptions.WAStorageException;
import com.microsoftopentechnologies.windowsazurestorage.helper.AzureUtils;
import com.microsoftopentechnologies.windowsazurestorage.service.StoragePluginService;
import com.microsoftopentechnologies.windowsazurestorage.service.model.PartialBlobProperties;
import com.microsoftopentechnologies.windowsazurestorage.service.model.UploadServiceData;
import com.microsoftopentechnologies.windowsazurestorage.service.model.UploadType;
import hudson.EnvVars;
import hudson.FilePath;
import hudson.ProxyConfiguration;
import hudson.Util;
import hudson.remoting.VirtualChannel;
import io.jenkins.plugins.azuresdk.HttpClientRetriever;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.MasterToSlaveFileCallable;
import org.apache.commons.lang.StringUtils;

public abstract class UploadService
extends StoragePluginService<UploadServiceData> {
    protected static final String ZIP_FOLDER_NAME = "artifactsArchive";
    protected static final String ZIP_NAME = "archive.zip";
    private static final int UPLOAD_THREAD_COUNT = 16;
    private static final int KEEP_ALIVE_TIME = 1;
    private static final int TIME_OUT = 1;
    private static final TimeUnit TIME_OUT_UNIT = TimeUnit.DAYS;
    private static final Logger LOGGER = Logger.getLogger(UploadService.class.getName());
    private AtomicInteger filesUploaded = new AtomicInteger(0);
    private ExecutorService executorService = new ThreadPoolExecutor(16, 16, 1L, TimeUnit.SECONDS, new LinkedBlockingDeque<Runnable>());

    protected UploadService(UploadServiceData serviceData) {
        super(serviceData);
    }

    protected void updateAzureBlobs(List<UploadResult> results, List<AzureBlob> azureBlobs) throws WAStorageException {
        for (UploadResult result : results) {
            if (result.getStatusCode() != 201) continue;
            UploadServiceData serviceData = (UploadServiceData)this.getServiceData();
            String containerOrFileShareName = result.getStorageType().equals("filestorage") ? serviceData.getFileShareName() : serviceData.getContainerName();
            AzureBlob azureBlob = new AzureBlob(result.getName(), result.getUrl(), result.getByteSize(), result.getStorageType(), serviceData.getCredentialsId(), containerOrFileShareName);
            this.filesUploaded.addAndGet(1);
            azureBlobs.add(azureBlob);
            long interval = result.getEndTime() - result.getStartTime();
            if (!serviceData.isVerbose()) continue;
            this.println(Messages.UploadService_https_uploaded(result.getUrl(), this.getTime(interval)));
        }
    }

    protected String generateWriteSASURL(StorageAccountInfo storageAccountInfo, String fileName, String storageType, String name) throws MalformedURLException, URISyntaxException {
        if (storageType.equalsIgnoreCase("blobstorage")) {
            return AzureUtils.generateBlobSASURL(storageAccountInfo, name, fileName, new BlobSasPermission().setWritePermission(true));
        }
        if (storageType.equalsIgnoreCase("filestorage")) {
            return AzureUtils.generateFileSASURL(storageAccountInfo, name, fileName, new ShareFileSasPermission().setWritePermission(true));
        }
        throw new IllegalStateException("Unknown storage type. Please re-configure your job and build again.");
    }

    protected abstract void uploadIndividuals(String var1, FilePath[] var2, FilePath var3) throws WAStorageException;

    protected abstract void uploadIndividuals(String var1, FilePath[] var2) throws WAStorageException;

    protected abstract void uploadArchive(String var1) throws WAStorageException;

    @Override
    public final int execute() throws WAStorageException {
        UploadServiceData serviceData = (UploadServiceData)this.getServiceData();
        if (serviceData.getUploadType() == UploadType.INVALID) {
            this.println("Upload type is INVALID, nothing to do.");
            return 0;
        }
        if (serviceData.isVerbose()) {
            this.println(Messages.WAStoragePublisher_container_name(serviceData.getContainerName()));
            this.println(Messages.WAStoragePublisher_share_name(serviceData.getFileShareName()));
            this.println(Messages.WAStoragePublisher_filepath(serviceData.getFilePath()));
            this.println(Messages.WAStoragePublisher_virtualpath(serviceData.getVirtualPath()));
            this.println(Messages.WAStoragePublisher_excludepath(serviceData.getExcludedFilesPath()));
            this.println(Messages.WAStoragePublisher_excludePrefix(serviceData.getRemovePrefixPath()));
        }
        int filesNeedUpload = 0;
        int filesCount = 0;
        try {
            FilePath workspacePath = serviceData.getRemoteWorkspace();
            if (serviceData.isVerbose()) {
                this.println(Messages.WAStoragePublisher_uploading());
            }
            StringBuilder archiveIncludes = new StringBuilder();
            StringTokenizer strTokens = new StringTokenizer(serviceData.getFilePath(), ",");
            while (strTokens.hasMoreElements()) {
                FilePath[] paths;
                String fileName = strTokens.nextToken();
                Object embeddedVP = null;
                if (fileName != null && fileName.contains("::")) {
                    int embVPSepIndex = fileName.indexOf("::");
                    if (fileName.length() > embVPSepIndex + 1) {
                        embeddedVP = fileName.substring(embVPSepIndex + 2);
                        if (StringUtils.isBlank((String)embeddedVP)) {
                            embeddedVP = null;
                        } else if (!((String)embeddedVP).endsWith("/")) {
                            embeddedVP = (String)embeddedVP + "/";
                        }
                    }
                    fileName = fileName.substring(0, embVPSepIndex);
                }
                FilePath[] uploadPaths = paths = workspacePath.list(fileName, this.excludedFilesAndZip());
                if (serviceData.isOnlyUploadModifiedArtifacts()) {
                    ArrayList<FilePath> modifiedPathsList = new ArrayList<FilePath>();
                    for (FilePath path : paths) {
                        if (path.lastModified() < serviceData.getRun().getStartTimeInMillis()) continue;
                        modifiedPathsList.add(path);
                    }
                    uploadPaths = modifiedPathsList.toArray(new FilePath[0]);
                }
                archiveIncludes.append(",").append(fileName);
                filesNeedUpload += uploadPaths.length;
                filesCount += paths.length;
                if (uploadPaths.length == 0 || serviceData.getUploadType() == UploadType.ZIP) continue;
                this.uploadIndividuals((String)embeddedVP, uploadPaths, workspacePath);
            }
            if (filesCount != 0 && serviceData.getUploadType() != UploadType.INDIVIDUAL) {
                this.uploadArchive(archiveIncludes.toString());
                this.filesUploaded.decrementAndGet();
            }
            if (serviceData.isVerbose()) {
                this.println(Messages.WAStoragePublisher_files_need_upload_count(filesNeedUpload));
            }
            this.waitForUploadEnd();
        }
        catch (IOException | InterruptedException e) {
            throw new WAStorageException(e.getMessage(), e);
        }
        if (serviceData.getUploadType() != UploadType.ZIP && this.filesUploaded.get() != filesNeedUpload) {
            throw new WAStorageException(String.format("Only %d/%d files are successfully uploaded.", this.filesUploaded.get(), filesNeedUpload));
        }
        this.println(Messages.WAStoragePublisher_files_uploaded_count(this.filesUploaded.get()));
        return filesCount;
    }

    protected void waitForUploadEnd() throws InterruptedException, WAStorageException {
        this.executorService.shutdown();
        boolean executionFinished = this.executorService.awaitTermination(1L, TIME_OUT_UNIT);
        if (!executionFinished) {
            throw new WAStorageException(Messages.WAStoragePublisher_uploaded_timeout(1, (Object)TIME_OUT_UNIT));
        }
    }

    protected void uploadCloudFile(ShareFileClient fileClient, FilePath localPath) throws WAStorageException {
        long startTime = System.currentTimeMillis();
        File file = new File(localPath.getRemote());
        try {
            long bytes = Files.size(file.toPath());
            fileClient.create(bytes);
            fileClient.uploadFromFile(file.getAbsolutePath());
            long endTime = System.currentTimeMillis();
            if (((UploadServiceData)this.getServiceData()).isVerbose()) {
                this.println("Uploaded file with uri " + fileClient.getFileUrl() + " in " + this.getTime(endTime - startTime));
            }
        }
        catch (Exception e) {
            throw new WAStorageException("Failed uploading file", e);
        }
    }

    protected String excludedFilesAndZip() {
        UploadServiceData serviceData = (UploadServiceData)this.getServiceData();
        Object excludesWithoutZip = "**/artifactsArchive*/archive.zip";
        if (serviceData.getExcludedFilesPath() != null) {
            excludesWithoutZip = serviceData.getExcludedFilesPath() + "," + (String)excludesWithoutZip;
        }
        return excludesWithoutZip;
    }

    protected String removePrefix(URI srcURI, UploadServiceData serviceData) {
        String tmp = srcURI.getPath();
        String removePrefixPath = serviceData.getRemovePrefixPath();
        if (!StringUtils.isBlank((String)removePrefixPath)) {
            if (tmp.startsWith(removePrefixPath)) {
                String tmp1 = tmp.substring(removePrefixPath.length());
                if (serviceData.isVerbose()) {
                    this.println(Messages.UploadService_prefixRemoved(removePrefixPath, tmp, tmp1));
                }
                tmp = tmp1;
            } else if (serviceData.isVerbose()) {
                this.println(Messages.UploadService_prefixNotRemoved(removePrefixPath, tmp));
            }
        }
        return tmp;
    }

    protected String getItemPath(FilePath path, String embeddedVP, UploadServiceData serviceData) throws IOException, InterruptedException {
        URI workspaceURI = serviceData.getRemoteWorkspace().toURI();
        URI srcURI = workspaceURI.relativize(path.toURI());
        String srcURIPath = this.removePrefix(srcURI, serviceData);
        Object prefix = StringUtils.isBlank((String)serviceData.getVirtualPath()) ? "" : serviceData.getVirtualPath();
        if (!StringUtils.isBlank((String)embeddedVP)) {
            prefix = (String)prefix + embeddedVP;
        }
        return (String)prefix + srcURIPath;
    }

    protected Map<String, String> updateMetadata(Map<String, String> metadata) throws IOException, InterruptedException {
        UploadServiceData serviceData = (UploadServiceData)this.getServiceData();
        EnvVars env = serviceData.getRun().getEnvironment(serviceData.getTaskListener());
        if (serviceData.getAzureBlobMetadata() != null) {
            for (AzureBlobMetadataPair pair : serviceData.getAzureBlobMetadata()) {
                String resolvedKey = Util.replaceMacro((String)pair.getKey(), (Map)env);
                String resolvedValue = Util.replaceMacro((String)pair.getValue(), (Map)env);
                if (resolvedKey == null || resolvedKey.trim().length() == 0) {
                    this.println("Ignoring blank metadata key");
                    continue;
                }
                if (resolvedValue == null || resolvedValue.trim().length() == 0) {
                    this.println("Ignoring blank metadata value, key: " + resolvedKey);
                    continue;
                }
                metadata.put(resolvedKey, resolvedValue);
            }
        }
        return metadata;
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    protected static class UploadResult
    implements Serializable {
        private static final long serialVersionUID = -3112548564900823521L;
        private int statusCode;
        private String responseBody;
        private String name;
        private String url;
        private long byteSize;
        private String storageType;
        private long startTime;
        private long endTime;

        public UploadResult(int statusCode, String responseBody, String name, String url, long byteSize, String storageType, long startTime, long endTime) {
            this.statusCode = statusCode;
            this.responseBody = responseBody;
            this.name = name;
            this.url = url;
            this.byteSize = byteSize;
            this.storageType = storageType;
            this.startTime = startTime;
            this.endTime = endTime;
        }

        public int getStatusCode() {
            return this.statusCode;
        }

        public String getResponseBody() {
            return this.responseBody;
        }

        public String getName() {
            return this.name;
        }

        public String getUrl() {
            return this.url;
        }

        public long getByteSize() {
            return this.byteSize;
        }

        public String getStorageType() {
            return this.storageType;
        }

        public long getStartTime() {
            return this.startTime;
        }

        public long getEndTime() {
            return this.endTime;
        }
    }

    static class UploadThread
    implements Callable<UploadResult> {
        private final ProxyConfiguration proxyConfiguration;
        private UploadObject uploadObject;

        UploadThread(ProxyConfiguration proxyConfiguration, UploadObject uploadObject) {
            this.proxyConfiguration = proxyConfiguration;
            this.uploadObject = uploadObject;
        }

        private BlobServiceClient getBlobServiceClient() {
            return new BlobServiceClientBuilder().credential(new AzureSasCredential(this.uploadObject.getSas())).httpClient(HttpClientRetriever.get((ProxyConfiguration)this.proxyConfiguration)).endpoint(this.uploadObject.getUrl()).buildClient();
        }

        @Override
        public UploadResult call() {
            FilePath src = this.uploadObject.getSrc();
            File file = new File(src.getRemote());
            long length = file.length();
            BlobServiceClient blobServiceClient = this.getBlobServiceClient();
            BlobUrlParts blobUrlParts = BlobUrlParts.parse((String)this.uploadObject.getUrl());
            BlobContainerClient containerClient = blobServiceClient.getBlobContainerClient(blobUrlParts.getBlobContainerName());
            BlobClient blockBlobClient = containerClient.getBlobClient(this.uploadObject.getName());
            long startTime = System.currentTimeMillis();
            BlobUploadFromFileOptions options = new BlobUploadFromFileOptions(file.getAbsolutePath()).setHeaders(this.getBlobHttpHeaders()).setMetadata(this.uploadObject.getMetadata());
            Response block = blockBlobClient.uploadFromFileWithResponse(options, null, Context.NONE);
            if (!this.uploadObject.getMetadata().isEmpty()) {
                blockBlobClient.setMetadata(this.uploadObject.getMetadata());
            }
            long endTime = System.currentTimeMillis();
            return new UploadResult(block.getStatusCode(), null, this.uploadObject.getName(), this.uploadObject.getUrl(), length, this.uploadObject.getStorageType(), startTime, endTime);
        }

        private BlobHttpHeaders getBlobHttpHeaders() {
            PartialBlobProperties blobProperties = this.uploadObject.blobProperties;
            BlobHttpHeaders method = new BlobHttpHeaders();
            method.setCacheControl(blobProperties.getCacheControl());
            method.setContentType(blobProperties.getContentType());
            method.setContentEncoding(blobProperties.getContentEncoding());
            method.setContentLanguage(blobProperties.getContentLanguage());
            return method;
        }
    }

    static final class UploadOnSlave
    extends MasterToSlaveFileCallable<List<UploadResult>> {
        private static final long serialVersionUID = -7284277515594786765L;
        private final ProxyConfiguration proxy;
        private final List<UploadObject> uploadObjects;

        UploadOnSlave(ProxyConfiguration proxy, List<UploadObject> uploadObjects) {
            this.proxy = proxy;
            this.uploadObjects = uploadObjects;
        }

        public List<UploadResult> invoke(File f, VirtualChannel channel) throws IOException, InterruptedException {
            ThreadPoolExecutor agentExecutorService = new ThreadPoolExecutor(16, 16, 1L, TimeUnit.SECONDS, new LinkedBlockingDeque<Runnable>());
            ArrayList<Future> futures = new ArrayList<Future>();
            for (UploadObject uploadObject : this.uploadObjects) {
                Future future = agentExecutorService.submit(new UploadThread(this.proxy, uploadObject));
                futures.add(future);
            }
            ArrayList<UploadResult> results = new ArrayList<UploadResult>();
            try {
                for (Future future : futures) {
                    results.add((UploadResult)future.get());
                }
            }
            catch (ExecutionException executionException) {
                throw new IOException(executionException);
            }
            finally {
                agentExecutorService.shutdownNow();
            }
            return results;
        }
    }

    protected static class UploadObject
    implements Serializable {
        private static final long serialVersionUID = -5342773517251888877L;
        private String name;
        private FilePath src;
        private String url;
        private String sas;
        private String storageType;
        private String storageAccount;
        private String containerOrShareName;
        private PartialBlobProperties blobProperties;
        private Map<String, String> metadata;

        public UploadObject(String name, FilePath src, String url, String sas, String storageType, String storageAccount, PartialBlobProperties blobProperties, Map<String, String> metadata) {
            this(name, src, url, sas, storageType, storageAccount, null, blobProperties, metadata);
        }

        public UploadObject(String name, FilePath src, String url, String sas, String storageType, String storageAccount, String containerOrShareName, PartialBlobProperties blobProperties, Map<String, String> metadata) {
            this.name = name;
            this.src = src;
            this.url = url;
            this.sas = sas;
            this.storageType = storageType;
            this.storageAccount = storageAccount;
            this.containerOrShareName = containerOrShareName;
            this.blobProperties = blobProperties;
            this.metadata = metadata;
        }

        public String getContainerOrShareName() {
            return this.containerOrShareName;
        }

        public String getName() {
            return this.name;
        }

        public String getUrl() {
            return this.url;
        }

        public String getSas() {
            return this.sas;
        }

        public String getStorageType() {
            return this.storageType;
        }

        public FilePath getSrc() {
            return this.src;
        }

        public String getStorageAccount() {
            return this.storageAccount;
        }

        public PartialBlobProperties getBlobProperties() {
            return this.blobProperties;
        }

        public Map<String, String> getMetadata() {
            return this.metadata;
        }
    }

    class FileUploadThread
    implements Runnable {
        private ShareFileClient uploadItem;
        private FilePath filePath;
        private List<AzureBlob> azureBlobs;

        FileUploadThread(ShareFileClient uploadItem, FilePath filePath, List<AzureBlob> azureBlobs) {
            this.uploadItem = uploadItem;
            this.filePath = filePath;
            this.azureBlobs = azureBlobs;
        }

        @Override
        public void run() {
            try {
                UploadService.this.uploadCloudFile(this.uploadItem, this.filePath);
                AzureBlob azureBlob = new AzureBlob(this.uploadItem.getShareName(), this.uploadItem.getFileUrl(), this.filePath.length(), "filestorage", ((UploadServiceData)UploadService.this.getServiceData()).getCredentialsId(), this.uploadItem.getShareName());
                UploadService.this.filesUploaded.addAndGet(1);
                this.azureBlobs.add(azureBlob);
            }
            catch (WAStorageException | IOException | InterruptedException e) {
                LOGGER.log(Level.SEVERE, e.getMessage(), e);
                String message = Messages.AzureStorageBuilder_download_err(((UploadServiceData)UploadService.this.getServiceData()).getStorageAccountInfo().getStorageAccName()) + ":" + e.getMessage();
                e.printStackTrace(UploadService.this.error(message));
                UploadService.this.println(message);
                UploadService.this.setRunUnstable();
            }
        }
    }
}

