/*
 * Decompiled with CFR 0.152.
 */
package com.microsoftopentechnologies.windowsazurestorage.helper;

import hudson.Util;
import java.io.File;
import java.nio.charset.Charset;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Locale;
import java.util.Map;
import jenkins.model.Jenkins;
import org.apache.commons.lang.StringUtils;

public final class Utils {
    public static final String DEF_BLOB_URL = "https://blob.core.windows.net/";
    public static final String BLOB_ENDPOINT_ENDSUFFIX_KEYWORD = "core";
    public static final int BLOB_NAME_LENGTH_LIMIT = 1024;

    public static boolean validateContainerName(String containerName) {
        if (containerName != null) {
            if (containerName.equals("$root") || containerName.equals("$web")) {
                return true;
            }
            String lcContainerName = containerName.trim().toLowerCase(Locale.ENGLISH);
            if (lcContainerName.matches("^(([a-z\\d]((-(?=[a-z\\d]))|([a-z\\d])){2,62}))$")) {
                return true;
            }
        }
        return false;
    }

    public static boolean validateFileShareName(String fileShareName) {
        return StringUtils.isNotBlank((String)fileShareName) && fileShareName.matches("^[a-z0-9]((-(?=[a-z\\d]))|[a-z0-9]){2,62}$");
    }

    public static boolean validateBlobName(String blobName) {
        return blobName != null && blobName.length() > 0 && blobName.length() <= 1024;
    }

    public static boolean containTokens(String text) {
        if (StringUtils.isBlank((String)text)) {
            return false;
        }
        return text.matches("\\$([A-Za-z0-9_]+|\\{[A-Za-z0-9_]+\\})");
    }

    public static String getBlobEP(String blobURL) {
        if (StringUtils.isBlank((String)blobURL)) {
            return DEF_BLOB_URL;
        }
        Object preparedURL = blobURL;
        if (!((String)preparedURL).endsWith("/")) {
            preparedURL = ((String)preparedURL).concat("/");
        }
        if (!((String)preparedURL).contains("://")) {
            preparedURL = "https://" + (String)preparedURL;
        }
        return preparedURL;
    }

    public static String getDefaultBlobURL() {
        return DEF_BLOB_URL;
    }

    public static String getMD5(String plainText) {
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            byte[] array = md.digest(plainText.getBytes(Charset.forName("UTF-8")));
            StringBuilder sb = new StringBuilder();
            int byteMask = 255;
            int byteExtended = 256;
            int length = 3;
            for (int i = 0; i < array.length; ++i) {
                sb.append(Integer.toHexString(array[i] & 0xFF | 0x100).substring(1, 3));
            }
            return sb.toString();
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            return null;
        }
    }

    public static String getWorkDirectory() {
        File jenkinsRoot = Jenkins.get().root;
        if (jenkinsRoot == null) {
            throw new IllegalStateException("Root isn't configured. Couldn't find Jenkins work directory.");
        }
        return jenkinsRoot.getAbsolutePath();
    }

    public static String getPluginInstance() {
        String instanceId = null;
        try {
            instanceId = Jenkins.get().getLegacyInstanceId() == null ? "local" : Jenkins.get().getLegacyInstanceId();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return instanceId;
    }

    public static String getPluginVersion() {
        return Utils.class.getPackage().getImplementationVersion();
    }

    public static String replaceMacro(String s, Map<String, String> props, Locale locale) {
        String result = Util.replaceMacro((String)s, props);
        if (result == null) {
            return null;
        }
        return result.trim().toLowerCase(locale);
    }

    public static String replaceMacro(String s, Map<String, String> props) {
        String result = Util.replaceMacro((String)s, props);
        if (result == null) {
            return null;
        }
        return result.trim();
    }

    private Utils() {
    }
}

