/*
 * Decompiled with CFR 0.152.
 */
package com.microsoftopentechnologies.windowsazurestorage.service;

import com.azure.core.http.rest.PagedIterable;
import com.azure.storage.file.share.ShareClient;
import com.azure.storage.file.share.ShareDirectoryClient;
import com.azure.storage.file.share.ShareServiceClient;
import com.azure.storage.file.share.models.ShareFileItem;
import com.microsoftopentechnologies.windowsazurestorage.Messages;
import com.microsoftopentechnologies.windowsazurestorage.exceptions.WAStorageException;
import com.microsoftopentechnologies.windowsazurestorage.helper.AzureUtils;
import com.microsoftopentechnologies.windowsazurestorage.service.DownloadService;
import com.microsoftopentechnologies.windowsazurestorage.service.model.DownloadServiceData;
import java.net.MalformedURLException;
import java.net.URISyntaxException;

public class DownloadFromFileService
extends DownloadService {
    public DownloadFromFileService(DownloadServiceData data) {
        super(data);
    }

    @Override
    public int execute() {
        try {
            if (((DownloadServiceData)this.getServiceData()).isVerbose()) {
                this.println(Messages.AzureStorageBuilder_downloading());
            }
            ShareClient cloudFileShare = this.getCloudFileShare();
            ShareDirectoryClient cloudFileDirectory = cloudFileShare.getRootDirectoryClient();
            int filesNeedDownload = this.scanFileItems(cloudFileShare, cloudFileDirectory, (PagedIterable<ShareFileItem>)cloudFileDirectory.listFilesAndDirectories());
            this.println(Messages.AzureStorageBuilder_files_need_download_count(filesNeedDownload));
            this.waitForDownloadEnd();
        }
        catch (WAStorageException | MalformedURLException | URISyntaxException e) {
            String message = Messages.AzureStorageBuilder_download_err(((DownloadServiceData)this.getServiceData()).getStorageAccountInfo().getStorageAccName()) + ":" + e.getMessage();
            e.printStackTrace(this.error(message));
            this.println(message);
            this.setRunUnstable();
        }
        return this.getFilesDownloaded();
    }

    private int scanFileItems(ShareClient shareClient, ShareDirectoryClient cloudFileDirectory, PagedIterable<ShareFileItem> fileItems) {
        return this.scanFileItems(shareClient, cloudFileDirectory, fileItems, 0);
    }

    private int scanFileItems(ShareClient shareClient, ShareDirectoryClient cloudFileDirectory, PagedIterable<ShareFileItem> fileItems, int filesNeedDownload) {
        DownloadServiceData data = (DownloadServiceData)this.getServiceData();
        for (ShareFileItem fileItem : fileItems) {
            if (fileItem.isDirectory()) {
                String filePath = this.prependDirectoryPathIfRequired(cloudFileDirectory.getDirectoryPath(), fileItem.getName() + "/");
                if (this.shouldDownload(data.getIncludeFilesPattern(), data.getExcludeFilesPattern(), filePath, false)) {
                    ShareDirectoryClient subdirectoryClient = shareClient.getDirectoryClient(this.prependDirectoryPathIfRequired(cloudFileDirectory.getDirectoryPath(), fileItem.getName()));
                    filesNeedDownload = this.scanFileItems(shareClient, subdirectoryClient, (PagedIterable<ShareFileItem>)subdirectoryClient.listFilesAndDirectories(), filesNeedDownload);
                }
            }
            if (!this.shouldDownload(data.getIncludeFilesPattern(), data.getExcludeFilesPattern(), this.prependDirectoryPathIfRequired(cloudFileDirectory.getDirectoryPath(), fileItem.getName()), true)) continue;
            this.getExecutorService().submit(new DownloadService.DownloadThread(this, cloudFileDirectory.getFileClient(fileItem.getName())));
            ++filesNeedDownload;
        }
        return filesNeedDownload;
    }

    private String prependDirectoryPathIfRequired(String directoryPath, String fileName) {
        if (!directoryPath.equals("")) {
            return directoryPath + "/" + fileName;
        }
        return fileName;
    }

    private ShareClient getCloudFileShare() throws URISyntaxException, MalformedURLException, WAStorageException {
        DownloadServiceData serviceData = (DownloadServiceData)this.getServiceData();
        ShareServiceClient cloudStorageAccount = AzureUtils.getShareClient(serviceData.getStorageAccountInfo());
        ShareClient fileShare = cloudStorageAccount.getShareClient(serviceData.getFileShare());
        if (!fileShare.exists().booleanValue()) {
            throw new WAStorageException("Specified file share doesn't exist.");
        }
        return fileShare;
    }
}

