/*
 * Decompiled with CFR 0.152.
 */
package com.microsoftopentechnologies.windowsazurestorage.service;

import com.azure.storage.blob.BlobContainerClient;
import com.azure.storage.blob.specialized.BlockBlobClient;
import com.azure.storage.file.share.ShareClient;
import com.azure.storage.file.share.ShareFileClient;
import com.azure.storage.file.share.ShareServiceClient;
import com.microsoftopentechnologies.windowsazurestorage.AzureBlob;
import com.microsoftopentechnologies.windowsazurestorage.AzureBlobAction;
import com.microsoftopentechnologies.windowsazurestorage.Messages;
import com.microsoftopentechnologies.windowsazurestorage.exceptions.WAStorageException;
import com.microsoftopentechnologies.windowsazurestorage.helper.AzureUtils;
import com.microsoftopentechnologies.windowsazurestorage.service.DownloadService;
import com.microsoftopentechnologies.windowsazurestorage.service.model.DownloadServiceData;
import hudson.EnvVars;
import hudson.matrix.MatrixBuild;
import hudson.model.Job;
import hudson.model.Run;
import hudson.plugins.copyartifact.BuildFilter;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Arrays;
import java.util.List;
import jenkins.model.Jenkins;

public class DownloadFromBuildService
extends DownloadService {
    private BlobContainerClient cloudBlobContainer;
    private ShareClient cloudFileShare;

    public DownloadFromBuildService(DownloadServiceData data) {
        super(data);
    }

    @Override
    public int execute() {
        DownloadServiceData serviceData = (DownloadServiceData)this.getServiceData();
        int filesDownloaded = 0;
        try {
            Job job = (Job)Jenkins.get().getItemByFullName(serviceData.getProjectName(), Job.class);
            if (job != null) {
                EnvVars envVars = serviceData.getRun().getEnvironment(serviceData.getTaskListener());
                BuildFilter filter = new BuildFilter();
                Run source = serviceData.getBuildSelector().getBuild(job, envVars, filter, serviceData.getRun());
                if (source instanceof MatrixBuild) {
                    for (Run r : ((MatrixBuild)source).getExactRuns()) {
                        filesDownloaded += this.downloadArtifacts(r);
                    }
                } else {
                    filesDownloaded += this.downloadArtifacts(source);
                }
            } else {
                this.println(Messages.AzureStorageBuilder_job_invalid(serviceData.getProjectName()));
                this.setRunUnstable();
            }
        }
        catch (IOException | InterruptedException e) {
            e.printStackTrace(this.error(Messages.AzureStorageBuilder_download_err(serviceData.getStorageAccountInfo().getStorageAccName())));
            this.setRunUnstable();
        }
        return filesDownloaded;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int downloadArtifacts(Run<?, ?> source) {
        DownloadServiceData serviceData = (DownloadServiceData)this.getServiceData();
        try {
            AzureBlobAction action = (AzureBlobAction)source.getAction(AzureBlobAction.class);
            if (action == null) {
                return this.getFilesDownloaded();
            }
            List<AzureBlob> azureBlobs = action.getIndividualBlobs();
            if (action.getZipArchiveBlob() != null && serviceData.isIncludeArchiveZips()) {
                List<AzureBlob> list = azureBlobs;
                synchronized (list) {
                    azureBlobs.addAll(Arrays.asList(action.getZipArchiveBlob()));
                }
            }
            int filesNeedDownload = this.scanBlobs(azureBlobs);
            this.println(Messages.AzureStorageBuilder_files_need_download_count(filesNeedDownload));
            this.waitForDownloadEnd();
        }
        catch (WAStorageException e) {
            this.setRunUnstable();
        }
        return this.getFilesDownloaded();
    }

    private int scanBlobs(List<AzureBlob> azureBlobs) throws WAStorageException {
        DownloadServiceData serviceData = (DownloadServiceData)this.getServiceData();
        int filesNeedDownload = 0;
        if (serviceData.isVerbose()) {
            this.println(Messages.AzureStorageBuilder_downloading());
        }
        for (AzureBlob blob : azureBlobs) {
            try {
                URL blobURL = new URL(blob.getBlobURL());
                String filePath = blobURL.getFile();
                if (!this.shouldDownload(serviceData.getIncludeFilesPattern(), serviceData.getExcludeFilesPattern(), blob.getBlobName(), true)) continue;
                if ("blobstorage".equalsIgnoreCase(blob.getStorageType())) {
                    if (this.cloudBlobContainer == null) {
                        this.cloudBlobContainer = AzureUtils.getBlobContainerReference(serviceData.getStorageAccountInfo(), filePath.split("/")[1], false, true, null);
                    }
                    BlockBlobClient cbb = this.cloudBlobContainer.getBlobClient(blob.getBlobName()).getBlockBlobClient();
                    this.getExecutorService().submit(new DownloadService.DownloadThread(this, cbb));
                    ++filesNeedDownload;
                    continue;
                }
                if (!"filestorage".equalsIgnoreCase(blob.getStorageType())) continue;
                if (this.cloudFileShare == null) {
                    ShareServiceClient cloudStorageAccount = AzureUtils.getShareClient(serviceData.getStorageAccountInfo());
                    this.cloudFileShare = cloudStorageAccount.getShareClient(filePath.split("/")[1]);
                }
                String cloudFileName = filePath.substring(filePath.indexOf(this.cloudFileShare.getShareName()) + this.cloudFileShare.getShareName().length() + 1);
                ShareFileClient cloudFile = this.cloudFileShare.getRootDirectoryClient().getFileClient(cloudFileName);
                this.getExecutorService().submit(new DownloadService.DownloadThread(this, cloudFile));
                ++filesNeedDownload;
            }
            catch (IOException | URISyntaxException e) {
                throw new WAStorageException(e.getMessage(), e);
            }
        }
        return filesNeedDownload;
    }
}

