/*
 * Decompiled with CFR 0.152.
 */
package com.microsoftopentechnologies.windowsazurestorage;

import com.microsoftopentechnologies.windowsazurestorage.AzureBlob;
import com.microsoftopentechnologies.windowsazurestorage.AzureBlobAction;
import hudson.model.Run;
import io.jenkins.blueocean.rest.Reachable;
import io.jenkins.blueocean.rest.factory.BlueArtifactFactory;
import io.jenkins.blueocean.rest.hal.Link;
import io.jenkins.blueocean.rest.model.BlueArtifact;
import java.util.ArrayList;
import java.util.Collection;
import org.jenkinsci.plugins.variant.OptionalExtension;

@OptionalExtension(requirePlugins={"blueocean-rest"})
public final class AzureStorageBlueArtifact
extends BlueArtifact {
    private AzureBlobAction action;
    private AzureBlob artifact;

    public AzureStorageBlueArtifact() {
        super(null);
        this.action = null;
        this.artifact = null;
    }

    public AzureStorageBlueArtifact(AzureBlobAction action, AzureBlob artifact, Link parent) {
        super(parent);
        this.action = action;
        this.artifact = artifact;
    }

    public String getName() {
        return this.artifact.getBlobName();
    }

    public String getPath() {
        return this.artifact.getBlobName();
    }

    public String getUrl() {
        return String.format("/%s%s/processDownloadRequest/%s", this.action.getBuild().getUrl(), this.action.getUrlName(), this.artifact.getBlobName());
    }

    public long getSize() {
        return this.artifact.getSizeInBytes();
    }

    public boolean isDownloadable() {
        return true;
    }

    @OptionalExtension(requirePlugins={"blueocean-rest"})
    public static final class FactoryImpl
    extends BlueArtifactFactory {
        public Collection<BlueArtifact> getArtifacts(Run<?, ?> run, Reachable reachable) {
            AzureBlobAction action = (AzureBlobAction)run.getAction(AzureBlobAction.class);
            if (action == null) {
                return null;
            }
            ArrayList<BlueArtifact> result = new ArrayList<BlueArtifact>();
            AzureBlob zipArtifact = action.getZipArchiveBlob();
            if (zipArtifact != null) {
                result.add(new AzureStorageBlueArtifact(action, zipArtifact, reachable.getLink()));
            }
            for (AzureBlob artifact : action.getIndividualBlobs()) {
                result.add(new AzureStorageBlueArtifact(action, artifact, reachable.getLink()));
            }
            return result;
        }
    }
}

