/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.webhookstep;

import hudson.Extension;
import hudson.model.UnprotectedRootAction;
import hudson.security.csrf.CrumbExclusion;
import hudson.util.Secret;
import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.BufferedReader;
import java.io.IOException;
import java.nio.CharBuffer;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.logging.Logger;
import org.jenkinsci.plugins.webhookstep.WaitForWebhookExecution;
import org.jenkinsci.plugins.webhookstep.WebhookResponse;
import org.jenkinsci.plugins.webhookstep.WebhookToken;
import org.kohsuke.stapler.StaplerRequest2;
import org.kohsuke.stapler.StaplerResponse2;
import org.kohsuke.stapler.verb.POST;

@Extension
public class WebhookRootAction
extends CrumbExclusion
implements UnprotectedRootAction {
    private static final HashMap<String, WaitForWebhookExecution> webhooks = new HashMap();
    private static final HashMap<String, WebhookResponse> alreadyPosted = new HashMap();
    private static final HashMap<String, Secret> authTokens = new HashMap();

    public String getDisplayName() {
        return null;
    }

    public String getIconFileName() {
        return null;
    }

    public String getUrlName() {
        return "webhook-step";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @POST
    public void doDynamic(StaplerRequest2 request, StaplerResponse2 response) {
        WaitForWebhookExecution exec;
        Secret secretAuthToken;
        String token = request.getOriginalRestOfPath().substring(1);
        String authHeader = request.getHeader("Authorization");
        HashMap<String, Secret> hashMap = authTokens;
        synchronized (hashMap) {
            secretAuthToken = authTokens.get(token);
        }
        if (secretAuthToken != null) {
            if (!secretAuthToken.getPlainText().equals(authHeader)) {
                response.setHeader("Result", "Unauthorized");
                response.setStatus(403);
                return;
            }
        } else if (authHeader != null) {
            Logger.getLogger(WebhookRootAction.class.getName()).warning("Unexpected Authorization header for Webhook " + token);
        }
        CharBuffer dest = CharBuffer.allocate(1024);
        StringBuilder content = new StringBuilder();
        try {
            int len;
            BufferedReader reader = request.getReader();
            while ((len = reader.read(dest)) > 0) {
                dest.rewind();
                dest.limit(len);
                content.append(dest);
                dest.limit(dest.capacity());
            }
        }
        catch (IOException e) {
            response.setStatus(400);
            return;
        }
        HashMap<String, String> headers = new HashMap<String, String>();
        Enumeration iter = request.getHeaderNames();
        while (iter.hasMoreElements()) {
            String header = (String)iter.nextElement();
            headers.put(header, request.getHeader(header));
        }
        WebhookResponse whResponse = new WebhookResponse(content.toString(), headers);
        Logger.getLogger(WebhookRootAction.class.getName()).fine("Webhook called with " + token);
        HashMap<String, WaitForWebhookExecution> hashMap2 = webhooks;
        synchronized (hashMap2) {
            exec = webhooks.remove(token);
            if (exec == null) {
                alreadyPosted.put(token, whResponse);
            }
        }
        if (exec != null) {
            exec.onTriggered(whResponse);
            response.setHeader("Result", "WebhookTriggered");
            response.setStatus(200);
        } else {
            response.setStatus(202);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void registerAuthToken(WebhookToken hook) {
        HashMap<String, Secret> hashMap = authTokens;
        synchronized (hashMap) {
            authTokens.put(hook.getToken(), hook.getSecretAuthToken());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static WebhookResponse registerWebhook(WaitForWebhookExecution exec) {
        Logger.getLogger(WebhookRootAction.class.getName()).fine("Registering webhook with token " + exec.getToken());
        HashMap<String, WaitForWebhookExecution> hashMap = webhooks;
        synchronized (hashMap) {
            if (alreadyPosted.containsKey(exec.getToken())) {
                return alreadyPosted.remove(exec.getToken());
            }
            webhooks.put(exec.getToken(), exec);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void deregisterWebhook(WaitForWebhookExecution exec) {
        Logger.getLogger(WebhookRootAction.class.getName()).fine("Deregistering webhook with token " + exec.getToken());
        HashMap<String, WaitForWebhookExecution> hashMap = webhooks;
        synchronized (hashMap) {
            webhooks.remove(exec.getToken());
        }
        hashMap = authTokens;
        synchronized (hashMap) {
            authTokens.remove(exec.getToken());
        }
    }

    public boolean process(HttpServletRequest req, HttpServletResponse resp, FilterChain chain) throws IOException, ServletException {
        String pathInfo = req.getPathInfo();
        if (pathInfo != null && pathInfo.startsWith("/webhook-step/")) {
            chain.doFilter((ServletRequest)req, (ServletResponse)resp);
            return true;
        }
        return false;
    }
}

