/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.webhookstep;

import hudson.EnvVars;
import hudson.util.Secret;
import jakarta.inject.Inject;
import java.net.URI;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.UUID;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.plugins.webhookstep.RegisterWebhookStep;
import org.jenkinsci.plugins.webhookstep.WebhookRootAction;
import org.jenkinsci.plugins.webhookstep.WebhookToken;
import org.jenkinsci.plugins.workflow.steps.StepContext;
import org.jenkinsci.plugins.workflow.steps.SynchronousStepExecution;

public class RegisterWebhookExecution
extends SynchronousStepExecution<WebhookToken> {
    private static final long serialVersionUID = -6718328636399912927L;
    private final Secret secretAuthToken;
    @Inject
    private transient RegisterWebhookStep step;

    public RegisterWebhookExecution(RegisterWebhookStep step, StepContext context, Secret secretAuthToken) {
        super(context);
        this.step = step;
        this.secretAuthToken = secretAuthToken;
    }

    public Secret getSecretAuthToken() {
        return this.secretAuthToken;
    }

    public WebhookToken run() throws Exception {
        String token = this.step == null || StringUtils.isEmpty((String)this.step.token) ? UUID.randomUUID().toString() : URLEncoder.encode(this.step.token, StandardCharsets.UTF_8);
        String jenkinsUrl = (String)((EnvVars)this.getContext().get(EnvVars.class)).get((Object)"JENKINS_URL");
        if (jenkinsUrl == null || jenkinsUrl.isEmpty()) {
            throw new RuntimeException("JENKINS_URL must be set in the Manage Jenkins console");
        }
        URI baseUri = new URI(jenkinsUrl);
        URI relative = new URI("webhook-step/" + token);
        URI path = baseUri.resolve(relative);
        WebhookToken hook = new WebhookToken(token, path.toString(), this.secretAuthToken);
        WebhookRootAction.registerAuthToken(hook);
        return hook;
    }
}

