// CHECKSTYLE:OFF

package hudson.plugin.versioncolumn;

import org.jvnet.localizer.Localizable;
import org.jvnet.localizer.ResourceBundleHolder;
import org.kohsuke.accmod.Restricted;


/**
 * Generated localization support class.
 * 
 */
@SuppressWarnings({
    "",
    "PMD",
    "all"
})
@Restricted(org.kohsuke.accmod.restrictions.NoExternalUse.class)
public class Messages {

    /**
     * The resource bundle reference
     * 
     */
    private final static ResourceBundleHolder holder = ResourceBundleHolder.get(Messages.class);

    /**
     * Key {@code JVMVersionMonitor.MAJOR_MINOR_MATCH}: {@code Agent must run
     * a JVM whose version number (for example, 17.0.12.1 or 21.0.05+7) is
     * greater than or equal to that of the controller (paranoid version)}.
     * 
     * @return
     *     {@code Agent must run a JVM whose version number (for example,
     *      17.0.12.1 or 21.0.05+7) is greater than or equal to that of the
     *     controller (paranoid version)}
     */
    public static String JVMVersionMonitor_MAJOR_MINOR_MATCH() {
        return holder.format("JVMVersionMonitor.MAJOR_MINOR_MATCH");
    }

    /**
     * Key {@code JVMVersionMonitor.MAJOR_MINOR_MATCH}: {@code Agent must run
     * a JVM whose version number (for example, 17.0.12.1 or 21.0.05+7) is
     * greater than or equal to that of the controller (paranoid version)}.
     * 
     * @return
     *     {@code Agent must run a JVM whose version number (for example,
     *      17.0.12.1 or 21.0.05+7) is greater than or equal to that of the
     *     controller (paranoid version)}
     */
    public static Localizable _JVMVersionMonitor_MAJOR_MINOR_MATCH() {
        return new Localizable(holder, "JVMVersionMonitor.MAJOR_MINOR_MATCH");
    }

    /**
     * Key {@code VersionMonitor.OfflineCause}: {@code This node is offline
     * because it uses an old agent.jar}.
     * 
     * @return
     *     {@code This node is offline because it uses an old agent.jar}
     */
    public static String VersionMonitor_OfflineCause() {
        return holder.format("VersionMonitor.OfflineCause");
    }

    /**
     * Key {@code VersionMonitor.OfflineCause}: {@code This node is offline
     * because it uses an old agent.jar}.
     * 
     * @return
     *     {@code This node is offline because it uses an old agent.jar}
     */
    public static Localizable _VersionMonitor_OfflineCause() {
        return new Localizable(holder, "VersionMonitor.OfflineCause");
    }

    /**
     * Key {@code VersionMonitor.DisplayName}: {@code Remoting Version}.
     * 
     * @return
     *     {@code Remoting Version}
     */
    public static String VersionMonitor_DisplayName() {
        return holder.format("VersionMonitor.DisplayName");
    }

    /**
     * Key {@code VersionMonitor.DisplayName}: {@code Remoting Version}.
     * 
     * @return
     *     {@code Remoting Version}
     */
    public static Localizable _VersionMonitor_DisplayName() {
        return new Localizable(holder, "VersionMonitor.DisplayName");
    }

    /**
     * Key {@code JVMVersionMonitor.OfflineCause}: {@code This node is
     * offline because the JVM version of the agent is incompatible with the
     * controller one.}.
     * 
     * @return
     *     {@code This node is offline because the JVM version of the agent is
     *     incompatible with the controller one.}
     */
    public static String JVMVersionMonitor_OfflineCause() {
        return holder.format("JVMVersionMonitor.OfflineCause");
    }

    /**
     * Key {@code JVMVersionMonitor.OfflineCause}: {@code This node is
     * offline because the JVM version of the agent is incompatible with the
     * controller one.}.
     * 
     * @return
     *     {@code This node is offline because the JVM version of the agent is
     *     incompatible with the controller one.}
     */
    public static Localizable _JVMVersionMonitor_OfflineCause() {
        return new Localizable(holder, "JVMVersionMonitor.OfflineCause");
    }

    /**
     * Key {@code JVMVersionMonitor.MarkedOffline}: {@code Making {0} offline
     * temporarily due to using an incompatible JVM version between agent and
     * controller (controller={1}, agent={2})}.
     * 
     * @param arg2
     *      3rd format parameter, {@code {2}}, as {@link String#valueOf(Object)}.
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Making {0} offline temporarily due to using an incompatible JVM
     *     version between agent and controller (controller={1}, agent={2})}
     */
    public static String JVMVersionMonitor_MarkedOffline(Object arg0, Object arg1, Object arg2) {
        return holder.format("JVMVersionMonitor.MarkedOffline", arg0, arg1, arg2);
    }

    /**
     * Key {@code JVMVersionMonitor.MarkedOffline}: {@code Making {0} offline
     * temporarily due to using an incompatible JVM version between agent and
     * controller (controller={1}, agent={2})}.
     * 
     * @param arg2
     *      3rd format parameter, {@code {2}}, as {@link String#valueOf(Object)}.
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Making {0} offline temporarily due to using an incompatible JVM
     *     version between agent and controller (controller={1}, agent={2})}
     */
    public static Localizable _JVMVersionMonitor_MarkedOffline(Object arg0, Object arg1, Object arg2) {
        return new Localizable(holder, "JVMVersionMonitor.MarkedOffline", arg0, arg1, arg2);
    }

    /**
     * Key {@code JVMVersionMonitor.DisplayName}: {@code JVM Version}.
     * 
     * @return
     *     {@code JVM Version}
     */
    public static String JVMVersionMonitor_DisplayName() {
        return holder.format("JVMVersionMonitor.DisplayName");
    }

    /**
     * Key {@code JVMVersionMonitor.DisplayName}: {@code JVM Version}.
     * 
     * @return
     *     {@code JVM Version}
     */
    public static Localizable _JVMVersionMonitor_DisplayName() {
        return new Localizable(holder, "JVMVersionMonitor.DisplayName");
    }

    /**
     * Key {@code VersionMonitor.MarkedOffline}: {@code Making {0} offline
     * temporarily due to the use of an old agent.jar}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Making {0} offline temporarily due to the use of an old
     *     agent.jar}
     */
    public static String VersionMonitor_MarkedOffline(Object arg0) {
        return holder.format("VersionMonitor.MarkedOffline", arg0);
    }

    /**
     * Key {@code VersionMonitor.MarkedOffline}: {@code Making {0} offline
     * temporarily due to the use of an old agent.jar}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Making {0} offline temporarily due to the use of an old
     *     agent.jar}
     */
    public static Localizable _VersionMonitor_MarkedOffline(Object arg0) {
        return new Localizable(holder, "VersionMonitor.MarkedOffline", arg0);
    }

    /**
     * Key {@code JVMVersionMonitor.UnrecognizedAgentJVM}: {@code The agent
     * JVM version {0} is not recognized by the plugin. You might want to
     * open a ticket for the maintainer to complete the compatibility list.}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code The agent JVM version {0} is not recognized by the plugin. You
     *     might want to open a ticket for the maintainer to complete the
     *     compatibility list.}
     */
    public static String JVMVersionMonitor_UnrecognizedAgentJVM(Object arg0) {
        return holder.format("JVMVersionMonitor.UnrecognizedAgentJVM", arg0);
    }

    /**
     * Key {@code JVMVersionMonitor.UnrecognizedAgentJVM}: {@code The agent
     * JVM version {0} is not recognized by the plugin. You might want to
     * open a ticket for the maintainer to complete the compatibility list.}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code The agent JVM version {0} is not recognized by the plugin. You
     *     might want to open a ticket for the maintainer to complete the
     *     compatibility list.}
     */
    public static Localizable _JVMVersionMonitor_UnrecognizedAgentJVM(Object arg0) {
        return new Localizable(holder, "JVMVersionMonitor.UnrecognizedAgentJVM", arg0);
    }

    /**
     * Key {@code
     * JVMVersionMonitor.RUNTIME_GREATER_OR_EQUAL_MASTER_BYTECODE}: {@code
     * Agent must run a JVM whose feature-release counter (for example, 17 or
     *  21) is greater than or equal to that of the controller (strongly
     * recommended minimum)}.
     * 
     * @return
     *     {@code Agent must run a JVM whose feature-release counter (for
     *     example, 17 or 21) is greater than or equal to that of the controller
     *     (strongly recommended minimum)}
     */
    public static String JVMVersionMonitor_RUNTIME_GREATER_OR_EQUAL_MASTER_BYTECODE() {
        return holder.format("JVMVersionMonitor.RUNTIME_GREATER_OR_EQUAL_MASTER_BYTECODE");
    }

    /**
     * Key {@code
     * JVMVersionMonitor.RUNTIME_GREATER_OR_EQUAL_MASTER_BYTECODE}: {@code
     * Agent must run a JVM whose feature-release counter (for example, 17 or
     *  21) is greater than or equal to that of the controller (strongly
     * recommended minimum)}.
     * 
     * @return
     *     {@code Agent must run a JVM whose feature-release counter (for
     *     example, 17 or 21) is greater than or equal to that of the controller
     *     (strongly recommended minimum)}
     */
    public static Localizable _JVMVersionMonitor_RUNTIME_GREATER_OR_EQUAL_MASTER_BYTECODE() {
        return new Localizable(holder, "JVMVersionMonitor.RUNTIME_GREATER_OR_EQUAL_MASTER_BYTECODE");
    }

    /**
     * Key {@code JVMVersionMonitor.EXACT_MATCH}: {@code Agent must run a JVM
     * whose version number (for example, 17.0.12.1 or 21.0.05+7) is equal to
     * that of the controller (paranoid++ version)}.
     * 
     * @return
     *     {@code Agent must run a JVM whose version number (for example,
     *      17.0.12.1 or 21.0.05+7) is equal to that of the controller (paranoid++
     *     version)}
     */
    public static String JVMVersionMonitor_EXACT_MATCH() {
        return holder.format("JVMVersionMonitor.EXACT_MATCH");
    }

    /**
     * Key {@code JVMVersionMonitor.EXACT_MATCH}: {@code Agent must run a JVM
     * whose version number (for example, 17.0.12.1 or 21.0.05+7) is equal to
     * that of the controller (paranoid++ version)}.
     * 
     * @return
     *     {@code Agent must run a JVM whose version number (for example,
     *      17.0.12.1 or 21.0.05+7) is equal to that of the controller (paranoid++
     *     version)}
     */
    public static Localizable _JVMVersionMonitor_EXACT_MATCH() {
        return new Localizable(holder, "JVMVersionMonitor.EXACT_MATCH");
    }

}
