/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugin.versioncolumn;

import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.Extension;
import hudson.Util;
import hudson.model.Computer;
import hudson.node_monitors.AbstractNodeMonitorDescriptor;
import hudson.node_monitors.MonitorOfflineCause;
import hudson.node_monitors.NodeMonitor;
import hudson.plugin.versioncolumn.Messages;
import hudson.remoting.Callable;
import hudson.remoting.Launcher;
import hudson.remoting.VirtualChannel;
import hudson.slaves.OfflineCause;
import java.io.IOException;
import java.util.logging.Logger;
import jenkins.security.MasterToSlaveCallable;
import org.jenkinsci.Symbol;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.export.Exported;

public class VersionMonitor
extends NodeMonitor {
    private static final String masterVersion = Launcher.VERSION;
    @SuppressFBWarnings(value={"MS_PKGPROTECT"}, justification="for backward compatibility")
    public static AbstractNodeMonitorDescriptor<String> DESCRIPTOR;
    private static final Logger LOGGER;

    @DataBoundConstructor
    public VersionMonitor() {
    }

    public String toHtml(String version) {
        if (version == null) {
            return "N/A";
        }
        if (!version.equals(masterVersion)) {
            return Util.wrapToErrorSpan((String)version);
        }
        return version;
    }

    static {
        LOGGER = Logger.getLogger(VersionMonitor.class.getName());
    }

    private static final class SlaveVersion
    extends MasterToSlaveCallable<String, IOException> {
        private static final long serialVersionUID = 1L;

        private SlaveVersion() {
        }

        public String call() throws IOException {
            try {
                return Launcher.VERSION;
            }
            catch (Throwable ex) {
                return "< 1.335";
            }
        }
    }

    public static class RemotingVersionMismatchCause
    extends MonitorOfflineCause {
        private final String message;

        public RemotingVersionMismatchCause(String message) {
            this.message = message;
        }

        @Exported(name="description")
        public String toString() {
            return this.message;
        }

        @NonNull
        public Class<? extends NodeMonitor> getTrigger() {
            return VersionMonitor.class;
        }
    }

    @Extension
    @Symbol(value={"remotingVersion"})
    public static class DescriptorImpl
    extends AbstractNodeMonitorDescriptor<String> {
        @SuppressFBWarnings(value={"ST_WRITE_TO_STATIC_FROM_INSTANCE_METHOD"}, justification="for backward compatibility")
        public DescriptorImpl() {
            DESCRIPTOR = this;
        }

        protected String monitor(Computer c) throws IOException, InterruptedException {
            VirtualChannel channel = c.getChannel();
            if (channel == null) {
                return "unknown-version";
            }
            String version = (String)channel.call((Callable)new SlaveVersion());
            if (version == null || !version.equals(masterVersion)) {
                if (!this.isIgnored()) {
                    this.markOffline(c, (OfflineCause)new RemotingVersionMismatchCause(Messages.VersionMonitor_OfflineCause()));
                    LOGGER.warning(Messages.VersionMonitor_MarkedOffline(c.getName()));
                } else if (c.isOffline() && c.getOfflineCause() instanceof RemotingVersionMismatchCause) {
                    c.setTemporarilyOffline(false, null);
                }
            } else if (c.isOffline() && c.getOfflineCause() instanceof RemotingVersionMismatchCause) {
                c.setTemporarilyOffline(false, null);
            }
            return version;
        }

        @NonNull
        public String getDisplayName() {
            return Messages.VersionMonitor_DisplayName();
        }
    }
}

