/*
 * Decompiled with CFR 0.152.
 */
package com.vectorcast.plugins.vectorcastcoverage.rules;

import com.vectorcast.plugins.vectorcastcoverage.CoverageReport;
import com.vectorcast.plugins.vectorcastcoverage.EnvironmentReport;
import com.vectorcast.plugins.vectorcastcoverage.Rule;
import com.vectorcast.plugins.vectorcastcoverage.UnitReport;
import hudson.model.TaskListener;

public class StatementCoveragePerSourceFileRule
extends Rule {
    private static final long serialVersionUID = -2869893039051762047L;
    private final float minPercentage;

    public StatementCoveragePerSourceFileRule(float minPercentage) {
        this.minPercentage = minPercentage;
    }

    @Override
    public void enforce(CoverageReport report, TaskListener listener) {
        for (EnvironmentReport env : report.getChildren().values()) {
            for (UnitReport unitReport : env.getChildren().values()) {
                float percentage = unitReport.getStatementCoverage().getPercentageFloat();
                if (!(percentage < this.minPercentage)) continue;
                listener.getLogger().println("VCASTCoverage: " + unitReport.getDisplayName() + " failed (below " + this.minPercentage + "%).");
                unitReport.setFailed();
            }
        }
    }
}

