/*
 * Decompiled with CFR 0.152.
 */
package com.vectorcast.plugins.vectorcastcoverage.portlet.utils;

import hudson.model.Job;
import hudson.model.Run;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.Calendar;
import java.util.List;

public final class Utils {
    private Utils() {
    }

    public static int validateChartAttributes(String attribute, int defaultValue) {
        if (attribute != null) {
            if (attribute.isEmpty() || attribute.equals("0")) {
                return defaultValue;
            }
            try {
                int validAttributeValue = Integer.parseInt(attribute);
                if (validAttributeValue < 0) {
                    return defaultValue;
                }
                return validAttributeValue;
            }
            catch (NumberFormatException exception) {
                return defaultValue;
            }
        }
        return defaultValue;
    }

    public static LocalDate getLastDate(List<Job> jobs) {
        LocalDate lastDate = null;
        for (Job job : jobs) {
            Run lastRun = job.getLastBuild();
            if (lastRun == null) continue;
            LocalDate date = Utils.calendarToLocalData(lastRun.getTimestamp());
            if (lastDate == null) {
                lastDate = date;
            }
            if (!date.isAfter(lastDate)) continue;
            lastDate = date;
        }
        return lastDate;
    }

    public static Float roundFLoat(int scale, int roundingMode, Float value) {
        BigDecimal bigDecimal = new BigDecimal(value.toString());
        bigDecimal = bigDecimal.setScale(scale, roundingMode);
        return Float.valueOf(bigDecimal.floatValue());
    }

    public static LocalDate calendarToLocalData(Calendar calendar) {
        int year = calendar.get(1);
        int month = calendar.get(2) + 1;
        int dayOfMonth = calendar.get(5);
        LocalDate date = LocalDate.of(year, month, dayOfMonth);
        return date;
    }
}

