/*
 * Decompiled with CFR 0.152.
 */
package com.vectorcast.plugins.vectorcastcoverage.portlet.chart;

import com.vectorcast.plugins.vectorcastcoverage.portlet.Messages;
import com.vectorcast.plugins.vectorcastcoverage.portlet.VectorCASTLoadData;
import com.vectorcast.plugins.vectorcastcoverage.portlet.bean.VectorCASTCoverageResultSummary;
import com.vectorcast.plugins.vectorcastcoverage.portlet.utils.Utils;
import hudson.Extension;
import hudson.model.Descriptor;
import hudson.plugins.view.dashboard.DashboardPortlet;
import hudson.util.ColorPalette;
import hudson.util.DataSetBuilder;
import hudson.util.Graph;
import hudson.util.ShiftedCategoryAxis;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Paint;
import java.awt.Stroke;
import java.time.LocalDate;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.CategoryAxis;
import org.jfree.chart.axis.CategoryLabelPositions;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.renderer.category.BarRenderer;
import org.jfree.chart.renderer.category.CategoryItemRenderer;
import org.jfree.chart.renderer.category.LineAndShapeRenderer;
import org.jfree.data.category.CategoryDataset;
import org.jfree.ui.RectangleInsets;
import org.kohsuke.stapler.DataBoundConstructor;

public class VectorCASTBuilderTrendChart
extends DashboardPortlet {
    private static final Logger LOGGER = Logger.getLogger(VectorCASTBuilderTrendChart.class.getName());
    private final int width;
    private final int height;
    private final int daysNumber;

    @DataBoundConstructor
    public VectorCASTBuilderTrendChart(String name, String width, String height, String daysNumber) {
        super(name);
        this.width = Utils.validateChartAttributes(width, 500);
        this.height = Utils.validateChartAttributes(height, 250);
        this.daysNumber = Utils.validateChartAttributes(daysNumber, 30);
    }

    public Graph getSummaryGraph() {
        LOGGER.log(Level.INFO, "In VectorCASTBuilderTrendChart::getSummaryGraph");
        List jobs = this.getDashboard().getJobs();
        Map<LocalDate, VectorCASTCoverageResultSummary> summaries = VectorCASTLoadData.loadChartDataWithinRange(jobs, this.daysNumber);
        return VectorCASTBuilderTrendChart.createTrendChart(summaries, this.width, this.height);
    }

    private static Graph createTrendChart(final Map<LocalDate, VectorCASTCoverageResultSummary> summaries, int widthParam, int heightParam) {
        return new Graph(-1L, widthParam, heightParam){

            protected JFreeChart createGraph() {
                if (summaries == null) {
                    JFreeChart chart = ChartFactory.createStackedAreaChart(null, (String)"Days", (String)"Coverage(%)", null, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)true, (boolean)false, (boolean)false);
                    return chart;
                }
                LOGGER.log(Level.INFO, "In VectorCASTBuilderTrendChart::createTrendChart::Graph (Override): " + summaries.size());
                JFreeChart chart = ChartFactory.createLineChart((String)"", (String)"Days", (String)"Coverage(%)", (CategoryDataset)VectorCASTBuilderTrendChart.buildDataSet(summaries), (PlotOrientation)PlotOrientation.VERTICAL, (boolean)true, (boolean)false, (boolean)false);
                chart.setBackgroundPaint((Paint)Color.white);
                CategoryPlot plot = chart.getCategoryPlot();
                plot.setBackgroundPaint((Paint)Color.WHITE);
                plot.setOutlinePaint(null);
                plot.setRangeGridlinesVisible(true);
                plot.setRangeGridlinePaint((Paint)Color.black);
                ShiftedCategoryAxis domainAxis = new ShiftedCategoryAxis(null);
                plot.setDomainAxis((CategoryAxis)domainAxis);
                domainAxis.setCategoryLabelPositions(CategoryLabelPositions.UP_90);
                domainAxis.setLowerMargin(0.0);
                domainAxis.setUpperMargin(0.0);
                domainAxis.setCategoryMargin(0.0);
                NumberAxis rangeAxis = (NumberAxis)plot.getRangeAxis();
                rangeAxis.setStandardTickUnits(NumberAxis.createIntegerTickUnits());
                rangeAxis.setUpperBound(100.0);
                rangeAxis.setLowerBound(0.0);
                LineAndShapeRenderer renderer = (LineAndShapeRenderer)plot.getRenderer();
                renderer.setBaseStroke((Stroke)new BasicStroke(4.0f));
                renderer.setBaseShapesVisible(true);
                ColorPalette.apply((LineAndShapeRenderer)renderer);
                plot.setInsets(new RectangleInsets(5.0, 0.0, 0.0, 5.0));
                plot.setDataset(1, VectorCASTBuilderTrendChart.buildComplexityDataSet(summaries));
                plot.mapDatasetToRangeAxis(1, 1);
                NumberAxis axis2 = new NumberAxis("Complexity");
                axis2.setAutoRange(true);
                plot.setRangeAxis(1, (ValueAxis)axis2);
                BarRenderer renderer2 = new BarRenderer();
                Color color = new Color(192, 192, 192, 128);
                renderer2.setSeriesPaint(0, (Paint)color);
                plot.setRenderer(1, (CategoryItemRenderer)renderer2);
                return chart;
            }
        };
    }

    private static CategoryDataset buildDataSet(Map<LocalDate, VectorCASTCoverageResultSummary> summaries) {
        DataSetBuilder dataSetBuilder = new DataSetBuilder();
        LOGGER.log(Level.INFO, "In VectorCASTBuilderTrendChart::buildDataSet");
        for (Map.Entry<LocalDate, VectorCASTCoverageResultSummary> entry : summaries.entrySet()) {
            float BasisPathCoverage = 0.0f;
            float StatementCoverage = 0.0f;
            float MCDCCoverage = 0.0f;
            float BranchCoverage = 0.0f;
            float FunctionCoverage = 0.0f;
            float FunctionCallCoverage = 0.0f;
            boolean hasStatementCoverage = false;
            boolean hasBranchCoverage = false;
            boolean hasBasisPathCoverage = false;
            boolean hasMCDCCoverage = false;
            boolean hasFunctionCoverage = false;
            boolean hasFunctionCallCoverage = false;
            int count = 0;
            List<VectorCASTCoverageResultSummary> list = entry.getValue().getVectorCASTCoverageResults();
            for (VectorCASTCoverageResultSummary item : list) {
                if (item.hasStatementCoverage()) {
                    hasStatementCoverage = true;
                    StatementCoverage += item.getStatementCoverage();
                }
                if (item.hasBranchCoverage()) {
                    BranchCoverage += item.getBranchCoverage();
                    hasBranchCoverage = true;
                }
                if (item.hasBasisPathCoverage()) {
                    BasisPathCoverage += item.getBasisPathCoverage();
                    hasBasisPathCoverage = true;
                }
                if (item.hasMCDCCoverage()) {
                    MCDCCoverage += item.getMCDCCoverage();
                    hasMCDCCoverage = true;
                }
                if (item.hasFunctionCoverage()) {
                    FunctionCoverage += item.getFunctionCoverage();
                    hasFunctionCoverage = true;
                }
                if (item.hasFunctionCallCoverage()) {
                    FunctionCallCoverage += item.getFunctionCallCoverage();
                    hasFunctionCallCoverage = true;
                }
                ++count;
            }
            if (hasStatementCoverage) {
                dataSetBuilder.add((Number)Float.valueOf(StatementCoverage / (float)count), (Comparable)((Object)"Statement"), (Comparable)entry.getKey());
            }
            if (hasBranchCoverage) {
                dataSetBuilder.add((Number)Float.valueOf(BranchCoverage / (float)count), (Comparable)((Object)"Branch"), (Comparable)entry.getKey());
            }
            if (hasBasisPathCoverage) {
                dataSetBuilder.add((Number)Float.valueOf(BasisPathCoverage / (float)count), (Comparable)((Object)"Basis Path"), (Comparable)entry.getKey());
            }
            if (hasMCDCCoverage) {
                dataSetBuilder.add((Number)Float.valueOf(MCDCCoverage / (float)count), (Comparable)((Object)"MC/DC"), (Comparable)entry.getKey());
            }
            if (hasFunctionCoverage) {
                dataSetBuilder.add((Number)Float.valueOf(FunctionCoverage / (float)count), (Comparable)((Object)"Function"), (Comparable)entry.getKey());
            }
            if (!hasFunctionCallCoverage) continue;
            dataSetBuilder.add((Number)Float.valueOf(FunctionCallCoverage / (float)count), (Comparable)((Object)"Function Call"), (Comparable)entry.getKey());
        }
        return dataSetBuilder.build();
    }

    private static CategoryDataset buildComplexityDataSet(Map<LocalDate, VectorCASTCoverageResultSummary> summaries) {
        DataSetBuilder dataSetBuilder = new DataSetBuilder();
        for (Map.Entry<LocalDate, VectorCASTCoverageResultSummary> entry : summaries.entrySet()) {
            float Complexity = 0.0f;
            boolean hasComplexity = false;
            List<VectorCASTCoverageResultSummary> list = entry.getValue().getVectorCASTCoverageResults();
            for (VectorCASTCoverageResultSummary item : list) {
                if (!item.hasComplexity()) continue;
                Complexity += item.getComplexity();
                hasComplexity = true;
            }
            if (!hasComplexity) continue;
            dataSetBuilder.add((Number)Float.valueOf(Complexity), (Comparable)((Object)"Complexity"), (Comparable)entry.getKey());
        }
        return dataSetBuilder.build();
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public int getDaysNumber() {
        return this.daysNumber;
    }

    @Extension(optional=true)
    public static class DescriptorImpl
    extends Descriptor<DashboardPortlet> {
        public String getDisplayName() {
            return Messages.Portlet_ChartTitle();
        }
    }
}

