/*
 * Decompiled with CFR 0.152.
 */
package com.vectorcast.plugins.vectorcastcoverage;

import com.vectorcast.plugins.vectorcastcoverage.CoverageReport;
import com.vectorcast.plugins.vectorcastcoverage.Messages;
import com.vectorcast.plugins.vectorcastcoverage.Rule;
import com.vectorcast.plugins.vectorcastcoverage.VectorCASTBuildAction;
import com.vectorcast.plugins.vectorcastcoverage.VectorCASTHealthReportThresholds;
import com.vectorcast.plugins.vectorcastcoverage.VectorCASTProjectAction;
import hudson.EnvVars;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.maven.ExecutedMojo;
import hudson.maven.MavenBuild;
import hudson.maven.MavenModuleSetBuild;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.Descriptor;
import hudson.model.Job;
import hudson.model.Result;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.BuildStepMonitor;
import hudson.tasks.Publisher;
import hudson.tasks.Recorder;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nonnull;
import jenkins.tasks.SimpleBuildStep;
import net.sf.json.JSONObject;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.StaplerRequest;

public class VectorCASTPublisher
extends Recorder
implements SimpleBuildStep {
    private String includes;
    private Boolean useThreshold;
    private Boolean useCoverageHistory;
    private Integer maxHistory;
    private Rule rule;
    private VectorCASTHealthReportThresholds healthReports = new VectorCASTHealthReportThresholds(0, 100, 0, 70, 0, 80, 0, 80, 0, 80, 0, 80);
    private VectorCASTHealthReportThresholds healthyTarget = null;
    private VectorCASTHealthReportThresholds unhealthyTarget = null;
    private static final Logger logger = Logger.getLogger(VectorCASTPublisher.class.getName());
    @Extension
    public static final BuildStepDescriptor<Publisher> DESCRIPTOR = new DescriptorImpl();

    public VectorCASTPublisher() {
        this.includes = "xml_data/coverage_results*.xml";
        this.useThreshold = false;
        this.useCoverageHistory = false;
        this.maxHistory = Integer.MAX_VALUE;
    }

    @DataBoundConstructor
    public VectorCASTPublisher(String includes, Boolean useThreshold, VectorCASTHealthReportThresholds healthyTarget, VectorCASTHealthReportThresholds unhealthyTarget, Boolean useCoverageHistory, Integer maxHistory) {
        this.includes = includes == null ? "xml_data/coverage_results*.xml" : includes;
        this.useThreshold = useThreshold == null ? Boolean.valueOf(false) : useThreshold;
        this.useCoverageHistory = useCoverageHistory == null ? Boolean.valueOf(false) : useCoverageHistory;
        this.maxHistory = maxHistory == null ? Integer.valueOf(Integer.MAX_VALUE) : maxHistory;
        this.unhealthyTarget = unhealthyTarget;
        this.healthyTarget = healthyTarget;
    }

    @Nonnull
    public final String getIncludes() {
        return this.includes;
    }

    @DataBoundSetter
    public final void setIncludes(String inputIncludes) {
        this.includes = inputIncludes;
    }

    @Nonnull
    public final Boolean getUseThreshold() {
        return this.useThreshold;
    }

    @DataBoundSetter
    public final void setUseThreshold(Boolean useThreshold) {
        this.useThreshold = useThreshold;
    }

    @Nonnull
    public final Boolean getUseCoverageHistory() {
        if (this.useCoverageHistory == null) {
            this.useCoverageHistory = false;
        }
        return this.useCoverageHistory;
    }

    @DataBoundSetter
    public final void setUseCoverageHistory(Boolean useCoverageHistory) {
        this.useCoverageHistory = useCoverageHistory;
    }

    @Nonnull
    public final Integer getMaxHistory() {
        if (this.maxHistory == null) {
            this.maxHistory = Integer.MAX_VALUE;
        }
        return this.maxHistory;
    }

    @DataBoundSetter
    public final void setMaxHistory(Integer inMaxHistory) {
        if (this.maxHistory == null) {
            this.maxHistory = Integer.MAX_VALUE;
        }
        this.maxHistory = inMaxHistory;
    }

    @Nonnull
    public final VectorCASTHealthReportThresholds getHealthReports() {
        return this.healthReports;
    }

    @DataBoundSetter
    public final void setHealthReports(VectorCASTHealthReportThresholds healthReports) {
        this.healthReports = healthReports;
    }

    @Nonnull
    public final VectorCASTHealthReportThresholds getHealthyTarget() {
        return this.healthyTarget;
    }

    @DataBoundSetter
    public final void setHealthyTarget(VectorCASTHealthReportThresholds healthyTarget) {
        this.healthReports = healthyTarget;
    }

    @Nonnull
    public final VectorCASTHealthReportThresholds getUnhealthyTarget() {
        return this.unhealthyTarget;
    }

    @DataBoundSetter
    public final void setUnhealthyTarget(VectorCASTHealthReportThresholds unhealthyTarget) {
        this.unhealthyTarget = unhealthyTarget;
    }

    protected static FilePath[] locateCoverageReports(FilePath workspace, String includes) throws IOException, InterruptedException {
        String[] parts;
        try {
            FilePath[] ret = workspace.list(includes);
            if (ret.length > 0) {
                return ret;
            }
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "Failed to find includes: " + includes, e);
        }
        ArrayList<FilePath> files = new ArrayList<FilePath>();
        for (String path : parts = includes.split("\\s*[;:,]+\\s*")) {
            FilePath src = workspace.child(path);
            if (!src.exists()) continue;
            if (src.isDirectory()) {
                files.addAll(Arrays.asList(src.list("**/coverage*.xml")));
                continue;
            }
            files.add(src);
        }
        return files.toArray(new FilePath[files.size()]);
    }

    protected static void saveCoverageReports(FilePath folder, FilePath[] files) throws IOException, InterruptedException {
        folder.mkdirs();
        for (int i = 0; i < files.length; ++i) {
            String name = "coverage" + String.valueOf(i > 0 ? Integer.valueOf(i) : "") + ".xml";
            FilePath src = files[i];
            FilePath dst = folder.child(name);
            src.copyTo(dst);
        }
    }

    public void perform(@Nonnull Run<?, ?> run, @Nonnull FilePath workspace, @Nonnull Launcher launcher, @Nonnull TaskListener listener) throws InterruptedException, IOException {
        this.performImpl(run, workspace, listener);
    }

    public boolean performImpl(Run<?, ?> run, FilePath workspace, TaskListener listener) throws InterruptedException, IOException {
        FilePath[] reports;
        MavenModuleSetBuild moduleSetBuild;
        PrintStream logger = listener.getLogger();
        if (run instanceof MavenBuild) {
            MavenBuild mavenBuild = (MavenBuild)run;
            if (!this.didVecctorCASTRun(mavenBuild)) {
                listener.getLogger().println("Skipping VecctorCAST coverage report as mojo did not run.");
                return true;
            }
        } else if (run instanceof MavenModuleSetBuild && !this.didVecctorCASTRun((moduleSetBuild = (MavenModuleSetBuild)run).getModuleLastBuilds().values())) {
            listener.getLogger().println("Skipping VecctorCAST coverage report as mojo did not run.");
            return true;
        }
        Map envs = run instanceof AbstractBuild ? ((AbstractBuild)run).getBuildVariables() : Collections.emptyMap();
        EnvVars env = run.getEnvironment(listener);
        env.overrideAll(envs);
        this.includes = env.expand(this.includes);
        if (this.includes == null || this.includes.trim().length() == 0) {
            if (workspace != null) {
                logger.println("[VectorCASTCoverage] [INFO]: looking for coverage reports in the entire workspace: " + workspace.getRemote());
            }
            reports = VectorCASTPublisher.locateCoverageReports(workspace, "**/coverage.xml");
        } else {
            logger.println("[VectorCASTCoverage] [INFO]: looking for coverage reports in the provided path: " + this.includes);
            reports = VectorCASTPublisher.locateCoverageReports(workspace, this.includes);
        }
        if (reports.length == 0) {
            Result result = run.getResult();
            if (result == null || result.isWorseThan(Result.UNSTABLE)) {
                return true;
            }
            logger.println("[VectorCASTCoverage] [INFO]: no coverage files found in workspace. Was any report generated?");
            run.setResult(Result.FAILURE);
            return true;
        }
        StringBuffer buf = new StringBuffer();
        int idx = 0;
        for (FilePath f : reports) {
            if (idx == 0) {
                buf.append("\n          coverage.xml:  ");
            } else {
                buf.append("\n          coverage" + idx + ".xml:  ");
            }
            buf.append(f.getRemote());
            ++idx;
        }
        logger.println("[VectorCASTCoverage] [INFO]: found " + reports.length + " report files: " + buf.toString());
        FilePath vcFolder = new FilePath(VectorCASTPublisher.getVectorCASTReport(run));
        VectorCASTPublisher.saveCoverageReports(vcFolder, reports);
        logger.println("[VectorCASTCoverage] [INFO]: stored " + reports.length + " report file(s) in the run folder: " + String.valueOf(vcFolder));
        InputStream[] streams = new InputStream[reports.length];
        for (int i = 0; i < reports.length; ++i) {
            File localXMLFile = new File(String.valueOf(vcFolder) + "/coverage" + String.valueOf(i > 0 ? Integer.valueOf(i) : "") + ".xml");
            streams[i] = new FileInputStream(localXMLFile);
        }
        VectorCASTBuildAction action = VectorCASTBuildAction.load(run, this.rule, this.healthReports, streams);
        if (action.getBuildHealth() != null) {
            logger.println("[VectorCASTCoverage] [INFO]: " + action.getBuildHealth().getDescription());
        } else {
            logger.println("[VectorCASTCoverage] [INFO]: No thresholds set");
        }
        run.getActions().add(action);
        CoverageReport result = action.getResult();
        if (result == null) {
            logger.println("[VectorCASTCoverage] [INFO]: Could not parse a coverage result file:");
            logger.println("[VectorCASTCoverage] [INFO]:     See Manage Jenkins > System Log > All Jenkins Log and search for 'Error Parsing VectorCAST Coverage'");
            logger.println("[VectorCASTCoverage] [INFO]:     Use file list above to relate coverage*.xml to xml_data/coverage_results*.xml");
            logger.println("[VectorCASTCoverage] [INFO]:     Setting Build to failure.");
            run.setResult(Result.FAILURE);
        } else if (result.isFailed()) {
            logger.println("[VectorCASTCoverage] [INFO]: code coverage enforcement failed. Setting Build to unstable.");
            run.setResult(Result.UNSTABLE);
        }
        float prevStCov = -1.0f;
        float currStCov = -1.0f;
        float currBrCov = -1.0f;
        float prevBrCov = -1.0f;
        float currMCDCCov = -1.0f;
        float prevMCDCCov = -1.0f;
        float currFuncCov = -1.0f;
        float prevFuncCov = -1.0f;
        float currFuncCallCov = -1.0f;
        float prevFuncCallCov = -1.0f;
        VectorCASTProjectAction vcProjAction = new VectorCASTProjectAction(run.getParent());
        VectorCASTBuildAction historyAction = vcProjAction.getPreviousNotFailedBuild();
        if (historyAction != null) {
            int histBuildNum = historyAction.getBuildNumber();
            int currBuildNum = action.getBuildNumber();
            Object CurrPrintStr = "Current  Coverage : ";
            Object PrevPrintStr = "Previous Coverage : ";
            if (historyAction.getStatementCoverage() != null) {
                prevStCov = historyAction.getStatementCoverage().getPercentageFloat();
                PrevPrintStr = (String)PrevPrintStr + String.format("St: %s | ", Float.valueOf(prevStCov));
            }
            if (action.getStatementCoverage() != null) {
                currStCov = action.getStatementCoverage().getPercentageFloat();
                CurrPrintStr = (String)CurrPrintStr + String.format("St: %s | ", Float.valueOf(currStCov));
            }
            if (historyAction.getBranchCoverage() != null) {
                prevBrCov = historyAction.getBranchCoverage().getPercentageFloat();
                PrevPrintStr = (String)PrevPrintStr + String.format("Br: %s | ", Float.valueOf(prevBrCov));
            }
            if (action.getBranchCoverage() != null) {
                currBrCov = action.getBranchCoverage().getPercentageFloat();
                CurrPrintStr = (String)CurrPrintStr + String.format("Br: %s | ", Float.valueOf(currBrCov));
            }
            if (historyAction.getMCDCCoverage() != null) {
                prevMCDCCov = historyAction.getMCDCCoverage().getPercentageFloat();
                PrevPrintStr = (String)PrevPrintStr + String.format("MCDC: %s | ", Float.valueOf(prevMCDCCov));
            }
            if (action.getMCDCCoverage() != null) {
                currMCDCCov = action.getMCDCCoverage().getPercentageFloat();
                CurrPrintStr = (String)CurrPrintStr + String.format("MCDC: %s | ", Float.valueOf(currMCDCCov));
            }
            if (historyAction.getFunctionCoverage() != null) {
                prevFuncCov = historyAction.getFunctionCoverage().getPercentageFloat();
                PrevPrintStr = (String)PrevPrintStr + String.format("Func: %s | ", Float.valueOf(prevFuncCov));
            }
            if (action.getFunctionCoverage() != null) {
                currFuncCov = action.getFunctionCoverage().getPercentageFloat();
                CurrPrintStr = (String)CurrPrintStr + String.format("Func: %s | ", Float.valueOf(currFuncCov));
            }
            if (historyAction.getFunctionCallCoverage() != null) {
                prevFuncCallCov = historyAction.getFunctionCallCoverage().getPercentageFloat();
                PrevPrintStr = (String)PrevPrintStr + String.format("FuncCall: %s | ", Float.valueOf(prevFuncCallCov));
            }
            if (action.getFunctionCallCoverage() != null) {
                currFuncCallCov = action.getFunctionCallCoverage().getPercentageFloat();
                CurrPrintStr = (String)CurrPrintStr + String.format("FuncCall: %s | ", Float.valueOf(currFuncCallCov));
            }
            logger.println("[VectorCASTCoverage] [INFO]: " + (String)CurrPrintStr);
            logger.println("[VectorCASTCoverage] [INFO]: " + (String)PrevPrintStr);
            if (this.getUseCoverageHistory().booleanValue()) {
                if (currBrCov < prevBrCov || currStCov < prevStCov) {
                    logger.println("[VectorCASTCoverage] [INFO]: code coverage history enforcement failed. Setting Build to FAILURE.");
                    run.setResult(Result.FAILURE);
                }
            } else {
                logger.println("[VectorCASTCoverage] [INFO]: Not checking code coverage history.");
            }
            String covDiffHtml = this.generateCoverageDiffs(prevStCov, currStCov, currBrCov, prevBrCov, currMCDCCov, prevMCDCCov, currFuncCov, prevFuncCov, currFuncCallCov, prevFuncCallCov, currBuildNum, histBuildNum);
            FilePath CovDiffFilePath = new FilePath(workspace, "coverage_diffs.html_tmp");
            CovDiffFilePath.write(covDiffHtml, "utf-8");
        } else {
            logger.println("[VectorCASTCoverage] [INFO]: Could not find previous non-failing build to checking code coverage history.");
        }
        this.checkThreshold(run, logger, action);
        return true;
    }

    private String generateCoverageDiffs(float prevStCov, float currStCov, float currBrCov, float prevBrCov, float currMCDCCov, float prevMCDCCov, float currFuncCov, float prevFuncCov, float currFuncCallCov, float prevFuncCallCov, int currBuildNumber, int prevBuildNumber) {
        String htmlTemplate = "  <table>%n    <tr>%n      <td>%n      <svg class=\"icon-clipboard icon-md\" aria-hidden=\"true\" xmlns=\"http://www.w3.org/2000/svg\" viewBox=\"0 0 512 512\">%n                <title></title>%n                <path d=\"M336 64h32a48 48 0 0148 48v320a48 48 0 01-48 48H144a48 48 0 01-48-48V112a48 48 0 0148-48h32\" fill=\"none\" stroke=\"currentColor\" stroke-linejoin=\"round\" stroke-width=\"32\"></path>%n                <rect x=\"176\" y=\"32\" width=\"160\" height=\"64\" rx=\"26.13\" ry=\"26.13\" fill=\"none\" stroke=\"currentColor\" stroke-linejoin=\"round\" stroke-width=\"32\"></rect>%n                </svg>%n      </td>%n      <td> <h3>Coverage Deltas </h3></td>%n    </tr>%n    <tr>%n      <td></td>%n      <td>%n        <table >%n          <tr>%n            <th style=\"border-bottom:1px solid #e5e5e5;text-align:left;padding:0.25em;padding-right:1em\">Build #</th>%n            <th style=\"border-bottom:1px solid #e5e5e5;text-align:left;padding:0.25em;padding-right:1em\">Statement</th>%n            <th style=\"border-bottom:1px solid #e5e5e5;text-align:left;padding:0.25em;padding-right:1em\">Branch</th>%n            <th style=\"border-bottom:1px solid #e5e5e5;text-align:left;padding:0.25em;padding-right:1em\">MC/DC</th>%n            <th style=\"border-bottom:1px solid #e5e5e5;text-align:left;padding:0.25em;padding-right:1em\">Function</th>%n            <th style=\"border-bottom:1px solid #e5e5e5;text-align:left;padding:0.25em;padding-right:1em\">Function Call</th>%n          </tr>%n          <tr>%n            <td style=\"border-bottom:1px solid #e5e5e5;text-align:left;padding:0.25em;padding-right:1em\">Build #%d</td>%n            <td style=\"border-bottom:1px solid #e5e5e5;text-align:left;padding:0.25em;padding-right:1em%s\">%s</td>%n            <td style=\"border-bottom:1px solid #e5e5e5;text-align:left;padding:0.25em;padding-right:1em%s\">%s</td>%n            <td style=\"border-bottom:1px solid #e5e5e5;text-align:left;padding:0.25em;padding-right:1em%s\">%s</td>%n            <td style=\"border-bottom:1px solid #e5e5e5;text-align:left;padding:0.25em;padding-right:1em%s\">%s</td>%n            <td style=\"border-bottom:1px solid #e5e5e5;text-align:left;padding:0.25em;padding-right:1em%s\">%s</td>%n          </tr>%n          <tr>%n            <td style=\"border-bottom:1px solid #e5e5e5;text-align:left;padding:0.25em;padding-right:1em\">Build #%d</td>%n            <td style=\"border-bottom:1px solid #e5e5e5;text-align:left;padding:0.25em;padding-right:1em\">%s</td>%n            <td style=\"border-bottom:1px solid #e5e5e5;text-align:left;padding:0.25em;padding-right:1em\">%s</td>%n            <td style=\"border-bottom:1px solid #e5e5e5;text-align:left;padding:0.25em;padding-right:1em\">%s</td>%n            <td style=\"border-bottom:1px solid #e5e5e5;text-align:left;padding:0.25em;padding-right:1em\">%s</td>%n            <td style=\"border-bottom:1px solid #e5e5e5;text-align:left;padding:0.25em;padding-right:1em\">%s</td>%n          </tr>%n        </table>%n      </td>%n    </tr>%n  </table>  %n";
        String increase = "; background-color:#c8f0c8";
        String decrease = "; background-color:#facaca";
        String S_currStCov = currStCov == -1.0f ? "-" : String.format("%5.02f%%", Float.valueOf(currStCov));
        String S_currBrCov = currBrCov == -1.0f ? "-" : String.format("%5.02f%%", Float.valueOf(currBrCov));
        String S_currMCDCCov = currMCDCCov == -1.0f ? "-" : String.format("%5.02f%%", Float.valueOf(currMCDCCov));
        String S_currFuncCov = currFuncCov == -1.0f ? "-" : String.format("%5.02f%%", Float.valueOf(currFuncCov));
        String S_currFuncCallCov = currFuncCallCov == -1.0f ? "-" : String.format("%5.02f%%", Float.valueOf(currFuncCallCov));
        String S_prevStCov = prevStCov == -1.0f ? "-" : String.format("%5.02f%%", Float.valueOf(prevStCov));
        String S_prevBrCov = prevBrCov == -1.0f ? "-" : String.format("%5.02f%%", Float.valueOf(prevBrCov));
        String S_prevMCDCCov = prevMCDCCov == -1.0f ? "-" : String.format("%5.02f%%", Float.valueOf(prevMCDCCov));
        String S_prevFuncCov = prevFuncCov == -1.0f ? "-" : String.format("%5.02f%%", Float.valueOf(prevFuncCov));
        String S_prevFuncCallCov = prevFuncCallCov == -1.0f ? "-" : String.format("%5.02f%%", Float.valueOf(prevFuncCallCov));
        String Color_currStCov = "";
        String Color_currBrCov = "";
        String Color_currMCDCCov = "";
        String Color_currFuncCov = "";
        String Color_currFuncCallCov = "";
        if (currStCov > prevStCov) {
            Color_currStCov = increase;
        } else if (currStCov < prevStCov) {
            Color_currStCov = decrease;
        }
        if (currBrCov > prevBrCov) {
            Color_currBrCov = increase;
        } else if (currBrCov < prevBrCov) {
            Color_currBrCov = decrease;
        }
        if (currMCDCCov > prevMCDCCov) {
            Color_currMCDCCov = increase;
        } else if (currMCDCCov < prevMCDCCov) {
            Color_currMCDCCov = decrease;
        }
        if (currFuncCov > prevFuncCov) {
            Color_currFuncCov = increase;
        } else if (currFuncCov < prevFuncCov) {
            Color_currFuncCov = decrease;
        }
        if (currFuncCallCov > prevFuncCallCov) {
            Color_currFuncCallCov = increase;
        } else if (currFuncCallCov < prevFuncCallCov) {
            Color_currFuncCallCov = decrease;
        }
        return String.format(htmlTemplate, currBuildNumber, Color_currStCov, S_currStCov, Color_currBrCov, S_currBrCov, Color_currMCDCCov, S_currMCDCCov, Color_currFuncCov, S_currFuncCov, Color_currFuncCallCov, S_currFuncCallCov, prevBuildNumber, S_prevStCov, S_prevBrCov, S_prevMCDCCov, S_prevFuncCov, S_prevFuncCallCov);
    }

    private void printThresholdFailure(PrintStream logger, String coverageType, int percent, int threshold) {
        logger.println("[VectorCASTCoverage] [FAIL]: " + coverageType + " coverage " + percent + "% < " + threshold + "% threshold.");
    }

    private void checkThreshold(Run<?, ?> run, PrintStream logger, VectorCASTBuildAction action) {
        if (this.useThreshold.booleanValue() && this.unhealthyTarget == null) {
            if (this.isBranchCoverageOk(action) || this.isStatementCoverageOk(action) || this.isBasisPathCoverageOk(action) || this.isMCDCCoverageOk(action) || this.isFunctionCoverageOk(action) || this.isFunctionCallCoverageOk(action)) {
                logger.println("[VectorCASTCoverage] [FAIL]: Build failed due to a coverage metric fell below the minimum threshold");
                run.setResult(Result.FAILURE);
            }
            if (this.isStatementCoverageOk(action)) {
                this.printThresholdFailure(logger, "Statement", action.getStatementCoverage().getPercentage(), this.healthReports.getMinStatement());
            }
            if (this.isBranchCoverageOk(action)) {
                this.printThresholdFailure(logger, "Branch", action.getBranchCoverage().getPercentage(), this.healthReports.getMinBranch());
            }
            if (this.isBasisPathCoverageOk(action)) {
                this.printThresholdFailure(logger, "Basis Path", action.getBasisPathCoverage().getPercentage(), this.healthReports.getMinBasisPath());
            }
            if (this.isMCDCCoverageOk(action)) {
                this.printThresholdFailure(logger, "MC/DC", action.getMCDCCoverage().getPercentage(), this.healthReports.getMinMCDC());
            }
            if (this.isFunctionCoverageOk(action)) {
                this.printThresholdFailure(logger, "Function", action.getFunctionCoverage().getPercentage(), this.healthReports.getMinFunction());
            }
            if (this.isFunctionCallCoverageOk(action)) {
                this.printThresholdFailure(logger, "Function Call", action.getFunctionCallCoverage().getPercentage(), this.healthReports.getMinFunctionCall());
            }
        }
    }

    private boolean isMCDCCoverageOk(VectorCASTBuildAction action) {
        if (action.getMCDCCoverage() == null) {
            return false;
        }
        return action.getMCDCCoverage().getPercentage() < this.healthReports.getMinMCDC();
    }

    private boolean isBasisPathCoverageOk(VectorCASTBuildAction action) {
        if (action.getBasisPathCoverage() == null) {
            return false;
        }
        return action.getBasisPathCoverage().getPercentage() < this.healthReports.getMinBasisPath();
    }

    private boolean isStatementCoverageOk(VectorCASTBuildAction action) {
        if (action.getStatementCoverage() == null) {
            return false;
        }
        return action.getStatementCoverage().getPercentage() < this.healthReports.getMinStatement();
    }

    private boolean isBranchCoverageOk(VectorCASTBuildAction action) {
        if (action.getBranchCoverage() == null) {
            return false;
        }
        return action.getBranchCoverage().getPercentage() < this.healthReports.getMinBranch();
    }

    private boolean isFunctionCoverageOk(VectorCASTBuildAction action) {
        if (action.getFunctionCoverage() == null) {
            return false;
        }
        return action.getFunctionCoverage().getPercentage() < this.healthReports.getMinFunction();
    }

    private boolean isFunctionCallCoverageOk(VectorCASTBuildAction action) {
        if (action.getFunctionCallCoverage() == null) {
            return false;
        }
        return action.getFunctionCallCoverage().getPercentage() < this.healthReports.getMinFunctionCall();
    }

    public Action getProjectAction(Job<?, ?> project) {
        return new VectorCASTProjectAction(project);
    }

    public BuildStepMonitor getRequiredMonitorService() {
        return BuildStepMonitor.BUILD;
    }

    static File getVectorCASTReport(Run<?, ?> run) {
        return new File(run.getRootDir(), "vectorcastcoverage");
    }

    public BuildStepDescriptor<Publisher> getDescriptor() {
        return DESCRIPTOR;
    }

    private boolean didVecctorCASTRun(Iterable<MavenBuild> mavenBuilds) {
        for (MavenBuild run : mavenBuilds) {
            if (!this.didVecctorCASTRun(run)) continue;
            return true;
        }
        return false;
    }

    private boolean didVecctorCASTRun(MavenBuild mavenBuild) {
        for (ExecutedMojo mojo : mavenBuild.getExecutedMojos()) {
            if (!"org.codehaus.mojo".equals(mojo.groupId) || !"vectorcastexecution-maven-plugin".equals(mojo.artifactId)) continue;
            return true;
        }
        return false;
    }

    public static class DescriptorImpl
    extends BuildStepDescriptor<Publisher> {
        public DescriptorImpl() {
            super(VectorCASTPublisher.class);
        }

        public String getDisplayName() {
            return Messages.VcastCoveragePublisher_DisplayName();
        }

        public boolean isApplicable(Class<? extends AbstractProject> aClass) {
            return true;
        }

        public boolean configure(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
            req.bindParameters((Object)this, "vectorcastcoverage.");
            this.save();
            return super.configure(req, formData);
        }

        public Publisher newInstance(StaplerRequest req, JSONObject json) throws Descriptor.FormException {
            String loc_includes = json.optString("includes", "xml_data/coverage_results*.xml");
            if (loc_includes.isEmpty()) {
                loc_includes = "xml_data/coverage_results*.xml";
            }
            Boolean loc_useThreshold = json.optBoolean("useThreshold", false);
            Boolean loc_useCoverageHistory = json.optBoolean("useCoverageHistory", false);
            Integer loc_maxHistory = json.optInt("maxHistory", Integer.MAX_VALUE);
            int maxStatement = json.optInt("maxStatement", 100);
            int maxBranch = json.optInt("maxBranch", 70);
            int maxBasisPath = json.optInt("maxBasisPath", 80);
            int maxMCDC = json.optInt("maxMCDC", 80);
            int maxFunction = json.optInt("maxFunction", 80);
            int maxFunctionCall = json.optInt("maxFunctionCall", 80);
            int minStatement = json.optInt("minStatement", 0);
            int minBranch = json.optInt("minBranch", 0);
            int minBasisPath = json.optInt("minBasisPath", 0);
            int minMCDC = json.optInt("minMCDC", 0);
            int minFunction = json.optInt("minFunction", 0);
            int minFunctionCall = json.optInt("minFunctionCall", 0);
            VectorCASTHealthReportThresholds loc_healthReports = new VectorCASTHealthReportThresholds(minStatement, maxStatement, minBranch, maxBranch, minBasisPath, maxBasisPath, minMCDC, maxMCDC, minFunction, maxFunction, minFunctionCall, maxFunctionCall);
            VectorCASTPublisher pub = new VectorCASTPublisher(loc_includes, loc_useThreshold, loc_healthReports, null, loc_useCoverageHistory, loc_maxHistory);
            req.bindParameters((Object)pub, "vectorcastcoverage.");
            req.bindParameters((Object)pub.healthReports, "vectorCASTHealthReports.");
            if ("".equals(req.getParameter("vectorCASTHealthReports.maxStatement"))) {
                pub.healthReports.setMaxStatement(100);
            }
            if ("".equals(req.getParameter("vectorCASTHealthReports.maxBranch"))) {
                pub.healthReports.setMaxBranch(70);
            }
            if ("".equals(req.getParameter("vectorCASTHealthReports.maxBasisPath"))) {
                pub.healthReports.setMaxBasisPath(80);
            }
            if ("".equals(req.getParameter("vectorCASTHealthReports.maxMCDC"))) {
                pub.healthReports.setMaxMCDC(80);
            }
            if ("".equals(req.getParameter("vectorCASTHealthReports.maxFunction"))) {
                pub.healthReports.setMaxFunction(80);
            }
            if ("".equals(req.getParameter("vectorCASTHealthReports.maxFunctionCall"))) {
                pub.healthReports.setMaxFunctionCall(80);
            }
            return pub;
        }
    }
}

