/*
 * Decompiled with CFR 0.152.
 */
package com.vectorcast.plugins.vectorcastcoverage;

import com.vectorcast.plugins.vectorcastcoverage.CoverageObject;
import com.vectorcast.plugins.vectorcastcoverage.CoverageReport;
import com.vectorcast.plugins.vectorcastcoverage.Messages;
import com.vectorcast.plugins.vectorcastcoverage.Ratio;
import com.vectorcast.plugins.vectorcastcoverage.Rule;
import com.vectorcast.plugins.vectorcastcoverage.VectorCASTHealthReportThresholds;
import com.vectorcast.plugins.vectorcastcoverage.VectorCASTProjectAction;
import com.vectorcast.plugins.vectorcastcoverage.VectorCASTPublisher;
import hudson.FilePath;
import hudson.model.AbstractBuild;
import hudson.model.Action;
import hudson.model.HealthReport;
import hudson.model.HealthReportingAction;
import hudson.model.Result;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.util.NullStream;
import hudson.util.StreamTaskListener;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.model.RunAction2;
import jenkins.tasks.SimpleBuildStep;
import org.jvnet.localizer.Localizable;
import org.kohsuke.stapler.StaplerProxy;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;
import org.xmlpull.v1.XmlPullParserFactory;

public final class VectorCASTBuildAction
extends CoverageObject<VectorCASTBuildAction>
implements HealthReportingAction,
StaplerProxy,
Serializable,
RunAction2,
SimpleBuildStep.LastBuildAction {
    private static final long serialVersionUID = 4691586L;
    private transient Run<?, ?> owner;
    private transient WeakReference<CoverageReport> report;
    private transient VectorCASTProjectAction vectorcastProjectAction;
    private final Rule rule;
    private final VectorCASTHealthReportThresholds thresholds;
    private static final Logger logger = Logger.getLogger(VectorCASTBuildAction.class.getName());

    public VectorCASTBuildAction(Run<?, ?> owner, Rule rule, Ratio StatementCoverage, Ratio BranchCoverage, Ratio BasisPathCoverage, Ratio MCDCCoverage, Ratio FunctionCoverage, Ratio FunctionCallCoverage, Ratio Complexity, VectorCASTHealthReportThresholds thresholds) {
        this.owner = owner;
        this.rule = rule;
        this.Statement = StatementCoverage;
        this.Branch = BranchCoverage;
        this.BasisPath = BasisPathCoverage;
        this.MCDC = MCDCCoverage;
        this.Function = FunctionCoverage;
        this.FunctionCall = FunctionCallCoverage;
        this.Complexity = Complexity;
        this.thresholds = thresholds;
    }

    public String getDisplayName() {
        return Messages.BuildAction_DisplayName();
    }

    public String getIconFileName() {
        return "graph.gif";
    }

    public String getUrlName() {
        return "vectorcastcoverage";
    }

    public HealthReport getBuildHealth() {
        int percent;
        if (this.thresholds == null) {
            return null;
        }
        this.thresholds.ensureValid();
        int score = 100;
        ArrayList<Localizable> reports = new ArrayList<Localizable>(5);
        if (this.Statement != null && this.thresholds.getMaxStatement() > 0) {
            percent = this.Statement.getPercentage();
            if (percent < this.thresholds.getMaxStatement()) {
                reports.add(Messages._BuildAction_Statement(this.Statement, percent));
            }
            score = VectorCASTBuildAction.updateHealthScore(score, this.thresholds.getMinStatement(), percent, this.thresholds.getMaxStatement());
        }
        if (this.Branch != null && this.thresholds.getMaxBranch() > 0) {
            percent = this.Branch.getPercentage();
            if (percent < this.thresholds.getMaxBranch()) {
                reports.add(Messages._BuildAction_Branch(this.Branch, percent));
            }
            score = VectorCASTBuildAction.updateHealthScore(score, this.thresholds.getMinBranch(), percent, this.thresholds.getMaxBranch());
        }
        if (this.BasisPath != null && this.thresholds.getMaxBasisPath() > 0) {
            percent = this.BasisPath.getPercentage();
            if (percent < this.thresholds.getMaxBasisPath()) {
                reports.add(Messages._BuildAction_BasisPath(this.BasisPath, percent));
            }
            score = VectorCASTBuildAction.updateHealthScore(score, this.thresholds.getMinBasisPath(), percent, this.thresholds.getMaxBasisPath());
        }
        if (this.MCDC != null && this.thresholds.getMaxMCDC() > 0) {
            percent = this.MCDC.getPercentage();
            if (percent < this.thresholds.getMaxMCDC()) {
                reports.add(Messages._BuildAction_MCDC(this.MCDC, percent));
            }
            score = VectorCASTBuildAction.updateHealthScore(score, this.thresholds.getMinMCDC(), percent, this.thresholds.getMaxMCDC());
        }
        if (this.Function != null && this.thresholds.getMaxFunction() > 0) {
            percent = this.Function.getPercentage();
            if (percent < this.thresholds.getMaxFunction()) {
                reports.add(Messages._BuildAction_Function(this.Function, percent));
            }
            score = VectorCASTBuildAction.updateHealthScore(score, this.thresholds.getMinFunction(), percent, this.thresholds.getMaxFunction());
        }
        if (this.FunctionCall != null && this.thresholds.getMaxFunctionCall() > 0) {
            percent = this.FunctionCall.getPercentage();
            if (percent < this.thresholds.getMaxFunctionCall()) {
                reports.add(Messages._BuildAction_FunctionCall(this.FunctionCall, percent));
            }
            score = VectorCASTBuildAction.updateHealthScore(score, this.thresholds.getMinFunctionCall(), percent, this.thresholds.getMaxFunctionCall());
        }
        if (score == 100) {
            reports.add(Messages._BuildAction_Perfect());
        }
        Object[] args = reports.toArray(new Object[6]);
        for (int i = 5; i >= 0 && args[i] == null; --i) {
            args[i] = "";
        }
        return new HealthReport(score, Messages._BuildAction_Description(args[0], args[1], args[2], args[3], args[4], args[5]));
    }

    private static int updateHealthScore(int score, int min, int value, int max) {
        if (value >= max) {
            return score;
        }
        if (value <= min) {
            return 0;
        }
        assert (max != min);
        int scaled = (int)(100.0 * (double)((float)value - (float)min) / (double)(max - min));
        if (scaled < score) {
            return scaled;
        }
        return score;
    }

    public Object getTarget() {
        return this.getResult();
    }

    @Override
    public Run<?, ?> getBuild() {
        return this.owner;
    }

    public int getBuildNumber() {
        return this.owner.getNumber();
    }

    protected static FilePath[] getVectorCASTCoverageReports(File file) throws IOException, InterruptedException {
        FilePath[] filePathArray;
        FilePath path = new FilePath(file);
        if (path.isDirectory()) {
            return path.list("*xml");
        }
        FilePath report = new FilePath(new File(path.getName() + ".xml"));
        if (report.exists()) {
            FilePath[] filePathArray2 = new FilePath[1];
            filePathArray = filePathArray2;
            filePathArray2[0] = report;
        } else {
            filePathArray = new FilePath[]{};
        }
        return filePathArray;
    }

    public synchronized CoverageReport getResult() {
        CoverageReport r;
        if (this.report != null && (r = (CoverageReport)this.report.get()) != null) {
            return r;
        }
        File reportFolder = VectorCASTPublisher.getVectorCASTReport(this.owner);
        try {
            FilePath[] reports = VectorCASTBuildAction.getVectorCASTCoverageReports(reportFolder);
            try {
                InputStream[] streams = new InputStream[reports.length];
                for (int i = 0; i < reports.length; ++i) {
                    streams[i] = reports[i].read();
                }
                CoverageReport r2 = new CoverageReport(this, streams);
                if (this.rule != null) {
                    logger.info("calculating failed packages based on " + String.valueOf(this.rule));
                    this.rule.enforce(r2, (TaskListener)new StreamTaskListener((OutputStream)new NullStream()));
                }
                this.report = new WeakReference<CoverageReport>(r2);
                return r2;
            }
            catch (InterruptedException e) {
                logger.log(Level.WARNING, "Failed to load " + String.valueOf(reportFolder), e);
                return null;
            }
            catch (IOException e) {
                String message = e.getMessage();
                String[] msgElements = message.split(":");
                Integer idx = Integer.valueOf(msgElements[1]);
                logger.log(Level.WARNING, "Error Parsing VectorCAST Coverage file: " + reports[idx].getName());
                logger.log(Level.WARNING, "  >> " + msgElements[0] + "   " + String.valueOf(e.getCause()));
                return null;
            }
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "Failed to load results from: " + String.valueOf(reportFolder), e);
            return null;
        }
    }

    @Override
    public VectorCASTBuildAction getPreviousResult() {
        return VectorCASTBuildAction.getPreviousResult(this.owner);
    }

    static VectorCASTBuildAction getPreviousResult(Run<?, ?> start) {
        VectorCASTBuildAction r;
        Run b = start;
        do {
            if ((b = b.getPreviousBuild()) != null) continue;
            return null;
        } while (b.getResult() == Result.FAILURE || (r = (VectorCASTBuildAction)b.getAction(VectorCASTBuildAction.class)) == null);
        return r;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static VectorCASTBuildAction load(AbstractBuild<?, ?> owner, Rule rule, VectorCASTHealthReportThresholds thresholds, FilePath ... files) throws IOException {
        Ratio[] ratios = null;
        boolean[] flag = new boolean[]{false};
        for (FilePath f : files) {
            try (InputStream in = null;){
                in = f.read();
                ratios = VectorCASTBuildAction.loadRatios(in, ratios, flag);
            }
        }
        return new VectorCASTBuildAction((Run<?, ?>)owner, rule, (Ratio)ratios[0], (Ratio)ratios[1], (Ratio)ratios[2], ratios[3], ratios[4], ratios[5], ratios[6], thresholds);
    }

    public static VectorCASTBuildAction load(Run<?, ?> owner, Rule rule, VectorCASTHealthReportThresholds thresholds, InputStream ... streams) throws IOException {
        Ratio[] ratios = null;
        boolean[] flag = new boolean[]{false};
        for (InputStream in : streams) {
            try {
                ratios = VectorCASTBuildAction.loadRatios(in, ratios, flag);
            }
            catch (XmlPullParserException e) {
                throw new IOException("Failed to parse " + String.valueOf(in), e);
            }
            finally {
                if (in != null) {
                    in.close();
                }
            }
        }
        return new VectorCASTBuildAction(owner, rule, (Ratio)ratios[0], ratios[1], ratios[2], ratios[3], ratios[4], ratios[5], ratios[6], thresholds);
    }

    public static VectorCASTBuildAction load(AbstractBuild<?, ?> owner, Rule rule, VectorCASTHealthReportThresholds thresholds, InputStream ... streams) throws IOException, XmlPullParserException {
        Ratio[] ratios = null;
        boolean[] flag = new boolean[]{false};
        for (InputStream in : streams) {
            ratios = VectorCASTBuildAction.loadRatios(in, ratios, flag);
        }
        return new VectorCASTBuildAction((Run<?, ?>)owner, rule, (Ratio)ratios[0], ratios[1], ratios[2], ratios[3], ratios[4], ratios[5], ratios[6], thresholds);
    }

    private static Ratio[] loadRatios(InputStream in, Ratio[] r, boolean[] topLevel) throws IOException, XmlPullParserException {
        XmlPullParserFactory factory = XmlPullParserFactory.newInstance();
        factory.setNamespaceAware(true);
        XmlPullParser parser = factory.newPullParser();
        parser.setInput(in, null);
        String versionRead = "undefined";
        Boolean continueParsing = true;
        while (continueParsing.booleanValue()) {
            if (parser.nextTag() != 2) continue;
            if (parser.getName().equals("version")) {
                versionRead = parser.getAttributeValue("", "value");
            }
            if (!parser.getName().equals("coverage") && !parser.getName().equals("combined-coverage")) continue;
            continueParsing = false;
        }
        if (!versionRead.equals("3")) {
            throw new XmlPullParserException("Unsupported version: '" + versionRead + "', expecting 3");
        }
        if (r == null || r.length < 7) {
            r = new Ratio[7];
        }
        for (int i = 0; i < r.length; ++i) {
            int index;
            boolean combined = false;
            if (!parser.getName().equals("coverage") && !parser.getName().equals("combined-coverage")) break;
            if (parser.getName().equals("coverage")) {
                parser.require(2, "", "coverage");
                combined = false;
            } else if (parser.getName().equals("combined-coverage")) break;
            String v = parser.getAttributeValue("", "value");
            String t = parser.getAttributeValue("", "type");
            if (t.equals("statement, %")) {
                index = 0;
            } else if (t.equals("branch, %")) {
                index = 1;
            } else if (t.equals("basispath, %")) {
                index = 2;
            } else if (t.equals("mcdc, %")) {
                index = 3;
            } else if (t.equals("function, %")) {
                index = 4;
            } else if (t.equals("functioncall, %")) {
                index = 5;
            } else {
                if (!t.equals("complexity, %")) continue;
                index = 6;
            }
            if (r[index] == null) {
                r[index] = Ratio.parseValue(v);
            } else if (combined) {
                r[index].setValue(v);
            } else if (!topLevel[0]) {
                r[index].addValue(v);
            }
            parser.nextTag();
            parser.nextTag();
        }
        return r;
    }

    private void setOwner(Run<?, ?> owner) {
        this.vectorcastProjectAction = new VectorCASTProjectAction(owner.getParent());
        this.owner = owner;
    }

    public void onLoad(Run<?, ?> run) {
        this.setOwner(run);
    }

    public void onAttached(Run<?, ?> run) {
        this.setOwner(run);
    }

    public Collection<? extends Action> getProjectActions() {
        if (this.vectorcastProjectAction == null) {
            this.vectorcastProjectAction = new VectorCASTProjectAction(this.owner.getParent());
        }
        return Collections.singletonList(this.vectorcastProjectAction);
    }
}

