/*
 * Decompiled with CFR 0.152.
 */
package com.vectorcast.plugins.vectorcastcoverage;

import java.io.IOException;
import java.io.Serializable;
import org.kohsuke.stapler.export.Exported;
import org.kohsuke.stapler.export.ExportedBean;

@ExportedBean
public final class Ratio
implements Serializable {
    private float numerator = 0.0f;
    private float denominator = 0.0f;
    boolean initialized = false;
    private static final long serialVersionUID = 1L;

    public Ratio(float ... f) {
        if (f.length >= 2) {
            this.initialized = true;
            this.numerator = f[0];
            this.denominator = f[1];
        }
    }

    public float getNumerator() {
        return this.numerator;
    }

    public float getDenominator() {
        return this.denominator;
    }

    public String toString() {
        return this.print(this.numerator) + "/" + this.print(this.denominator);
    }

    private String print(float f) {
        int i = (int)f;
        if ((float)i == f) {
            return String.valueOf(i);
        }
        return String.valueOf(f);
    }

    @Exported
    public int getPercentage() {
        return Math.round(this.getPercentageFloat());
    }

    @Exported
    public float getPercentageFloat() {
        return this.denominator <= 0.0f ? 0.0f : 100.0f * this.numerator / this.denominator;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Ratio ratio = (Ratio)o;
        return Float.compare(ratio.denominator, this.denominator) == 0 && Float.compare(ratio.numerator, this.numerator) == 0;
    }

    public int hashCode() {
        int result = this.numerator != 0.0f ? Float.floatToIntBits(this.numerator) : 0;
        result = (float)(31 * result) + this.denominator != 0.0f ? Float.floatToIntBits(this.denominator) : 0;
        return result;
    }

    public void addValue(String v) {
        float[] f = Ratio.parse(v);
        this.numerator += f[0];
        this.denominator += f[1];
        this.initialized = true;
    }

    public void setValue(String v) {
        float[] f = Ratio.parse(v);
        this.numerator = f[0];
        this.denominator = f[1];
        this.initialized = true;
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    static float[] parse(String v) {
        int idx = v.indexOf(40);
        v = v.substring(idx + 1, v.length() - 1);
        idx = v.indexOf(47);
        return new float[]{Ratio.parseFloat(v.substring(0, idx)), Ratio.parseFloat(v.substring(idx + 1))};
    }

    static Ratio parseValue(String v) throws IOException {
        return new Ratio(Ratio.parse(v));
    }

    private static float parseFloat(String v) {
        int idx = ((String)v).indexOf(44);
        if (idx >= 0) {
            v = ((String)v).substring(0, idx) + "." + ((String)v).substring(idx + 1);
        }
        return Float.parseFloat((String)v);
    }
}

