/*
 * Decompiled with CFR 0.152.
 */
package com.vectorcast.plugins.vectorcastcoverage;

import com.vectorcast.plugins.vectorcastcoverage.AggregatedReport;
import com.vectorcast.plugins.vectorcastcoverage.CoverageElement;
import com.vectorcast.plugins.vectorcastcoverage.EnvironmentReport;
import com.vectorcast.plugins.vectorcastcoverage.SubprogramReport;
import com.vectorcast.plugins.vectorcastcoverage.UnitReport;
import com.vectorcast.plugins.vectorcastcoverage.VectorCASTBuildAction;
import hudson.model.Run;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.digester3.Digester;
import org.xml.sax.SAXException;

public final class CoverageReport
extends AggregatedReport<CoverageReport, CoverageReport, EnvironmentReport> {
    private final VectorCASTBuildAction action;

    private CoverageReport(VectorCASTBuildAction action) {
        this.action = action;
        this.setName("VectorCAST");
    }

    public CoverageReport(VectorCASTBuildAction action, InputStream ... xmlReports) throws IOException {
        this(action);
        int idx = 0;
        for (InputStream is : xmlReports) {
            try {
                this.createDigester(!Boolean.getBoolean(this.getClass().getName() + ".UNSAFE")).parse(is);
                ++idx;
            }
            catch (SAXException e) {
                throw new IOException("Failed to parse XML:" + idx, e);
            }
        }
        this.setParent(null);
    }

    public CoverageReport(VectorCASTBuildAction action, File xmlReport) throws IOException {
        this(action);
        try {
            this.createDigester(!Boolean.getBoolean(this.getClass().getName() + ".UNSAFE")).parse(xmlReport);
        }
        catch (SAXException e) {
            throw new IOException("Failed to parse " + String.valueOf(xmlReport), e);
        }
        this.setParent(null);
    }

    @Override
    public CoverageReport getPreviousResult() {
        VectorCASTBuildAction prev = this.action.getPreviousResult();
        if (prev != null) {
            return prev.getResult();
        }
        return null;
    }

    @Override
    public Run<?, ?> getBuild() {
        return this.action.getBuild();
    }

    private Digester createDigester(boolean secure) throws SAXException {
        Digester digester = new Digester();
        if (secure) {
            digester.setXIncludeAware(false);
            try {
                digester.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
                digester.setFeature("http://xml.org/sax/features/external-general-entities", false);
                digester.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
                digester.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
            }
            catch (ParserConfigurationException ex) {
                throw new SAXException("Failed to securely configure xml digester parser", ex);
            }
        }
        digester.setClassLoader(this.getClass().getClassLoader());
        digester.push((Object)this);
        digester.addObjectCreate("*/environment", EnvironmentReport.class);
        digester.addSetNext("*/environment", "add");
        digester.addSetProperties("*/environment");
        digester.addObjectCreate("*/unit", UnitReport.class);
        digester.addSetNext("*/unit", "add");
        digester.addSetProperties("*/unit");
        digester.addObjectCreate("*/subprogram", SubprogramReport.class);
        digester.addSetNext("*/subprogram", "add");
        digester.addSetProperties("*/subprogram");
        digester.addObjectCreate("*/coverage", CoverageElement.class);
        digester.addSetProperties("*/coverage");
        digester.addSetNext("*/coverage", "addCoverage");
        return digester;
    }
}

