/*
 * Decompiled with CFR 0.152.
 */
package com.vectorcast.plugins.vectorcastcoverage;

import com.vectorcast.plugins.vectorcastcoverage.AbstractReport;
import java.io.IOException;
import java.util.Map;
import java.util.TreeMap;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;

public abstract class AggregatedReport<PARENT extends AggregatedReport<?, PARENT, ?>, SELF extends AggregatedReport<PARENT, SELF, CHILD>, CHILD extends AbstractReport<SELF, CHILD>>
extends AbstractReport<PARENT, SELF> {
    private final Map<String, CHILD> children = new TreeMap<String, CHILD>();

    public void add(CHILD child) {
        this.children.put(((AbstractReport)child).getName(), child);
    }

    public Map<String, CHILD> getChildren() {
        return this.children;
    }

    @Override
    protected void setParent(PARENT p) {
        super.setParent(p);
        for (AbstractReport c : this.children.values()) {
            c.setParent(this);
        }
    }

    public CHILD getDynamic(String token, StaplerRequest req, StaplerResponse rsp) throws IOException {
        return (CHILD)((AbstractReport)this.getChildren().get(token));
    }

    @Override
    public void setFailed() {
        super.setFailed();
        if (this.getParent() != null) {
            ((AggregatedReport)this.getParent()).setFailed();
        }
    }

    public boolean hasChildren() {
        return this.getChildren().size() > 0;
    }

    public boolean hasChildrenStatementCoverage() {
        for (AbstractReport child : this.getChildren().values()) {
            if (!child.hasStatementCoverage()) continue;
            return true;
        }
        return false;
    }

    public boolean hasChildrenBranchCoverage() {
        for (AbstractReport child : this.getChildren().values()) {
            if (!child.hasBranchCoverage()) continue;
            return true;
        }
        return false;
    }

    public boolean hasChildrenBasisPathCoverage() {
        for (AbstractReport child : this.getChildren().values()) {
            if (!child.hasBasisPathCoverage()) continue;
            return true;
        }
        return false;
    }

    public boolean hasChildrenMCDCCoverage() {
        for (AbstractReport child : this.getChildren().values()) {
            if (!child.hasMCDCCoverage()) continue;
            return true;
        }
        return false;
    }

    public boolean hasChildrenFunctionCoverage() {
        for (AbstractReport child : this.getChildren().values()) {
            if (!child.hasFunctionCoverage()) continue;
            return true;
        }
        return false;
    }

    public boolean hasChildrenFunctionCallCoverage() {
        for (AbstractReport child : this.getChildren().values()) {
            if (!child.hasFunctionCallCoverage()) continue;
            return true;
        }
        return false;
    }
}

