// CHECKSTYLE:OFF

package com.vectorcast.plugins.vectorcastcoverage;

import org.jvnet.localizer.Localizable;
import org.jvnet.localizer.ResourceBundleHolder;
import org.kohsuke.accmod.Restricted;


/**
 * Generated localization support class.
 * 
 */
@SuppressWarnings({
    "",
    "PMD",
    "all"
})
@Restricted(org.kohsuke.accmod.restrictions.NoExternalUse.class)
public class Messages {

    /**
     * The resource bundle reference
     * 
     */
    private final static ResourceBundleHolder holder = ResourceBundleHolder.get(Messages.class);

    /**
     * Key {@code BuildAction.DisplayName}: {@code Coverage Report}.
     * 
     * @return
     *     {@code Coverage Report}
     */
    public static String BuildAction_DisplayName() {
        return holder.format("BuildAction.DisplayName");
    }

    /**
     * Key {@code BuildAction.DisplayName}: {@code Coverage Report}.
     * 
     * @return
     *     {@code Coverage Report}
     */
    public static Localizable _BuildAction_DisplayName() {
        return new Localizable(holder, "BuildAction.DisplayName");
    }

    /**
     * Key {@code CoverageObject.Legend.Function}: {@code Function}.
     * 
     * @return
     *     {@code Function}
     */
    public static String CoverageObject_Legend_Function() {
        return holder.format("CoverageObject.Legend.Function");
    }

    /**
     * Key {@code CoverageObject.Legend.Function}: {@code Function}.
     * 
     * @return
     *     {@code Function}
     */
    public static Localizable _CoverageObject_Legend_Function() {
        return new Localizable(holder, "CoverageObject.Legend.Function");
    }

    /**
     * Key {@code BuildAction.Perfect}: {@code All coverage targets have been
     * met.}.
     * 
     * @return
     *     {@code All coverage targets have been met.}
     */
    public static String BuildAction_Perfect() {
        return holder.format("BuildAction.Perfect");
    }

    /**
     * Key {@code BuildAction.Perfect}: {@code All coverage targets have been
     * met.}.
     * 
     * @return
     *     {@code All coverage targets have been met.}
     */
    public static Localizable _BuildAction_Perfect() {
        return new Localizable(holder, "BuildAction.Perfect");
    }

    /**
     * Key {@code CoverageObject.Legend.FunctionCall}: {@code Function Call}.
     * 
     * @return
     *     {@code Function Call}
     */
    public static String CoverageObject_Legend_FunctionCall() {
        return holder.format("CoverageObject.Legend.FunctionCall");
    }

    /**
     * Key {@code CoverageObject.Legend.FunctionCall}: {@code Function Call}.
     * 
     * @return
     *     {@code Function Call}
     */
    public static Localizable _CoverageObject_Legend_FunctionCall() {
        return new Localizable(holder, "CoverageObject.Legend.FunctionCall");
    }

    /**
     * Key {@code BuildAction.FunctionCall}: {@code Function Call {0}
     * ({1}%).}.
     * 
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Function Call {0} ({1}%).}
     */
    public static String BuildAction_FunctionCall(Object arg0, Object arg1) {
        return holder.format("BuildAction.FunctionCall", arg0, arg1);
    }

    /**
     * Key {@code BuildAction.FunctionCall}: {@code Function Call {0}
     * ({1}%).}.
     * 
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Function Call {0} ({1}%).}
     */
    public static Localizable _BuildAction_FunctionCall(Object arg0, Object arg1) {
        return new Localizable(holder, "BuildAction.FunctionCall", arg0, arg1);
    }

    /**
     * Key {@code BuildAction.BasisPath}: {@code Basis Path {0} ({1}%).}.
     * 
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Basis Path {0} ({1}%).}
     */
    public static String BuildAction_BasisPath(Object arg0, Object arg1) {
        return holder.format("BuildAction.BasisPath", arg0, arg1);
    }

    /**
     * Key {@code BuildAction.BasisPath}: {@code Basis Path {0} ({1}%).}.
     * 
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Basis Path {0} ({1}%).}
     */
    public static Localizable _BuildAction_BasisPath(Object arg0, Object arg1) {
        return new Localizable(holder, "BuildAction.BasisPath", arg0, arg1);
    }

    /**
     * Key {@code CoverageObject.Legend.MCDC}: {@code MC/DC}.
     * 
     * @return
     *     {@code MC/DC}
     */
    public static String CoverageObject_Legend_MCDC() {
        return holder.format("CoverageObject.Legend.MCDC");
    }

    /**
     * Key {@code CoverageObject.Legend.MCDC}: {@code MC/DC}.
     * 
     * @return
     *     {@code MC/DC}
     */
    public static Localizable _CoverageObject_Legend_MCDC() {
        return new Localizable(holder, "CoverageObject.Legend.MCDC");
    }

    /**
     * Key {@code BuildAction.MCDC}: {@code MC/DC {0} ({1}%).}.
     * 
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code MC/DC {0} ({1}%).}
     */
    public static String BuildAction_MCDC(Object arg0, Object arg1) {
        return holder.format("BuildAction.MCDC", arg0, arg1);
    }

    /**
     * Key {@code BuildAction.MCDC}: {@code MC/DC {0} ({1}%).}.
     * 
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code MC/DC {0} ({1}%).}
     */
    public static Localizable _BuildAction_MCDC(Object arg0, Object arg1) {
        return new Localizable(holder, "BuildAction.MCDC", arg0, arg1);
    }

    /**
     * Key {@code CoverageObject.Legend.Statement}: {@code Statement}.
     * 
     * @return
     *     {@code Statement}
     */
    public static String CoverageObject_Legend_Statement() {
        return holder.format("CoverageObject.Legend.Statement");
    }

    /**
     * Key {@code CoverageObject.Legend.Statement}: {@code Statement}.
     * 
     * @return
     *     {@code Statement}
     */
    public static Localizable _CoverageObject_Legend_Statement() {
        return new Localizable(holder, "CoverageObject.Legend.Statement");
    }

    /**
     * Key {@code BuildAction.Branch}: {@code Branch {0} ({1}%).}.
     * 
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Branch {0} ({1}%).}
     */
    public static String BuildAction_Branch(Object arg0, Object arg1) {
        return holder.format("BuildAction.Branch", arg0, arg1);
    }

    /**
     * Key {@code BuildAction.Branch}: {@code Branch {0} ({1}%).}.
     * 
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Branch {0} ({1}%).}
     */
    public static Localizable _BuildAction_Branch(Object arg0, Object arg1) {
        return new Localizable(holder, "BuildAction.Branch", arg0, arg1);
    }

    /**
     * Key {@code CoverageObject.Legend.BasisPath}: {@code Basis Path}.
     * 
     * @return
     *     {@code Basis Path}
     */
    public static String CoverageObject_Legend_BasisPath() {
        return holder.format("CoverageObject.Legend.BasisPath");
    }

    /**
     * Key {@code CoverageObject.Legend.BasisPath}: {@code Basis Path}.
     * 
     * @return
     *     {@code Basis Path}
     */
    public static Localizable _CoverageObject_Legend_BasisPath() {
        return new Localizable(holder, "CoverageObject.Legend.BasisPath");
    }

    /**
     * Key {@code BuildAction.Statement}: {@code Statement {0} ({1}%).}.
     * 
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Statement {0} ({1}%).}
     */
    public static String BuildAction_Statement(Object arg0, Object arg1) {
        return holder.format("BuildAction.Statement", arg0, arg1);
    }

    /**
     * Key {@code BuildAction.Statement}: {@code Statement {0} ({1}%).}.
     * 
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Statement {0} ({1}%).}
     */
    public static Localizable _BuildAction_Statement(Object arg0, Object arg1) {
        return new Localizable(holder, "BuildAction.Statement", arg0, arg1);
    }

    /**
     * Key {@code BuildAction.Function}: {@code Function {0} ({1}%).}.
     * 
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Function {0} ({1}%).}
     */
    public static String BuildAction_Function(Object arg0, Object arg1) {
        return holder.format("BuildAction.Function", arg0, arg1);
    }

    /**
     * Key {@code BuildAction.Function}: {@code Function {0} ({1}%).}.
     * 
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Function {0} ({1}%).}
     */
    public static Localizable _BuildAction_Function(Object arg0, Object arg1) {
        return new Localizable(holder, "BuildAction.Function", arg0, arg1);
    }

    /**
     * Key {@code BuildAction.Complexity}: {@code Complexity {0}.}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Complexity {0}.}
     */
    public static String BuildAction_Complexity(Object arg0) {
        return holder.format("BuildAction.Complexity", arg0);
    }

    /**
     * Key {@code BuildAction.Complexity}: {@code Complexity {0}.}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Complexity {0}.}
     */
    public static Localizable _BuildAction_Complexity(Object arg0) {
        return new Localizable(holder, "BuildAction.Complexity", arg0);
    }

    /**
     * Key {@code CoverageObject.Legend.Branch}: {@code Branch}.
     * 
     * @return
     *     {@code Branch}
     */
    public static String CoverageObject_Legend_Branch() {
        return holder.format("CoverageObject.Legend.Branch");
    }

    /**
     * Key {@code CoverageObject.Legend.Branch}: {@code Branch}.
     * 
     * @return
     *     {@code Branch}
     */
    public static Localizable _CoverageObject_Legend_Branch() {
        return new Localizable(holder, "CoverageObject.Legend.Branch");
    }

    /**
     * Key {@code ProjectAction.DisplayName}: {@code Coverage Trend}.
     * 
     * @return
     *     {@code Coverage Trend}
     */
    public static String ProjectAction_DisplayName() {
        return holder.format("ProjectAction.DisplayName");
    }

    /**
     * Key {@code ProjectAction.DisplayName}: {@code Coverage Trend}.
     * 
     * @return
     *     {@code Coverage Trend}
     */
    public static Localizable _ProjectAction_DisplayName() {
        return new Localizable(holder, "ProjectAction.DisplayName");
    }

    /**
     * Key {@code BuildAction.Description}: {@code Coverage: {0} {1} {2} {3}
     * {4} {5}}.
     * 
     * @param arg3
     *      4th format parameter, {@code {3}}, as {@link String#valueOf(Object)}.
     * @param arg2
     *      3rd format parameter, {@code {2}}, as {@link String#valueOf(Object)}.
     * @param arg5
     *      6th format parameter, {@code {5}}, as {@link String#valueOf(Object)}.
     * @param arg4
     *      5th format parameter, {@code {4}}, as {@link String#valueOf(Object)}.
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Coverage: {0} {1} {2} {3} {4} {5}}
     */
    public static String BuildAction_Description(Object arg0, Object arg1, Object arg2, Object arg3, Object arg4, Object arg5) {
        return holder.format("BuildAction.Description", arg0, arg1, arg2, arg3, arg4, arg5);
    }

    /**
     * Key {@code BuildAction.Description}: {@code Coverage: {0} {1} {2} {3}
     * {4} {5}}.
     * 
     * @param arg3
     *      4th format parameter, {@code {3}}, as {@link String#valueOf(Object)}.
     * @param arg2
     *      3rd format parameter, {@code {2}}, as {@link String#valueOf(Object)}.
     * @param arg5
     *      6th format parameter, {@code {5}}, as {@link String#valueOf(Object)}.
     * @param arg4
     *      5th format parameter, {@code {4}}, as {@link String#valueOf(Object)}.
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Coverage: {0} {1} {2} {3} {4} {5}}
     */
    public static Localizable _BuildAction_Description(Object arg0, Object arg1, Object arg2, Object arg3, Object arg4, Object arg5) {
        return new Localizable(holder, "BuildAction.Description", arg0, arg1, arg2, arg3, arg4, arg5);
    }

    /**
     * Key {@code VcastCoveragePublisher.DisplayName}: {@code Record
     * VectorCAST Coverage Information}.
     * 
     * @return
     *     {@code Record VectorCAST Coverage Information}
     */
    public static String VcastCoveragePublisher_DisplayName() {
        return holder.format("VcastCoveragePublisher.DisplayName");
    }

    /**
     * Key {@code VcastCoveragePublisher.DisplayName}: {@code Record
     * VectorCAST Coverage Information}.
     * 
     * @return
     *     {@code Record VectorCAST Coverage Information}
     */
    public static Localizable _VcastCoveragePublisher_DisplayName() {
        return new Localizable(holder, "VcastCoveragePublisher.DisplayName");
    }

}
