/*
 * Decompiled with CFR 0.152.
 */
package com.vectorcast.plugins.vectorcastcoverage.portlet;

import com.vectorcast.plugins.vectorcastcoverage.VectorCASTBuildAction;
import com.vectorcast.plugins.vectorcastcoverage.portlet.bean.VectorCASTCoverageResultSummary;
import com.vectorcast.plugins.vectorcastcoverage.portlet.utils.Utils;
import hudson.XmlFile;
import hudson.model.Job;
import hudson.model.Run;
import java.io.IOException;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class VectorCASTLoadData {
    private static final Logger logger = Logger.getLogger(VectorCASTLoadData.class.getName());

    private VectorCASTLoadData() {
    }

    protected static Integer getMaxHistoryFreestyleJob(String xml) {
        Integer maxHistory;
        try {
            maxHistory = Integer.parseInt(xml.split("<maxHistory>")[1].split("</maxHistory>")[0]);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            maxHistory = 20;
            logger.log(Level.INFO, "error finding <maxHistory>: ", e);
        }
        catch (NumberFormatException e) {
            maxHistory = 20;
            logger.log(Level.INFO, "error Converting to number:", e);
        }
        return maxHistory;
    }

    protected static Integer getMaxHistoryPipelineJob(String xml) {
        Integer maxHistory = 20;
        int subIndex = xml.indexOf("maxHistory");
        if (subIndex == -1) {
            return maxHistory;
        }
        subIndex = xml.indexOf("maxHistory");
        String substr = xml.substring(subIndex);
        int colonIdx = substr.indexOf(":") + 1;
        int commaIdx = substr.indexOf(",");
        int sqrBktIdx = substr.indexOf("]");
        int endingIdx = 0;
        if (sqrBktIdx != -1 && sqrBktIdx < commaIdx) {
            endingIdx = sqrBktIdx;
        } else if (commaIdx != -1) {
            endingIdx = commaIdx;
        } else {
            return maxHistory;
        }
        substr = substr.substring(colonIdx, endingIdx);
        substr = substr.replace("'", "");
        substr = substr.replace("\"", "");
        maxHistory = Integer.parseInt(substr.trim());
        return maxHistory;
    }

    protected static Integer getMaxHistory(Job<?, ?> job) {
        Integer maxHistory = 20;
        try {
            XmlFile configFile = job.getConfigFile();
            String xml = configFile.asString();
            if (xml.contains("<maxHistory>")) {
                maxHistory = VectorCASTLoadData.getMaxHistoryFreestyleJob(xml);
            } else if (xml.contains("maxHistory")) {
                maxHistory = VectorCASTLoadData.getMaxHistoryFreestyleJob(xml);
            }
        }
        catch (IOException e) {
            logger.log(Level.INFO, "error reading configFile: ", e);
        }
        return maxHistory;
    }

    public static Map<LocalDate, VectorCASTCoverageResultSummary> loadChartDataWithinRange(List<Job> jobs, int daysNumber) {
        logger.log(Level.INFO, "In VectorCASTLoadData::loadChartDataWithinRange");
        HashMap<LocalDate, VectorCASTCoverageResultSummary> summaries = new HashMap<LocalDate, VectorCASTCoverageResultSummary>();
        LocalDate lastDate = Utils.getLastDate(jobs);
        if (lastDate == null) {
            return null;
        }
        LocalDate firstDate = lastDate.minusDays(daysNumber);
        for (Job job : jobs) {
            Integer maxHistory = VectorCASTLoadData.getMaxHistory(job);
            Integer historyCount = 0;
            Run run = job.getLastBuild();
            if (null == run) continue;
            LocalDate runDate = Utils.calendarToLocalData(run.getTimestamp());
            while (runDate.isAfter(firstDate)) {
                VectorCASTLoadData.summarize(summaries, run, runDate, job);
                run = run.getPreviousBuild();
                if (null == run) break;
                runDate = Utils.calendarToLocalData(run.getTimestamp());
            }
            Integer n = historyCount;
            historyCount = historyCount + 1;
            if (n < maxHistory) continue;
            break;
        }
        TreeMap<LocalDate, VectorCASTCoverageResultSummary> sortedSummaries = new TreeMap<LocalDate, VectorCASTCoverageResultSummary>(summaries);
        return sortedSummaries;
    }

    private static void summarize(Map<LocalDate, VectorCASTCoverageResultSummary> summaries, Run run, LocalDate runDate, Job job) {
        VectorCASTCoverageResultSummary vectorCASTCoverageResult = VectorCASTLoadData.getResult(run);
        VectorCASTCoverageResultSummary vectorCASTCoverageResultSummary = summaries.get(runDate);
        if (vectorCASTCoverageResultSummary == null) {
            vectorCASTCoverageResultSummary = new VectorCASTCoverageResultSummary();
            vectorCASTCoverageResultSummary.addCoverageResult(vectorCASTCoverageResult);
            vectorCASTCoverageResultSummary.setJob(job);
        } else {
            List<VectorCASTCoverageResultSummary> listResults = vectorCASTCoverageResultSummary.getVectorCASTCoverageResults();
            boolean found = false;
            String jobName = job != null ? job.getName() : null;
            for (VectorCASTCoverageResultSummary item : listResults) {
                Job itemJob;
                String itemName;
                if (item == null || !Objects.equals(itemName = (itemJob = item.getJob()) != null ? itemJob.getName() : null, jobName)) continue;
                found = true;
                break;
            }
            if (!found) {
                vectorCASTCoverageResultSummary.addCoverageResult(vectorCASTCoverageResult);
                vectorCASTCoverageResultSummary.setJob(job);
            }
        }
        summaries.put(runDate, vectorCASTCoverageResultSummary);
    }

    private static VectorCASTCoverageResultSummary getResult(Run run) {
        VectorCASTBuildAction vectorCASTAction = (VectorCASTBuildAction)run.getAction(VectorCASTBuildAction.class);
        Float BasisPathCoverage = Float.valueOf(-1.0f);
        Float StatementCoverage = Float.valueOf(-1.0f);
        Float MCDCCoverage = Float.valueOf(-1.0f);
        Float BranchCoverage = Float.valueOf(-1.0f);
        Float FunctionCoverage = Float.valueOf(-1.0f);
        Float FunctionCallCoverage = Float.valueOf(-1.0f);
        Float Complexity = Float.valueOf(-1.0f);
        if (vectorCASTAction != null) {
            if (null != vectorCASTAction.getBasisPathCoverage()) {
                BasisPathCoverage = Float.valueOf(vectorCASTAction.getBasisPathCoverage().getPercentageFloat());
            }
            if (null != vectorCASTAction.getStatementCoverage()) {
                StatementCoverage = Float.valueOf(vectorCASTAction.getStatementCoverage().getPercentageFloat());
            }
            if (null != vectorCASTAction.getMCDCCoverage()) {
                MCDCCoverage = Float.valueOf(vectorCASTAction.getMCDCCoverage().getPercentageFloat());
            }
            if (null != vectorCASTAction.getBranchCoverage()) {
                BranchCoverage = Float.valueOf(vectorCASTAction.getBranchCoverage().getPercentageFloat());
            }
            if (null != vectorCASTAction.getFunctionCoverage()) {
                FunctionCoverage = Float.valueOf(vectorCASTAction.getFunctionCoverage().getPercentageFloat());
            }
            if (null != vectorCASTAction.getFunctionCallCoverage()) {
                FunctionCallCoverage = Float.valueOf(vectorCASTAction.getFunctionCallCoverage().getPercentageFloat());
            }
            if (null != vectorCASTAction.getComplexity()) {
                Complexity = Float.valueOf(vectorCASTAction.getComplexity().getNumerator());
            }
        }
        return new VectorCASTCoverageResultSummary(run.getParent(), BasisPathCoverage.floatValue(), MCDCCoverage.floatValue(), BranchCoverage.floatValue(), StatementCoverage.floatValue(), FunctionCoverage.floatValue(), FunctionCallCoverage.floatValue(), Complexity.floatValue());
    }

    public static VectorCASTCoverageResultSummary getResultSummary(Collection<Job> jobs) {
        VectorCASTCoverageResultSummary summary = new VectorCASTCoverageResultSummary();
        for (Job job : jobs) {
            Float BasisPathCoverage = Float.valueOf(-1.0f);
            Float StatementCoverage = Float.valueOf(-1.0f);
            Float MCDCCoverage = Float.valueOf(-1.0f);
            Float BranchCoverage = Float.valueOf(-1.0f);
            Float FunctionCoverage = Float.valueOf(-1.0f);
            Float FunctionCallCoverage = Float.valueOf(-1.0f);
            Float Complexity = Float.valueOf(-1.0f);
            Run run = job.getLastSuccessfulBuild();
            if (run != null) {
                VectorCASTBuildAction vectorCASTAction = (VectorCASTBuildAction)job.getLastSuccessfulBuild().getAction(VectorCASTBuildAction.class);
                if (null == vectorCASTAction) continue;
                if (null != vectorCASTAction.getBasisPathCoverage()) {
                    BasisPathCoverage = Float.valueOf(vectorCASTAction.getBasisPathCoverage().getPercentageFloat());
                    BigDecimal bigBasisPathCoverage = new BigDecimal(BasisPathCoverage.toString());
                    bigBasisPathCoverage = bigBasisPathCoverage.setScale(1, 6);
                    BasisPathCoverage = Float.valueOf(bigBasisPathCoverage.floatValue());
                }
                if (null != vectorCASTAction.getStatementCoverage()) {
                    StatementCoverage = Float.valueOf(vectorCASTAction.getStatementCoverage().getPercentageFloat());
                    BigDecimal bigStatementCoverage = new BigDecimal(StatementCoverage.toString());
                    bigStatementCoverage = bigStatementCoverage.setScale(1, 6);
                    StatementCoverage = Float.valueOf(bigStatementCoverage.floatValue());
                }
                if (null != vectorCASTAction.getMCDCCoverage()) {
                    MCDCCoverage = Float.valueOf(vectorCASTAction.getMCDCCoverage().getPercentageFloat());
                    BigDecimal bigMCDCCoverage = new BigDecimal(MCDCCoverage.toString());
                    bigMCDCCoverage = bigMCDCCoverage.setScale(1, 6);
                    MCDCCoverage = Float.valueOf(bigMCDCCoverage.floatValue());
                }
                if (null != vectorCASTAction.getBranchCoverage()) {
                    BranchCoverage = Float.valueOf(vectorCASTAction.getBranchCoverage().getPercentageFloat());
                    BigDecimal bigBranchCoverage = new BigDecimal(BranchCoverage.toString());
                    bigBranchCoverage = bigBranchCoverage.setScale(1, 6);
                    BranchCoverage = Float.valueOf(bigBranchCoverage.floatValue());
                }
                if (null != vectorCASTAction.getFunctionCoverage()) {
                    FunctionCoverage = Float.valueOf(vectorCASTAction.getFunctionCoverage().getPercentageFloat());
                    BigDecimal bigFunctionCoverage = new BigDecimal(FunctionCoverage.toString());
                    bigFunctionCoverage = bigFunctionCoverage.setScale(1, 6);
                    FunctionCoverage = Float.valueOf(bigFunctionCoverage.floatValue());
                }
                if (null != vectorCASTAction.getFunctionCallCoverage()) {
                    FunctionCallCoverage = Float.valueOf(vectorCASTAction.getFunctionCallCoverage().getPercentageFloat());
                    BigDecimal bigFunctionCallCoverage = new BigDecimal(FunctionCallCoverage.toString());
                    bigFunctionCallCoverage = bigFunctionCallCoverage.setScale(1, 6);
                    FunctionCallCoverage = Float.valueOf(bigFunctionCallCoverage.floatValue());
                }
                if (null != vectorCASTAction.getComplexity()) {
                    Complexity = Float.valueOf(vectorCASTAction.getComplexity().getNumerator());
                    BigDecimal bigComplexity = new BigDecimal(Complexity.toString());
                    bigComplexity = bigComplexity.setScale(1, 6);
                    Complexity = Float.valueOf(bigComplexity.floatValue());
                }
            }
            summary.addCoverageResult(new VectorCASTCoverageResultSummary(job, BasisPathCoverage.floatValue(), MCDCCoverage.floatValue(), BranchCoverage.floatValue(), StatementCoverage.floatValue(), FunctionCoverage.floatValue(), FunctionCallCoverage.floatValue(), Complexity.floatValue()));
        }
        return summary;
    }

    public static boolean hasStatementCoverage(Collection<Job> jobs) {
        for (Job job : jobs) {
            VectorCASTBuildAction vcastcoverageAction;
            Run run = job.getLastSuccessfulBuild();
            if (run == null || null == (vcastcoverageAction = (VectorCASTBuildAction)job.getLastSuccessfulBuild().getAction(VectorCASTBuildAction.class)) || null == vcastcoverageAction.getStatementCoverage()) continue;
            return true;
        }
        return false;
    }

    public static boolean hasBranchCoverage(Collection<Job> jobs) {
        for (Job job : jobs) {
            VectorCASTBuildAction vcastcoverageAction;
            Run run = job.getLastSuccessfulBuild();
            if (run == null || null == (vcastcoverageAction = (VectorCASTBuildAction)job.getLastSuccessfulBuild().getAction(VectorCASTBuildAction.class)) || null == vcastcoverageAction.getBranchCoverage()) continue;
            return true;
        }
        return false;
    }

    public static boolean hasComplexity(Collection<Job> jobs) {
        for (Job job : jobs) {
            VectorCASTBuildAction vcastcoverageAction;
            Run run = job.getLastSuccessfulBuild();
            if (run == null || null == (vcastcoverageAction = (VectorCASTBuildAction)job.getLastSuccessfulBuild().getAction(VectorCASTBuildAction.class)).getComplexity()) continue;
            return true;
        }
        return false;
    }

    public static boolean hasBasisPathCoverage(Collection<Job> jobs) {
        for (Job job : jobs) {
            VectorCASTBuildAction vcastcoverageAction;
            Run run = job.getLastSuccessfulBuild();
            if (run == null || null == (vcastcoverageAction = (VectorCASTBuildAction)job.getLastSuccessfulBuild().getAction(VectorCASTBuildAction.class)) || null == vcastcoverageAction.getBasisPathCoverage()) continue;
            return true;
        }
        return false;
    }

    public static boolean hasMCDCCoverage(Collection<Job> jobs) {
        for (Job job : jobs) {
            VectorCASTBuildAction vcastcoverageAction;
            Run run = job.getLastSuccessfulBuild();
            if (run == null || null == (vcastcoverageAction = (VectorCASTBuildAction)job.getLastSuccessfulBuild().getAction(VectorCASTBuildAction.class)) || null == vcastcoverageAction.getMCDCCoverage()) continue;
            return true;
        }
        return false;
    }

    public static boolean hasFunctionCoverage(Collection<Job> jobs) {
        for (Job job : jobs) {
            VectorCASTBuildAction vcastcoverageAction;
            Run run = job.getLastSuccessfulBuild();
            if (run == null || null == (vcastcoverageAction = (VectorCASTBuildAction)job.getLastSuccessfulBuild().getAction(VectorCASTBuildAction.class)) || null == vcastcoverageAction.getFunctionCoverage()) continue;
            return true;
        }
        return false;
    }

    public static boolean hasFunctionCallCoverage(Collection<Job> jobs) {
        for (Job job : jobs) {
            VectorCASTBuildAction vcastcoverageAction;
            Run run = job.getLastSuccessfulBuild();
            if (run == null || null == (vcastcoverageAction = (VectorCASTBuildAction)job.getLastSuccessfulBuild().getAction(VectorCASTBuildAction.class)) || null == vcastcoverageAction.getFunctionCallCoverage()) continue;
            return true;
        }
        return false;
    }
}

