/*
 * Decompiled with CFR 0.152.
 */
package com.vectorcast.plugins.vectorcastcoverage;

import java.io.Serializable;
import org.kohsuke.stapler.DataBoundConstructor;

public class VectorCASTHealthReportThresholds
implements Serializable {
    private int minStatement;
    private int maxStatement;
    private int minBranch;
    private int maxBranch;
    private int minBasisPath;
    private int maxBasisPath;
    private int minMCDC;
    private int maxMCDC;
    private int minFunction;
    private int maxFunction;
    private int minFunctionCall;
    private int maxFunctionCall;

    public VectorCASTHealthReportThresholds() {
    }

    @DataBoundConstructor
    public VectorCASTHealthReportThresholds(int minStatement, int maxStatement, int minBranch, int maxBranch, int minBasisPath, int maxBasisPath, int minMCDC, int maxMCDC, int minFunction, int maxFunction, int minFunctionCall, int maxFunctionCall) {
        this.minStatement = minStatement;
        this.maxStatement = maxStatement;
        this.minBranch = minBranch;
        this.maxBranch = maxBranch;
        this.minBasisPath = minBasisPath;
        this.maxBasisPath = maxBasisPath;
        this.minMCDC = minMCDC;
        this.maxMCDC = maxMCDC;
        this.minFunction = minFunction;
        this.maxFunction = maxFunction;
        this.minFunctionCall = minFunctionCall;
        this.maxFunctionCall = maxFunctionCall;
        this.ensureValid();
    }

    private int applyRange(int min, int value, int max) {
        if (value < min) {
            return min;
        }
        if (value > max) {
            return max;
        }
        return value;
    }

    public void ensureValid() {
        this.maxStatement = this.applyRange(0, this.maxStatement, 100);
        this.minStatement = this.applyRange(0, this.minStatement, this.maxStatement);
        this.maxBranch = this.applyRange(0, this.maxBranch, 100);
        this.minBranch = this.applyRange(0, this.minBranch, this.maxBranch);
        this.maxBasisPath = this.applyRange(0, this.maxBasisPath, 100);
        this.minBasisPath = this.applyRange(0, this.minBasisPath, this.maxBasisPath);
        this.maxMCDC = this.applyRange(0, this.maxMCDC, 100);
        this.minMCDC = this.applyRange(0, this.minMCDC, this.maxMCDC);
        this.maxFunction = this.applyRange(0, this.maxFunction, 100);
        this.minFunction = this.applyRange(0, this.minFunction, this.maxFunction);
        this.maxFunctionCall = this.applyRange(0, this.maxFunctionCall, 100);
        this.minFunctionCall = this.applyRange(0, this.minFunctionCall, this.maxFunctionCall);
    }

    public int getMinStatement() {
        return this.minStatement;
    }

    public void setMinStatement(int minStatement) {
        this.minStatement = minStatement;
    }

    public int getMaxStatement() {
        return this.maxStatement;
    }

    public void setMaxStatement(int maxStatement) {
        this.maxStatement = maxStatement;
    }

    public int getMinBranch() {
        return this.minBranch;
    }

    public void setMinBranch(int minBranch) {
        this.minBranch = minBranch;
    }

    public int getMaxBranch() {
        return this.maxBranch;
    }

    public void setMaxBranch(int maxBranch) {
        this.maxBranch = maxBranch;
    }

    public int getMinBasisPath() {
        return this.minBasisPath;
    }

    public void setMinBasisPath(int minBasisPath) {
        this.minBasisPath = minBasisPath;
    }

    public int getMaxBasisPath() {
        return this.maxBasisPath;
    }

    public void setMaxBasisPath(int maxBasisPath) {
        this.maxBasisPath = maxBasisPath;
    }

    public int getMinMCDC() {
        return this.minMCDC;
    }

    public void setMinMCDC(int minMCDC) {
        this.minMCDC = minMCDC;
    }

    public int getMaxMCDC() {
        return this.maxMCDC;
    }

    public void setMaxMCDC(int maxMCDC) {
        this.maxMCDC = maxMCDC;
    }

    public void setMinFunction(int minFunction) {
        this.minFunction = minFunction;
    }

    public int getMinFunction() {
        return this.minFunction;
    }

    public void setMaxFunction(int maxFunction) {
        this.maxFunction = maxFunction;
    }

    public int getMaxFunction() {
        return this.maxFunction;
    }

    public void setMinFunctionCall(int minFunctionCall) {
        this.minFunctionCall = minFunctionCall;
    }

    public int getMinFunctionCall() {
        return this.minFunctionCall;
    }

    public void setMaxFunctionCall(int maxFunctionCall) {
        this.maxFunctionCall = maxFunctionCall;
    }

    public int getMaxFunctionCall() {
        return this.maxFunctionCall;
    }
}

