/*
 * Decompiled with CFR 0.152.
 */
package com.vectorcast.plugins.vectorcastcoverage;

import com.vectorcast.plugins.vectorcastcoverage.Messages;
import com.vectorcast.plugins.vectorcastcoverage.Ratio;
import hudson.Util;
import hudson.XmlFile;
import hudson.model.Api;
import hudson.model.Job;
import hudson.model.Run;
import hudson.util.ChartUtil;
import hudson.util.ColorPalette;
import hudson.util.DataSetBuilder;
import hudson.util.Graph;
import hudson.util.ShiftedCategoryAxis;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Paint;
import java.awt.Stroke;
import java.io.IOException;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.Calendar;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.CategoryAxis;
import org.jfree.chart.axis.CategoryLabelPositions;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.renderer.category.BarRenderer;
import org.jfree.chart.renderer.category.CategoryItemRenderer;
import org.jfree.chart.renderer.category.LineAndShapeRenderer;
import org.jfree.chart.title.LegendTitle;
import org.jfree.data.category.CategoryDataset;
import org.jfree.ui.RectangleEdge;
import org.jfree.ui.RectangleInsets;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;
import org.kohsuke.stapler.export.Exported;
import org.kohsuke.stapler.export.ExportedBean;

@ExportedBean
public abstract class CoverageObject<SELF extends CoverageObject<SELF>> {
    private static final Logger logger = Logger.getLogger(CoverageObject.class.getName());
    Ratio Statement = new Ratio(new float[0]);
    Ratio Branch = new Ratio(new float[0]);
    Ratio BasisPath = new Ratio(new float[0]);
    Ratio MCDC = new Ratio(new float[0]);
    Ratio Function = new Ratio(new float[0]);
    Ratio FunctionCall = new Ratio(new float[0]);
    Ratio Complexity = new Ratio(new float[0]);
    private volatile boolean failed = false;
    static NumberFormat dataFormat = new DecimalFormat("000.00");
    static NumberFormat percentFormat = new DecimalFormat("0.0");
    static NumberFormat intFormat = new DecimalFormat("0");

    public boolean hasCoverage() {
        return this.hasFunctionCoverage() || this.hasFunctionCallCoverage() || this.hasStatementCoverage() || this.hasBranchCoverage() || this.hasBasisPathCoverage() || this.hasMCDCCoverage();
    }

    public boolean isFailed() {
        return this.failed;
    }

    public void setFailed() {
        this.failed = true;
    }

    @Exported(inline=true)
    public Ratio getStatementCoverage() {
        return this.Statement;
    }

    @Exported(inline=true)
    public Ratio getBranchCoverage() {
        return this.Branch;
    }

    @Exported(inline=true)
    public Ratio getComplexity() {
        return this.Complexity;
    }

    @Exported(inline=true)
    public Ratio getBasisPathCoverage() {
        return this.BasisPath;
    }

    @Exported(inline=true)
    public Ratio getMCDCCoverage() {
        return this.MCDC;
    }

    @Exported(inline=true)
    public Ratio getFunctionCoverage() {
        return this.Function;
    }

    @Exported(inline=true)
    public Ratio getFunctionCallCoverage() {
        return this.FunctionCall;
    }

    public abstract Run<?, ?> getBuild();

    @Exported
    public abstract SELF getPreviousResult();

    public String printFourCoverageColumns() {
        StringBuilder buf = new StringBuilder();
        CoverageObject.printRatioCell(this.isFailed(), this.Complexity, buf);
        CoverageObject.printRatioCell(this.isFailed(), this.Statement, buf);
        CoverageObject.printRatioCell(this.isFailed(), this.Branch, buf);
        CoverageObject.printRatioCell(this.isFailed(), this.MCDC, buf);
        CoverageObject.printRatioCell(this.isFailed(), this.Function, buf);
        CoverageObject.printRatioCell(this.isFailed(), this.FunctionCall, buf);
        return buf.toString();
    }

    public boolean hasFunctionCoverage() {
        return this.Function.isInitialized();
    }

    public boolean hasFunctionCallCoverage() {
        return this.FunctionCall.isInitialized();
    }

    public boolean hasMCDCCoverage() {
        return this.MCDC.isInitialized();
    }

    public boolean hasStatementCoverage() {
        return this.Statement.isInitialized();
    }

    public boolean hasBranchCoverage() {
        return this.Branch.isInitialized();
    }

    public boolean hasComplexity() {
        return this.Complexity.isInitialized();
    }

    public boolean hasBasisPathCoverage() {
        return this.BasisPath.isInitialized();
    }

    protected Integer getMaxHistoryFreestyleJob(String xml) {
        Integer maxHistory;
        try {
            maxHistory = Integer.parseInt(xml.split("<maxHistory>")[1].split("</maxHistory>")[0]);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            maxHistory = 20;
            logger.log(Level.INFO, "error finding <maxHistory>###</maxhistory>: ", e);
        }
        catch (NumberFormatException e) {
            maxHistory = 20;
            logger.log(Level.INFO, "error Converting to number:", e);
        }
        return maxHistory;
    }

    protected Integer getMaxHistoryPipelineJob(String xml) {
        Integer maxHistory = 20;
        int subIndex = xml.indexOf("maxHistory");
        if (subIndex == -1) {
            return maxHistory;
        }
        subIndex = xml.indexOf("maxHistory");
        String substr = xml.substring(subIndex);
        int colonIdx = substr.indexOf(":") + 1;
        int commaIdx = substr.indexOf(",");
        int sqrBktIdx = substr.indexOf("]");
        int endingIdx = 0;
        if (sqrBktIdx != -1 && sqrBktIdx < commaIdx) {
            endingIdx = sqrBktIdx;
        } else if (commaIdx != -1) {
            endingIdx = commaIdx;
        } else {
            return maxHistory;
        }
        substr = substr.substring(colonIdx, endingIdx);
        substr = substr.replace("'", "");
        substr = substr.replace("\"", "\"");
        maxHistory = Integer.parseInt(substr.trim());
        return maxHistory;
    }

    protected Integer getMaxHistory() {
        Run<?, ?> build = this.getBuild();
        Job job = build.getParent();
        Integer maxHistory = 20;
        try {
            XmlFile configFile = job.getConfigFile();
            String xml = configFile.asString();
            if (xml.contains("<maxHistory>")) {
                maxHistory = this.getMaxHistoryFreestyleJob(xml);
            } else if (xml.contains("maxHistory")) {
                maxHistory = this.getMaxHistoryPipelineJob(xml);
            }
        }
        catch (IOException e) {
            logger.log(Level.INFO, "error reading configFile: ", e);
        }
        return maxHistory;
    }

    protected static void printRatioCell(boolean failed, Ratio ratio, StringBuilder buf) {
        if (ratio != null && ratio.isInitialized()) {
            String className = "nowrap" + (failed ? " red" : "");
            buf.append("<td align=\"center\" class='").append(className).append("'");
            buf.append(" data='").append(dataFormat.format(ratio.getPercentageFloat()));
            buf.append("'>\n");
            if ((double)ratio.getNumerator() != 0.0 && (double)ratio.getDenominator() == 0.0) {
                buf.append("<span class='text'>").append(ratio.getNumerator()).append("</span>");
            } else if ((double)ratio.getNumerator() == 0.0 && (double)ratio.getDenominator() == 0.0) {
                buf.append("<span class='text'>-</span>");
            } else {
                CoverageObject.printRatioTable(ratio, buf);
            }
            buf.append("</td>\n");
        } else {
            buf.append("<td align=\"center\" >-</td>\n");
        }
    }

    protected static void printRatioTable(Ratio ratio, StringBuilder buf) {
        String percent = percentFormat.format(ratio.getPercentageFloat());
        String numerator = intFormat.format(ratio.getNumerator());
        String denominator = intFormat.format(ratio.getDenominator());
        buf.append("<table class='percentgraph' cellpadding='0px' cellspacing='0px'><tr class='percentgraph'>").append("<td width='64px' class='data'>").append(percent).append("%</td>").append("<td class='percentgraph'>").append("<div class='percentgraph'><div class='greenbar' style='width: ").append(ratio.getPercentageFloat()).append("px;'>").append("<span class='text'>").append(numerator).append("/").append(denominator).append("</span></div></div></td></tr></table>");
    }

    public void doGraph(StaplerRequest req, StaplerResponse rsp) throws IOException {
        if (ChartUtil.awtProblemCause != null) {
            rsp.sendRedirect2(req.getContextPath() + "/images/headless.png");
            return;
        }
        Run<?, ?> build = this.getBuild();
        Calendar t = build.getTimestamp();
        final Integer maxHistory = this.getMaxHistory();
        String w = Util.fixEmptyAndTrim((String)req.getParameter("width"));
        String h = Util.fixEmptyAndTrim((String)req.getParameter("height"));
        int width = w != null ? Integer.parseInt(w) : 500;
        int height = h != null ? Integer.parseInt(h) : 200;
        new GraphImpl(this, t, width, height){

            @Override
            protected DataSetBuilder<String, ChartUtil.NumberOnlyBuildLabel> createDataSet(CoverageObject<SELF> obj) {
                logger.log(Level.INFO, "In CoverageObject::doGraph::GraphImpl::createDataSet");
                DataSetBuilder dsb = new DataSetBuilder();
                Integer historyCount = 0;
                for (CoverageObject a = obj; a != null; a = a.getPreviousResult()) {
                    Integer n = historyCount;
                    historyCount = historyCount + 1;
                    if (n >= maxHistory) break;
                    ChartUtil.NumberOnlyBuildLabel label = new ChartUtil.NumberOnlyBuildLabel(a.getBuild());
                    if (a.Statement != null && a.Statement.isInitialized()) {
                        dsb.add((Number)Float.valueOf(a.Statement.getPercentageFloat()), (Comparable)((Object)Messages.CoverageObject_Legend_Statement()), (Comparable)label);
                    }
                    if (a.Branch != null && a.Branch.isInitialized()) {
                        dsb.add((Number)Float.valueOf(a.Branch.getPercentageFloat()), (Comparable)((Object)Messages.CoverageObject_Legend_Branch()), (Comparable)label);
                    }
                    if (a.BasisPath != null && a.BasisPath.isInitialized()) {
                        dsb.add((Number)Float.valueOf(a.BasisPath.getPercentageFloat()), (Comparable)((Object)Messages.CoverageObject_Legend_BasisPath()), (Comparable)label);
                    }
                    if (a.MCDC != null && a.MCDC.isInitialized()) {
                        dsb.add((Number)Float.valueOf(a.MCDC.getPercentageFloat()), (Comparable)((Object)Messages.CoverageObject_Legend_MCDC()), (Comparable)label);
                    }
                    if (a.Function != null && a.Function.isInitialized()) {
                        dsb.add((Number)Float.valueOf(a.Function.getPercentageFloat()), (Comparable)((Object)Messages.CoverageObject_Legend_Function()), (Comparable)label);
                    }
                    if (a.FunctionCall == null || !a.FunctionCall.isInitialized()) continue;
                    dsb.add((Number)Float.valueOf(a.FunctionCall.getPercentageFloat()), (Comparable)((Object)Messages.CoverageObject_Legend_FunctionCall()), (Comparable)label);
                }
                logger.log(Level.INFO, "History Count = " + Integer.toString(historyCount));
                return dsb;
            }
        }.doPng(req, rsp);
    }

    public Api getApi() {
        return new Api((Object)this);
    }

    private abstract class GraphImpl
    extends Graph {
        private CoverageObject<SELF> obj;

        public GraphImpl(CoverageObject<SELF> obj, Calendar timestamp, int defaultW, int defaultH) {
            super(timestamp, defaultW, defaultH);
            this.obj = obj;
        }

        protected abstract DataSetBuilder<String, ChartUtil.NumberOnlyBuildLabel> createDataSet(CoverageObject<SELF> var1);

        protected JFreeChart createGraph() {
            CategoryDataset dataset = this.createDataSet(this.obj).build();
            logger.log(Level.INFO, "dataset (C | R) = " + Integer.toString(dataset.getColumnCount()) + " | " + Integer.toString(dataset.getRowCount()));
            JFreeChart chart = ChartFactory.createLineChart(null, null, (String)"Coverage (%)", (CategoryDataset)dataset, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)true, (boolean)true, (boolean)false);
            LegendTitle legend = chart.getLegend();
            legend.setPosition(RectangleEdge.RIGHT);
            chart.setBackgroundPaint((Paint)Color.white);
            CategoryPlot plot = chart.getCategoryPlot();
            plot.setBackgroundPaint((Paint)Color.WHITE);
            plot.setOutlinePaint(null);
            plot.setRangeGridlinesVisible(true);
            plot.setRangeGridlinePaint((Paint)Color.black);
            ShiftedCategoryAxis domainAxis = new ShiftedCategoryAxis(null);
            plot.setDomainAxis((CategoryAxis)domainAxis);
            domainAxis.setCategoryLabelPositions(CategoryLabelPositions.UP_90);
            domainAxis.setLowerMargin(0.0);
            domainAxis.setUpperMargin(0.0);
            domainAxis.setCategoryMargin(0.0);
            NumberAxis rangeAxis = (NumberAxis)plot.getRangeAxis();
            rangeAxis.setStandardTickUnits(NumberAxis.createIntegerTickUnits());
            rangeAxis.setUpperBound(100.0);
            rangeAxis.setLowerBound(0.0);
            LineAndShapeRenderer renderer = (LineAndShapeRenderer)plot.getRenderer();
            renderer.setBaseStroke((Stroke)new BasicStroke(4.0f));
            renderer.setBaseShapesVisible(true);
            ColorPalette.apply((LineAndShapeRenderer)renderer);
            plot.setInsets(new RectangleInsets(5.0, 0.0, 0.0, 5.0));
            plot.setDataset(1, this.createComplexityDataSet(this.obj).build());
            plot.mapDatasetToRangeAxis(1, 1);
            NumberAxis axis2 = new NumberAxis("Complexity");
            axis2.setAutoRange(true);
            plot.setRangeAxis(1, (ValueAxis)axis2);
            BarRenderer renderer2 = new BarRenderer();
            Color color = new Color(192, 192, 192, 128);
            renderer2.setSeriesPaint(0, (Paint)color);
            plot.setRenderer(1, (CategoryItemRenderer)renderer2);
            return chart;
        }

        protected DataSetBuilder<String, ChartUtil.NumberOnlyBuildLabel> createComplexityDataSet(CoverageObject<SELF> obj) {
            DataSetBuilder dsb = new DataSetBuilder();
            Integer maxHistory = CoverageObject.this.getMaxHistory();
            Integer historyCount = 0;
            for (CoverageObject a = obj; a != null; a = a.getPreviousResult()) {
                ChartUtil.NumberOnlyBuildLabel label = new ChartUtil.NumberOnlyBuildLabel(a.getBuild());
                Integer n = historyCount;
                historyCount = historyCount + 1;
                if (n >= maxHistory) break;
                dsb.add((Number)Float.valueOf(a.Complexity.getNumerator()), (Comparable)((Object)"Complexity"), (Comparable)label);
            }
            return dsb;
        }
    }
}

