/*
 * Decompiled with CFR 0.152.
 */
package com.vectorcast.plugins.vectorcastcoverage.portlet.bean;

import com.vectorcast.plugins.vectorcastcoverage.portlet.utils.Utils;
import hudson.model.Job;
import java.util.ArrayList;
import java.util.List;

public class VectorCASTCoverageResultSummary {
    private Job job;
    private float BasisPathCoverage;
    private boolean hasBasisPathCoverage;
    private float MCDCCoverage;
    private boolean hasMCDCCoverage;
    private float BranchCoverage;
    private boolean hasBranchCoverage;
    private float StatementCoverage;
    private boolean hasStatementCoverage;
    private float FunctionCoverage;
    private boolean hasFunctionCoverage;
    private float FunctionCallCoverage;
    private boolean hasFunctionCallCoverage;
    private float Complexity;
    private boolean hasComplexity;
    private List<VectorCASTCoverageResultSummary> coverageResults = new ArrayList<VectorCASTCoverageResultSummary>();

    public VectorCASTCoverageResultSummary() {
        this.hasStatementCoverage = false;
        this.hasBranchCoverage = false;
        this.hasBasisPathCoverage = false;
        this.hasMCDCCoverage = false;
        this.hasFunctionCoverage = false;
        this.hasFunctionCallCoverage = false;
        this.hasComplexity = false;
    }

    public VectorCASTCoverageResultSummary(Job job, float lBasisPathCoverage, float lMCDCCoverage, float lBranchCoverage, float lStatementCoverage, float lFunctionCoverage, float lFunctionCallCoverage, float lComplexity) {
        this.job = job;
        if (lStatementCoverage < 0.0f) {
            this.StatementCoverage = 0.0f;
            this.hasStatementCoverage = false;
        } else {
            this.StatementCoverage = lStatementCoverage;
            this.hasStatementCoverage = true;
        }
        if (lBranchCoverage < 0.0f) {
            this.BranchCoverage = 0.0f;
            this.hasBranchCoverage = false;
        } else {
            this.BranchCoverage = lBranchCoverage;
            this.hasBranchCoverage = true;
        }
        if (lBasisPathCoverage < 0.0f) {
            this.BasisPathCoverage = 0.0f;
            this.hasBasisPathCoverage = false;
        } else {
            this.BasisPathCoverage = lBasisPathCoverage;
            this.hasBasisPathCoverage = true;
        }
        if (lMCDCCoverage < 0.0f) {
            this.MCDCCoverage = 0.0f;
            this.hasMCDCCoverage = false;
        } else {
            this.MCDCCoverage = lMCDCCoverage;
            this.hasMCDCCoverage = true;
        }
        if (lFunctionCoverage < 0.0f) {
            this.FunctionCoverage = 0.0f;
            this.hasFunctionCoverage = false;
        } else {
            this.FunctionCoverage = lFunctionCoverage;
            this.hasFunctionCoverage = true;
        }
        if (lFunctionCallCoverage < 0.0f) {
            this.FunctionCallCoverage = 0.0f;
            this.hasFunctionCallCoverage = false;
        } else {
            this.FunctionCallCoverage = lFunctionCallCoverage;
            this.hasFunctionCallCoverage = true;
        }
        if (lComplexity < 0.0f) {
            this.Complexity = 0.0f;
            this.hasComplexity = false;
        } else {
            this.Complexity = lComplexity;
            this.hasComplexity = true;
        }
    }

    public VectorCASTCoverageResultSummary addCoverageResult(VectorCASTCoverageResultSummary coverageResult) {
        this.setBasisPathCoverage(this.getBasisPathCoverage() + coverageResult.getBasisPathCoverage());
        this.setMCDCCoverage(this.getMCDCCoverage() + coverageResult.getMCDCCoverage());
        this.setBranchCoverage(this.getBranchCoverage() + coverageResult.getBranchCoverage());
        this.setStatementCoverage(this.getStatementCoverage() + coverageResult.getStatementCoverage());
        this.setFunctionCoverage(this.getFunctionCoverage() + coverageResult.getFunctionCoverage());
        this.setFunctionCallCoverage(this.getFunctionCallCoverage() + coverageResult.getFunctionCallCoverage());
        this.setComplexity(this.getComplexity() + coverageResult.getComplexity());
        this.hasStatementCoverage = this.hasStatementCoverage || coverageResult.hasStatementCoverage;
        this.hasBranchCoverage = this.hasBranchCoverage || coverageResult.hasBranchCoverage;
        this.hasBasisPathCoverage = this.hasBasisPathCoverage || coverageResult.hasBasisPathCoverage;
        this.hasMCDCCoverage = this.hasMCDCCoverage || coverageResult.hasMCDCCoverage;
        this.hasFunctionCoverage = this.hasFunctionCoverage || coverageResult.hasFunctionCoverage;
        this.hasFunctionCallCoverage = this.hasFunctionCallCoverage || coverageResult.hasFunctionCallCoverage;
        this.hasComplexity = this.hasComplexity || coverageResult.hasComplexity;
        this.getCoverageResults().add(coverageResult);
        return this;
    }

    public List<VectorCASTCoverageResultSummary> getVectorCASTCoverageResults() {
        return this.getCoverageResults();
    }

    public float getTotalStatementCoverage() {
        if (this.getCoverageResults().size() <= 0) {
            return 0.0f;
        }
        float totalStatement = this.getStatementCoverage() / (float)this.getCoverageResults().size();
        totalStatement = Utils.roundFLoat(1, 6, Float.valueOf(totalStatement)).floatValue();
        return totalStatement;
    }

    public float getTotalComplexity() {
        if (this.getCoverageResults().size() <= 0) {
            return 0.0f;
        }
        float totalComplexity = this.getComplexity();
        totalComplexity = Utils.roundFLoat(1, 6, Float.valueOf(totalComplexity)).floatValue();
        return totalComplexity;
    }

    public float getTotalBranchCoverage() {
        if (this.getCoverageResults().size() <= 0) {
            return 0.0f;
        }
        float totalBranch = this.getBranchCoverage() / (float)this.getCoverageResults().size();
        totalBranch = Utils.roundFLoat(1, 6, Float.valueOf(totalBranch)).floatValue();
        return totalBranch;
    }

    public float getTotalBasisPathCoverage() {
        if (this.getCoverageResults().size() <= 0) {
            return 0.0f;
        }
        float totalBasisPath = this.getBasisPathCoverage() / (float)this.getCoverageResults().size();
        totalBasisPath = Utils.roundFLoat(1, 6, Float.valueOf(totalBasisPath)).floatValue();
        return totalBasisPath;
    }

    public float getTotalMCDCCoverage() {
        if (this.getCoverageResults().size() <= 0) {
            return 0.0f;
        }
        float totalMCDC = this.getMCDCCoverage() / (float)this.getCoverageResults().size();
        totalMCDC = Utils.roundFLoat(1, 6, Float.valueOf(totalMCDC)).floatValue();
        return totalMCDC;
    }

    public float getTotalFunctionCoverage() {
        if (this.getCoverageResults().size() <= 0) {
            return 0.0f;
        }
        float totalFunction = this.getFunctionCoverage() / (float)this.getCoverageResults().size();
        totalFunction = Utils.roundFLoat(1, 6, Float.valueOf(totalFunction)).floatValue();
        return totalFunction;
    }

    public float getTotalFunctionCallCoverage() {
        if (this.getCoverageResults().size() <= 0) {
            return 0.0f;
        }
        float totalFunctionCall = this.getFunctionCallCoverage() / (float)this.getCoverageResults().size();
        totalFunctionCall = Utils.roundFLoat(1, 6, Float.valueOf(totalFunctionCall)).floatValue();
        return totalFunctionCall;
    }

    public Job getJob() {
        return this.job;
    }

    public float getBasisPathCoverage() {
        return this.BasisPathCoverage;
    }

    public float getComplexity() {
        return this.Complexity;
    }

    public float getMCDCCoverage() {
        return this.MCDCCoverage;
    }

    public float getFunctionCoverage() {
        return this.FunctionCoverage;
    }

    public float getFunctionCallCoverage() {
        return this.FunctionCallCoverage;
    }

    public float getBranchCoverage() {
        return this.BranchCoverage;
    }

    public float getStatementCoverage() {
        return this.StatementCoverage;
    }

    public boolean hasStatementCoverage() {
        return this.hasStatementCoverage;
    }

    public boolean hasComplexity() {
        return this.hasComplexity;
    }

    public boolean hasBranchCoverage() {
        return this.hasBranchCoverage;
    }

    public boolean hasBasisPathCoverage() {
        return this.hasBasisPathCoverage;
    }

    public boolean hasMCDCCoverage() {
        return this.hasMCDCCoverage;
    }

    public boolean hasFunctionCoverage() {
        return this.hasFunctionCoverage;
    }

    public boolean hasFunctionCallCoverage() {
        return this.hasFunctionCallCoverage;
    }

    public void setJob(Job job) {
        this.job = job;
    }

    public void setBasisPathCoverage(float BasisPathCoverage) {
        this.BasisPathCoverage = BasisPathCoverage;
    }

    public void setComplexity(float Complexity) {
        this.Complexity = Complexity;
    }

    public void setMCDCCoverage(float MCDCCoverage) {
        this.MCDCCoverage = MCDCCoverage;
    }

    public void setBranchCoverage(float BranchCoverage) {
        this.BranchCoverage = BranchCoverage;
    }

    public void setFunctionCoverage(float FunctionCoverage) {
        this.FunctionCoverage = FunctionCoverage;
    }

    public void setFunctionCallCoverage(float FunctionCallCoverage) {
        this.FunctionCallCoverage = FunctionCallCoverage;
    }

    public void setStatementCoverage(float StatementCoverage) {
        this.StatementCoverage = StatementCoverage;
    }

    public List<VectorCASTCoverageResultSummary> getCoverageResults() {
        return this.coverageResults;
    }

    public void setCoverageResults(List<VectorCASTCoverageResultSummary> coverageResults) {
        this.coverageResults = coverageResults;
    }
}

