/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.validating_string_parameter;

import hudson.AbortException;
import hudson.Extension;
import hudson.cli.CLICommand;
import hudson.model.Failure;
import hudson.model.ParameterDefinition;
import hudson.model.ParameterValue;
import hudson.plugins.validating_string_parameter.ValidatingStringParameterValue;
import hudson.util.FormValidation;
import java.io.IOException;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import jenkins.model.Jenkins;
import net.sf.json.JSONObject;
import org.jenkinsci.Symbol;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest2;
import org.kohsuke.stapler.verb.POST;

public class ValidatingStringParameterDefinition
extends ParameterDefinition {
    private static final long serialVersionUID = 1L;
    private final String defaultValue;
    private final String regex;
    private final String failedValidationMessage;

    @DataBoundConstructor
    public ValidatingStringParameterDefinition(String name, String defaultValue, String regex, String failedValidationMessage, String description) {
        super(name, description);
        this.defaultValue = defaultValue;
        this.regex = regex;
        this.failedValidationMessage = failedValidationMessage;
    }

    public ValidatingStringParameterDefinition(String name, String defaultValue, String regex, String failedValidationMessage) {
        this(name, defaultValue, regex, failedValidationMessage, null);
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public String getRegex() {
        return this.regex;
    }

    public String getFailedValidationMessage() {
        return this.failedValidationMessage;
    }

    public String getRootUrl() {
        return Jenkins.get().getRootUrl();
    }

    public ValidatingStringParameterValue getDefaultParameterValue() {
        ValidatingStringParameterValue v = new ValidatingStringParameterValue(this.getName(), this.defaultValue, this.getRegex(), this.getDescription());
        return v;
    }

    public ParameterValue createValue(StaplerRequest2 req, JSONObject jo) {
        ValidatingStringParameterValue value = (ValidatingStringParameterValue)((Object)req.bindJSON(ValidatingStringParameterValue.class, jo));
        String req_value = value.getValue();
        if (!Pattern.matches(this.regex, req_value)) {
            throw new Failure("Invalid value for parameter [" + this.getName() + "] specified: " + req_value);
        }
        value.setDescription(this.getDescription());
        value.setRegex(this.regex);
        return value;
    }

    public ParameterValue createValue(StaplerRequest2 req) {
        String[] value = req.getParameterValues(this.getName());
        if (value == null || value.length < 1) {
            return this.getDefaultParameterValue();
        }
        if (!Pattern.matches(this.regex, value[0])) {
            throw new Failure("Invalid value for parameter [" + this.getName() + "] specified: " + value[0]);
        }
        return new ValidatingStringParameterValue(this.getName(), value[0], this.regex, this.getDescription());
    }

    public ParameterValue createValue(CLICommand command, String value) throws IOException, InterruptedException {
        if (value == null || value.length() == 0) {
            return this.getDefaultParameterValue();
        }
        if (!Pattern.matches(this.regex, value)) {
            throw new AbortException("Invalid value for parameter [" + this.getName() + "] specified: " + value);
        }
        return new ValidatingStringParameterValue(this.getName(), value, this.regex, this.getDescription());
    }

    @Extension
    @Symbol(value={"validatingString"})
    public static class DescriptorImpl
    extends ParameterDefinition.ParameterDescriptor {
        public String getDisplayName() {
            return "Validating String Parameter";
        }

        @POST
        public FormValidation doCheckRegex(@QueryParameter String value) {
            try {
                Pattern.compile(value);
                return FormValidation.ok();
            }
            catch (PatternSyntaxException pse) {
                return FormValidation.error((String)("Invalid regular expression: " + pse.getDescription()));
            }
        }

        @POST
        public FormValidation doValidate(@QueryParameter String regex, @QueryParameter String failedValidationMessage, @QueryParameter String value) {
            try {
                if (Pattern.matches(regex, value)) {
                    return FormValidation.ok();
                }
                return failedValidationMessage == null || "".equals(failedValidationMessage) ? FormValidation.error((String)("Value entered does not match regular expression: " + regex)) : FormValidation.error((String)failedValidationMessage);
            }
            catch (PatternSyntaxException pse) {
                return FormValidation.error((String)("Invalid regular expression [" + regex + "]: " + pse.getDescription()));
            }
        }
    }
}

