/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.validating_string_parameter;

import com.google.common.base.Objects;
import hudson.AbortException;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.BuildListener;
import hudson.model.StringParameterValue;
import hudson.tasks.BuildWrapper;
import java.io.IOException;
import java.util.regex.Pattern;
import org.kohsuke.stapler.DataBoundConstructor;

public class ValidatingStringParameterValue
extends StringParameterValue {
    private String regex;

    @DataBoundConstructor
    public ValidatingStringParameterValue(String name, String value) {
        this(name, value, null, null);
    }

    public ValidatingStringParameterValue(String name, String value, String regex, String description) {
        super(name, value, description);
        this.regex = regex;
    }

    public String getRegex() {
        return this.regex;
    }

    public void setRegex(String regex) {
        this.regex = regex;
    }

    public BuildWrapper createBuildWrapper(AbstractBuild<?, ?> build) {
        if (this.regex != null && !Pattern.matches(this.regex, this.value)) {
            return new BuildWrapper(){

                public BuildWrapper.Environment setUp(AbstractBuild build, Launcher launcher, BuildListener listener) throws IOException, InterruptedException {
                    throw new AbortException("Invalid value for parameter [" + ValidatingStringParameterValue.this.getName() + "] specified: " + ValidatingStringParameterValue.this.value);
                }
            };
        }
        return null;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{super.hashCode(), this.regex});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        ValidatingStringParameterValue other = (ValidatingStringParameterValue)((Object)obj);
        if (this.regex == null) {
            return other.regex == null;
        }
        return this.regex.equals(other.regex);
    }

    public String toString() {
        return "(ValidatingStringParameterValue) " + this.getName() + "='" + this.value + "'";
    }
}

