/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.urltrigger.content.json.util;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import org.jenkinsci.plugins.xtriggerapi.XTriggerException;

public class JsonUtils {
    public static void validateJson(String content) throws XTriggerException {
        block4: {
            try {
                JsonParser parser = new JsonFactory().createParser(content.getBytes(StandardCharsets.UTF_8));
                JsonToken currentToken = parser.nextToken();
                if (currentToken.equals((Object)JsonToken.START_OBJECT)) {
                    JsonUtils.validateObject(parser);
                    break block4;
                }
                if (currentToken.equals((Object)JsonToken.START_ARRAY)) {
                    JsonUtils.validateArray(parser);
                    break block4;
                }
                throw new XTriggerException("Bad Json value starting with: " + String.valueOf(currentToken));
            }
            catch (IOException ex) {
                throw new XTriggerException("Bad Json value: " + ex.getMessage());
            }
        }
    }

    private static void validateObject(JsonParser parser) throws IOException {
        JsonToken currentToken = parser.nextValue();
        while (currentToken != null && !currentToken.equals((Object)JsonToken.END_OBJECT)) {
            if (currentToken.toString().startsWith("VALUE_")) {
                currentToken = parser.nextValue();
                continue;
            }
            if (currentToken.equals((Object)JsonToken.START_ARRAY)) {
                JsonUtils.validateArray(parser);
                currentToken = parser.nextValue();
                continue;
            }
            if (currentToken.equals((Object)JsonToken.START_OBJECT)) {
                JsonUtils.validateObject(parser);
                currentToken = parser.nextValue();
                continue;
            }
            throw new IOException("Expected object/array start, found: " + String.valueOf(currentToken));
        }
    }

    private static void validateArray(JsonParser parser) throws IOException {
        JsonToken currentToken = parser.nextValue();
        while (currentToken != null && !currentToken.equals((Object)JsonToken.END_ARRAY)) {
            if (currentToken.toString().startsWith("VALUE_")) {
                currentToken = parser.nextValue();
                continue;
            }
            if (currentToken.equals((Object)JsonToken.START_ARRAY)) {
                JsonUtils.validateArray(parser);
                currentToken = parser.nextValue();
                continue;
            }
            if (currentToken.equals((Object)JsonToken.START_OBJECT)) {
                JsonUtils.validateObject(parser);
                currentToken = parser.nextValue();
                continue;
            }
            throw new IOException("Expected object/array start, found: " + String.valueOf(currentToken));
        }
    }
}

