/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.urltrigger.content;

import hudson.Extension;
import hudson.Util;
import org.jenkinsci.Symbol;
import org.jenkinsci.plugins.urltrigger.content.URLTriggerContentType;
import org.jenkinsci.plugins.urltrigger.content.URLTriggerContentTypeDescriptor;
import org.jenkinsci.plugins.xtriggerapi.XTriggerException;
import org.jenkinsci.plugins.xtriggerapi.XTriggerLog;
import org.kohsuke.stapler.DataBoundConstructor;

public class SimpleContentType
extends URLTriggerContentType {
    private static final long serialVersionUID = 6181433290922523995L;
    private transient String md5;

    @DataBoundConstructor
    public SimpleContentType() {
    }

    @Override
    protected void initForContentType(String content, XTriggerLog log) throws XTriggerException {
        this.md5 = Util.getDigestOf((String)content);
    }

    @Override
    protected boolean isTriggeringBuildForContent(String content, XTriggerLog log) throws XTriggerException {
        if (this.md5 == null) {
            log.info("Capturing URL context. Waiting next schedule to check a change.");
            return false;
        }
        String newComputedMd5 = Util.getDigestOf((String)content);
        if (!newComputedMd5.equals(this.md5)) {
            log.info("The content of the URL has changed.");
            return true;
        }
        return false;
    }

    @Extension
    @Symbol(value={"MD5Sum"})
    public static class SimpleFileContentDescriptor
    extends URLTriggerContentTypeDescriptor<SimpleContentType> {
        @Override
        public Class<? extends URLTriggerContentType> getType() {
            return SimpleContentType.class;
        }

        public String getDisplayName() {
            return "Monitor a change of the content";
        }

        @Override
        public String getLabel() {
            return this.getDisplayName();
        }
    }
}

