/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.urltrigger;

import org.jenkinsci.plugins.urltrigger.URLTriggerEntry;

public class URLTriggerResolvedEntry {
    private String resolvedURL;
    private URLTriggerEntry entry;

    public URLTriggerResolvedEntry(String resolvedURL, URLTriggerEntry entry) {
        if (resolvedURL == null) {
            throw new NullPointerException("A resolved URL is required.");
        }
        this.resolvedURL = resolvedURL;
        if (entry == null) {
            throw new NullPointerException("An entry object is required.");
        }
        this.entry = entry;
    }

    public String getResolvedURL() {
        return this.resolvedURL;
    }

    public URLTriggerEntry getEntry() {
        return this.entry;
    }

    public boolean isURLTriggerValidURL() {
        return this.isHttp() || this.isHttps() || this.isFtp();
    }

    public boolean isHttp() {
        return this.resolvedURL.startsWith("http");
    }

    public boolean isHttps() {
        return this.resolvedURL.startsWith("https");
    }

    public boolean isFtp() {
        return this.resolvedURL.startsWith("ftp");
    }
}

