/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.uniqueid;

import hudson.ExtensionPoint;
import java.nio.charset.StandardCharsets;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import jenkins.model.Jenkins;
import org.apache.commons.codec.binary.Base64;

public abstract class IdStore<T>
implements ExtensionPoint {
    private final Class<T> type;

    public IdStore(Class<T> forType) {
        this.type = forType;
    }

    public abstract void make(T var1);

    @Nullable
    public abstract String get(T var1);

    public boolean supports(Class clazz) {
        return this.type.isAssignableFrom(clazz);
    }

    @Nullable
    public static <C> IdStore<C> forClass(Class<C> clazz) {
        Jenkins jenkins = Jenkins.getInstance();
        if (jenkins != null) {
            for (IdStore store : jenkins.getExtensionList(IdStore.class)) {
                if (!store.supports(clazz)) continue;
                return store;
            }
        }
        return null;
    }

    public static void makeId(Object object) throws IllegalArgumentException {
        IdStore<?> store = IdStore.forClass(object.getClass());
        if (store == null) {
            throw new IllegalArgumentException("Unsupported type: " + object.getClass().getName());
        }
        store.make(object);
    }

    public static String getId(Object object) throws IllegalArgumentException {
        IdStore<?> store = IdStore.forClass(object.getClass());
        if (store == null) {
            throw new IllegalArgumentException("Unsupported type: " + object.getClass().getName());
        }
        return store.get(object);
    }

    @Nonnull
    public static String fileName() {
        return "unique-id.txt";
    }

    protected static String generateUniqueID() {
        return Base64.encodeBase64String((byte[])UUID.randomUUID().toString().getBytes(StandardCharsets.UTF_8)).substring(0, 30);
    }
}

