/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.tokenmacro.impl;

import hudson.Extension;
import hudson.FilePath;
import hudson.model.AbstractBuild;
import hudson.model.Run;
import hudson.model.TaskListener;
import java.io.BufferedReader;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jenkinsci.plugins.tokenmacro.DataBoundTokenMacro;
import org.jenkinsci.plugins.tokenmacro.MacroEvaluationException;

@Extension
public final class LogRegExMacro
extends DataBoundTokenMacro {
    private static final String MACRO_NAME = "LOG_REGEX";
    @DataBoundTokenMacro.Parameter(required=true)
    public String regex = null;
    @DataBoundTokenMacro.Parameter(required=true)
    public String replacement = null;

    @Override
    public boolean acceptsMacroName(String macroName) {
        return MACRO_NAME.equals(macroName);
    }

    @Override
    public List<String> getAcceptedMacroNames() {
        return Collections.singletonList(MACRO_NAME);
    }

    @Override
    public String evaluate(AbstractBuild<?, ?> context, TaskListener listener, String macroName) throws MacroEvaluationException, IOException, InterruptedException {
        return this.evaluate((Run<?, ?>)context, null, listener, macroName);
    }

    @Override
    public String evaluate(Run<?, ?> run, FilePath workspace, TaskListener listener, String macroName) throws MacroEvaluationException, IOException, InterruptedException {
        return this.readLogFile(run);
    }

    private String readLogFile(Run<?, ?> run) throws IOException {
        if (this.regex == null) {
            return "";
        }
        Pattern pattern = Pattern.compile(this.regex);
        try (BufferedReader reader = new BufferedReader(run.getLogReader());){
            String line;
            while ((line = reader.readLine()) != null) {
                Matcher matcher = pattern.matcher(line);
                if (!matcher.find()) continue;
                String string = this.getTranslatedDescription(matcher);
                return string;
            }
        }
        return "";
    }

    private String getTranslatedDescription(Matcher matcher) {
        String result = this.replacement;
        if (result == null) {
            result = matcher.groupCount() == 0 ? "\\0" : "\\1";
        }
        for (int i = matcher.groupCount(); i >= 0; --i) {
            result = result.replace("\\" + i, matcher.group(i) == null ? "" : matcher.group(i));
        }
        return result;
    }
}

