/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.timestamper.io;

import com.google.common.io.ByteStreams;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import hudson.model.Run;
import hudson.plugins.timestamper.Timestamp;
import hudson.plugins.timestamper.io.TimeShiftsReader;
import hudson.plugins.timestamper.io.TimestamperPaths;
import hudson.plugins.timestamper.io.Varint;
import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.util.Optional;
import org.apache.commons.io.input.CountingInputStream;

public class TimestampsReader
implements Serializable,
Closeable {
    private static final long serialVersionUID = 1L;
    private final File timestampsFile;
    private long filePointer;
    private long elapsedMillis;
    private long millisSinceEpoch;
    private long entry;
    private final TimeShiftsReader timeShiftsReader;
    @CheckForNull
    private transient InputStream inputStream;

    public TimestampsReader(Run<?, ?> build) {
        this.timestampsFile = TimestamperPaths.timestampsFile(build).toFile();
        this.timeShiftsReader = new TimeShiftsReader(build);
        this.millisSinceEpoch = build.getStartTimeInMillis();
    }

    public void skip(int count) throws IOException {
        for (int i = 0; i < count; ++i) {
            Optional<Timestamp> timestamp = this.read();
            if (timestamp.isPresent()) continue;
            return;
        }
    }

    public int getAbs(int lineNumber) throws IOException {
        this.skip(-lineNumber);
        int numberOfTimestampsFromStart = 0;
        Optional<Timestamp> timestamp;
        while ((timestamp = this.read()).isPresent()) {
            ++numberOfTimestampsFromStart;
        }
        return numberOfTimestampsFromStart;
    }

    public Optional<Timestamp> read() throws IOException {
        if (this.inputStream == null) {
            if (!Files.isRegularFile(this.timestampsFile.toPath(), new LinkOption[0])) {
                return Optional.empty();
            }
            this.inputStream = Files.newInputStream(this.timestampsFile.toPath(), new OpenOption[0]);
            ByteStreams.skipFully((InputStream)this.inputStream, (long)this.filePointer);
            this.inputStream = new BufferedInputStream(this.inputStream);
        }
        Optional<Timestamp> timestamp = Optional.empty();
        if (this.filePointer < Files.size(this.timestampsFile.toPath())) {
            timestamp = Optional.of(this.readNext(this.inputStream));
        }
        return timestamp;
    }

    @Override
    public void close() {
        try {
            if (this.inputStream != null) {
                this.inputStream.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.inputStream = null;
    }

    private Timestamp readNext(InputStream inputStream) throws IOException {
        CountingInputStream countingInputStream = new CountingInputStream(inputStream);
        long elapsedMillisDiff = Varint.read((InputStream)countingInputStream);
        this.elapsedMillis += elapsedMillisDiff;
        this.millisSinceEpoch = this.timeShiftsReader.getTime(this.entry).orElse(this.millisSinceEpoch + elapsedMillisDiff);
        this.filePointer += (long)countingInputStream.getCount();
        ++this.entry;
        return new Timestamp(this.elapsedMillis, this.millisSinceEpoch);
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        try {
            if (this.inputStream != null) {
                this.inputStream.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

