/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.timestamper;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.ExtensionList;
import hudson.Util;
import hudson.plugins.timestamper.format.ElapsedTimestampFormat;
import hudson.plugins.timestamper.format.FormatParseException;
import hudson.plugins.timestamper.format.InvalidHtmlException;
import hudson.plugins.timestamper.format.SystemTimestampFormat;
import hudson.plugins.timestamper.format.TimestampFormat;
import hudson.util.FormValidation;
import jakarta.servlet.ServletException;
import java.io.IOException;
import java.util.Locale;
import java.util.Optional;
import java.util.function.Supplier;
import jenkins.YesNoMaybe;
import jenkins.model.GlobalConfiguration;
import jenkins.model.Jenkins;
import org.jenkinsci.Symbol;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.verb.POST;

@Extension(dynamicLoadable=YesNoMaybe.YES)
@Symbol(value={"timestamper", "timestamperConfig"})
public final class TimestamperConfig
extends GlobalConfiguration {
    private static final String DEFAULT_TIMESTAMP_FORMAT = "'<b>'HH:mm:ss'</b> '";
    private static final String DEFAULT_ELAPSED_TIME_FORMAT = "'<b>'HH:mm:ss.S'</b> '";
    @CheckForNull
    private String timestampFormat;
    @CheckForNull
    private String elapsedTimeFormat;
    private boolean allPipelines;

    public static TimestamperConfig get() {
        return (TimestamperConfig)((Object)ExtensionList.lookupSingleton(TimestamperConfig.class));
    }

    public TimestamperConfig() {
        this.load();
    }

    public String getSystemTimeFormat() {
        return this.timestampFormat == null ? DEFAULT_TIMESTAMP_FORMAT : this.timestampFormat;
    }

    public void setSystemTimeFormat(@CheckForNull String timestampFormat) {
        this.timestampFormat = timestampFormat != null ? timestampFormat.trim() : null;
        this.save();
    }

    @POST
    public FormValidation doCheckSystemTimeFormat(@QueryParameter String systemTimeFormat) {
        Jenkins.get().checkPermission(Jenkins.ADMINISTER);
        if (Util.fixEmptyAndTrim((String)systemTimeFormat) == null) {
            return FormValidation.ok();
        }
        return TimestamperConfig.validateFormat(() -> new SystemTimestampFormat(systemTimeFormat, Optional.empty(), Locale.getDefault()));
    }

    public String getElapsedTimeFormat() {
        return this.elapsedTimeFormat == null ? DEFAULT_ELAPSED_TIME_FORMAT : this.elapsedTimeFormat;
    }

    public void setElapsedTimeFormat(@CheckForNull String elapsedTimeFormat) {
        this.elapsedTimeFormat = elapsedTimeFormat != null ? elapsedTimeFormat.trim() : null;
        this.save();
    }

    @POST
    public FormValidation doCheckElapsedTimeFormat(@QueryParameter String elapsedTimeFormat) throws IOException, ServletException {
        Jenkins.get().checkPermission(Jenkins.ADMINISTER);
        if (Util.fixEmptyAndTrim((String)elapsedTimeFormat) == null) {
            return FormValidation.ok();
        }
        return TimestamperConfig.validateFormat(() -> new ElapsedTimestampFormat(elapsedTimeFormat));
    }

    private static FormValidation validateFormat(@NonNull Supplier<TimestampFormat> formatSupplier) {
        try {
            TimestampFormat format = formatSupplier.get();
            format.validate();
            return FormValidation.ok();
        }
        catch (FormatParseException e) {
            return FormValidation.error((String)"Error parsing format");
        }
        catch (InvalidHtmlException e) {
            return FormValidation.error((String)"Invalid HTML");
        }
    }

    public boolean isAllPipelines() {
        return this.allPipelines;
    }

    public void setAllPipelines(boolean allPipelines) {
        this.allPipelines = allPipelines;
        this.save();
    }
}

