/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.timestamper.io;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import hudson.model.Run;
import hudson.plugins.timestamper.io.TimestamperPaths;
import hudson.plugins.timestamper.io.Varint;
import java.io.Closeable;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.security.DigestOutputStream;
import java.security.MessageDigest;
import java.util.Arrays;
import java.util.Objects;
import java.util.Optional;

public class TimestampsWriter
implements Closeable {
    private static final int BUFFER_SIZE = 1024;
    private final Path timestampsFile;
    private final Optional<MessageDigest> timestampsDigest;
    @CheckForNull
    private OutputStream timestampsOutput;
    private final byte[] buffer = new byte[1024];
    private long previousCurrentTimeMillis;

    public TimestampsWriter(Run<?, ?> build) throws IOException {
        this(build, Optional.empty());
    }

    public TimestampsWriter(Run<?, ?> build, Optional<MessageDigest> digest) throws IOException {
        this(TimestamperPaths.timestampsFile(build), build.getStartTimeInMillis(), digest);
    }

    public TimestampsWriter(Path timestampsFile, long buildStartTime, Optional<MessageDigest> digest) throws IOException {
        this.timestampsFile = timestampsFile;
        this.previousCurrentTimeMillis = buildStartTime;
        this.timestampsDigest = Objects.requireNonNull(digest);
        Path parentDir = timestampsFile.getParent();
        if (parentDir != null) {
            Files.createDirectories(parentDir, new FileAttribute[0]);
        }
        Files.createFile(timestampsFile, new FileAttribute[0]);
    }

    public void write(long currentTimeMillis, int times) throws IOException {
        if (times < 1) {
            return;
        }
        long elapsedMillis = currentTimeMillis - this.previousCurrentTimeMillis;
        this.previousCurrentTimeMillis = currentTimeMillis;
        if (this.timestampsOutput == null) {
            this.timestampsOutput = this.openTimestampsStream();
        }
        this.writeVarintsTo(this.timestampsOutput, elapsedMillis);
        if (times > 1) {
            this.writeZerosTo(this.timestampsOutput, times - 1);
        }
    }

    private OutputStream openTimestampsStream() throws IOException {
        OutputStream outputStream = Files.newOutputStream(this.timestampsFile, new OpenOption[0]);
        if (this.timestampsDigest.isPresent()) {
            outputStream = new DigestOutputStream(outputStream, this.timestampsDigest.get());
        }
        return outputStream;
    }

    private void writeVarintsTo(OutputStream outputStream, long ... values) throws IOException {
        int offset = 0;
        for (long value : values) {
            offset = Varint.write(value, this.buffer, offset);
        }
        outputStream.write(this.buffer, 0, offset);
        outputStream.flush();
    }

    private void writeZerosTo(OutputStream outputStream, int n) throws IOException {
        Arrays.fill(this.buffer, (byte)0);
        while (n > 0) {
            int bytesToWrite = Math.min(n, this.buffer.length);
            n -= bytesToWrite;
            outputStream.write(this.buffer, 0, bytesToWrite);
            outputStream.flush();
        }
    }

    public void writeDigest() throws IOException {
        if (this.timestampsDigest.isPresent()) {
            this.writeDigest(this.timestampsDigest.get());
        }
    }

    private void writeDigest(MessageDigest timestampsDigest) throws IOException {
        StringBuilder hash = new StringBuilder();
        for (byte b : timestampsDigest.digest()) {
            hash.append(String.format("%02x", b));
        }
        hash.append("\n");
        Path digestFile = this.timestampsFile.resolveSibling(String.valueOf(this.timestampsFile.getFileName()) + "." + timestampsDigest.getAlgorithm());
        Files.write(digestFile, hash.toString().getBytes(StandardCharsets.US_ASCII), new OpenOption[0]);
    }

    @Override
    public void close() throws IOException {
        if (this.timestampsOutput != null) {
            this.timestampsOutput.close();
        }
    }
}

