/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.timestamper.annotator;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.MarkupText;
import hudson.console.ConsoleAnnotator;
import hudson.model.Run;
import hudson.plugins.timestamper.Timestamp;
import hudson.plugins.timestamper.annotator.ConsoleLogParser;
import hudson.plugins.timestamper.format.TimestampFormat;
import hudson.plugins.timestamper.format.TimestampFormatProvider;
import hudson.plugins.timestamper.io.TimestampsReader;
import java.io.IOException;
import java.util.Objects;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class TimestampAnnotator
extends ConsoleAnnotator<Run<?, ?>> {
    private static final long serialVersionUID = 1L;
    private static final Logger LOGGER = Logger.getLogger(TimestampAnnotator.class.getName());
    private final ConsoleLogParser logParser;
    @CheckForNull
    private TimestampsReader timestampsReader;
    @CheckForNull
    private transient TimestampFormat format;

    TimestampAnnotator(ConsoleLogParser logParser) {
        this.logParser = Objects.requireNonNull(logParser);
    }

    public ConsoleAnnotator<Run<?, ?>> annotate(@NonNull Run<?, ?> build, @NonNull MarkupText text) {
        try {
            if (this.timestampsReader == null) {
                ConsoleLogParser.Result logPosition = this.logParser.seek(build);
                if (logPosition.endOfFile) {
                    return null;
                }
                if (logPosition.lineNumber < 0) {
                    try (TimestampsReader temporaryTimestampsReader = new TimestampsReader(build);){
                        logPosition.lineNumber = temporaryTimestampsReader.getAbs(logPosition.lineNumber);
                    }
                }
                this.timestampsReader = new TimestampsReader(build);
                this.timestampsReader.skip(logPosition.lineNumber);
                Optional<Timestamp> timestamp = this.timestampsReader.read();
                if (logPosition.atNewLine && timestamp.isPresent()) {
                    this.markup(text, timestamp.get());
                }
                return this;
            }
            Optional<Timestamp> timestamp = this.timestampsReader.read();
            if (timestamp.isPresent()) {
                this.markup(text, timestamp.get());
                return this;
            }
        }
        catch (IOException ex) {
            LOGGER.log(Level.WARNING, "Error reading timestamps for " + build.getFullDisplayName(), ex);
        }
        if (this.timestampsReader != null) {
            this.timestampsReader.close();
        }
        return null;
    }

    private void markup(MarkupText text, Timestamp timestamp) {
        if (this.format == null) {
            this.format = TimestampFormatProvider.get();
        }
        this.format.markup(text, timestamp);
    }
}

