/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.timestamper.action;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.console.ConsoleNote;
import hudson.model.Run;
import hudson.plugins.timestamper.Timestamp;
import hudson.plugins.timestamper.accessor.TimestampLogFileLine;
import hudson.plugins.timestamper.accessor.TimestampLogFileLineAccessor;
import hudson.plugins.timestamper.action.TimestampsActionQuery;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Optional;
import java.util.function.Function;

public class TimestampsActionOutput {
    public static BufferedReader open(Run<?, ?> build, TimestampsActionQuery query) {
        long buildStartTime = build.getStartTimeInMillis();
        long millisSinceEpoch = System.currentTimeMillis();
        Timestamp currentTimestamp = new Timestamp(millisSinceEpoch - buildStartTime, millisSinceEpoch);
        return TimestampsActionOutput.open(query, currentTimestamp, build);
    }

    static BufferedReader open(final TimestampsActionQuery query, Timestamp currentTimestamp, final Run<?, ?> build) {
        if (query.currentTime) {
            ArrayList<String> parts = new ArrayList<String>();
            for (Function<Timestamp, String> format : query.timestampFormats) {
                parts.add(format.apply(currentTimestamp));
            }
            String result = String.join((CharSequence)" ", parts) + "\n";
            return new BufferedReader(new StringReader(result));
        }
        final StringBuilder buffer = new StringBuilder();
        Reader reader = new Reader(){
            int linesRead;
            Optional<Integer> endLine = Optional.empty();
            boolean started;
            TimestampLogFileLineAccessor timestampLogFileLineAccessor;

            @Override
            public int read(@NonNull char[] cbuf, int off, int len) throws IOException {
                int numRead;
                Optional<String> nextLine;
                if (!this.started) {
                    this.timestampLogFileLineAccessor = new TimestampLogFileLineAccessor(build);
                    this.linesRead = this.readToStartLine(query);
                    this.endLine = this.resolveEndLine(query);
                    this.started = true;
                }
                while (buffer.length() < len && (nextLine = this.readNextLine(query)).isPresent()) {
                    ++this.linesRead;
                    if (this.endLine.isPresent() && this.linesRead > this.endLine.get()) break;
                    buffer.append(nextLine.get());
                    buffer.append("\n");
                }
                buffer.delete(0, (numRead = new StringReader(buffer.toString()).read(cbuf, off, len)) >= 0 ? numRead : buffer.length());
                return numRead;
            }

            private int readToStartLine(TimestampsActionQuery query2) throws IOException {
                int linesToSkip = Math.max(query2.startLine - 1, 0);
                if (query2.startLine < 0) {
                    linesToSkip = this.timestampLogFileLineAccessor.getLineCount() + query2.startLine;
                }
                for (int line = 0; line < linesToSkip; ++line) {
                    this.timestampLogFileLineAccessor.skipLine();
                }
                return linesToSkip;
            }

            private Optional<Integer> resolveEndLine(TimestampsActionQuery query2) throws IOException {
                if (query2.endLine.isPresent() && query2.endLine.get() < 0) {
                    return Optional.of(this.timestampLogFileLineAccessor.getLineCount() + query2.endLine.get() + 1);
                }
                return query2.endLine;
            }

            private Optional<String> readNextLine(TimestampsActionQuery query2) throws IOException {
                TimestampLogFileLine timestampLogFileLine = this.timestampLogFileLineAccessor.readLine();
                Optional<Timestamp> timestamp = timestampLogFileLine.getTimestamp();
                Optional<String> logFileLine = timestampLogFileLine.getLogFileLine();
                Object result = "";
                if (timestamp.isPresent()) {
                    ArrayList<String> parts = new ArrayList<String>();
                    for (Function<Timestamp, String> format : query2.timestampFormats) {
                        parts.add(format.apply(timestamp.get()));
                    }
                    result = String.join((CharSequence)" ", parts);
                }
                if (query2.appendLogLine) {
                    result = (String)result + "  ";
                    if (logFileLine.isPresent()) {
                        result = (String)result + ConsoleNote.removeNotes((String)logFileLine.get());
                    }
                }
                if (!timestamp.isPresent() && !logFileLine.isPresent()) {
                    return Optional.empty();
                }
                return Optional.of(result);
            }

            @Override
            public void close() throws IOException {
                this.timestampLogFileLineAccessor.close();
            }
        };
        return new BufferedReader(reader);
    }

    private TimestampsActionOutput() {
    }
}

