/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.timestamper.pipeline;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.MarkupText;
import hudson.console.ConsoleAnnotator;
import hudson.console.ConsoleAnnotatorFactory;
import hudson.model.Queue;
import hudson.model.Run;
import hudson.plugins.timestamper.Timestamp;
import hudson.plugins.timestamper.format.TimestampFormat;
import hudson.plugins.timestamper.format.TimestampFormatProvider;
import hudson.plugins.timestamper.pipeline.GlobalDecorator;
import java.io.IOException;
import java.time.ZonedDateTime;
import java.time.format.DateTimeParseException;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jenkinsci.plugins.workflow.flow.FlowExecutionOwner;
import org.jenkinsci.plugins.workflow.graph.FlowNode;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;

public final class GlobalAnnotator
extends ConsoleAnnotator<Object> {
    private static final long serialVersionUID = 1L;
    private static final Logger LOGGER = Logger.getLogger(GlobalAnnotator.class.getName());

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public ConsoleAnnotator<Object> annotate(@NonNull Object context, @NonNull MarkupText text) {
        Run build;
        if (context instanceof Run) {
            build = (Run)context;
        } else {
            Queue.Executable executable;
            if (!(context instanceof FlowNode)) return null;
            FlowExecutionOwner owner = ((FlowNode)context).getExecution().getOwner();
            if (owner == null) {
                return null;
            }
            try {
                executable = owner.getExecutable();
            }
            catch (IOException x) {
                LOGGER.log(Level.FINE, null, x);
                return null;
            }
            if (!(executable instanceof Run)) return null;
            build = (Run)executable;
        }
        long buildStartTime = build.getStartTimeInMillis();
        GlobalAnnotator.parseTimestamp(text.getText(), buildStartTime).ifPresent(timestamp -> {
            TimestampFormat format = TimestampFormatProvider.get();
            format.markup(text, (Timestamp)timestamp);
            text.addMarkup(0, 26, "<span style=\"display: none\">", "</span>");
        });
        return this;
    }

    @Restricted(value={NoExternalUse.class})
    public static Optional<Timestamp> parseTimestamp(String text, long buildStartTime) {
        int end;
        if (text.startsWith("[") && (end = text.indexOf(93)) != -1) {
            try {
                long millisSinceEpoch = ZonedDateTime.parse(text.substring(1, end), GlobalDecorator.UTC_MILLIS).toInstant().toEpochMilli();
                Timestamp timestamp = new Timestamp(millisSinceEpoch - buildStartTime, millisSinceEpoch);
                return Optional.of(timestamp);
            }
            catch (DateTimeParseException dateTimeParseException) {
                // empty catch block
            }
        }
        return Optional.empty();
    }

    @Extension
    public static final class Factory
    extends ConsoleAnnotatorFactory<Object> {
        public ConsoleAnnotator<Object> newInstance(Object context) {
            if (context instanceof Run && context instanceof FlowExecutionOwner.Executable) {
                return new GlobalAnnotator();
            }
            if (context instanceof FlowNode) {
                return new GlobalAnnotator();
            }
            return null;
        }
    }
}

