/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.timestamper;

import hudson.MarkupText;
import hudson.console.ConsoleAnnotator;
import hudson.console.ConsoleNote;
import hudson.model.AbstractBuild;
import hudson.model.Run;
import hudson.plugins.timestamper.Timestamp;
import hudson.plugins.timestamper.format.TimestampFormat;
import hudson.plugins.timestamper.format.TimestampFormatProvider;
import org.apache.commons.lang3.builder.ToStringBuilder;

public final class TimestampNote
extends ConsoleNote<Object> {
    private static final long serialVersionUID = 1L;
    private final Long elapsedMillis;
    private final long millisSinceEpoch;

    public static String getSystemProperty() {
        return "timestamper-consolenotes";
    }

    public static boolean useTimestampNotes(Class<?> buildClass) {
        return !AbstractBuild.class.isAssignableFrom(buildClass);
    }

    public TimestampNote(long elapsedMillis, long millisSinceEpoch) {
        this.elapsedMillis = elapsedMillis;
        this.millisSinceEpoch = millisSinceEpoch;
    }

    public Timestamp getTimestamp(Object context) {
        if (this.elapsedMillis == null && context instanceof Run) {
            Run build = (Run)context;
            long buildStartTime = build.getStartTimeInMillis();
            return new Timestamp(this.millisSinceEpoch - buildStartTime, this.millisSinceEpoch);
        }
        return new Timestamp(this.elapsedMillis, this.millisSinceEpoch);
    }

    public ConsoleAnnotator<Object> annotate(Object context, MarkupText text, int charPos) {
        TimestampFormat format = TimestampFormatProvider.get();
        Timestamp timestamp = this.getTimestamp(context);
        format.markup(text, timestamp);
        if (!(context instanceof Run)) {
            text.addMarkup(0, "<style>.timestamper-plain-text {visibility: hidden;}</style>");
        }
        return null;
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("elapsedMillis", (Object)this.elapsedMillis).append("millisSinceEpoch", this.millisSinceEpoch).toString();
    }
}

