/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.timestamper.io;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;

final class Varint {
    static int write(long value, byte[] writeTo, int offset) throws IOException {
        while (true) {
            if ((value & 0xFFFFFFFFFFFFFF80L) == 0L) {
                writeTo[offset] = (byte)value;
                return ++offset;
            }
            writeTo[offset] = (byte)((int)value & 0x7F | 0x80);
            ++offset;
            value >>>= 7;
        }
    }

    static long read(InputStream inputStream) throws IOException {
        long result = 0L;
        for (int shift = 0; shift < 64; shift += 7) {
            int value = inputStream.read();
            if (value == -1) {
                throw new EOFException();
            }
            byte b = (byte)value;
            result |= (long)(b & 0x7F) << shift;
            if ((b & 0x80) != 0) continue;
            return result;
        }
        throw new IOException("Malformed varint");
    }

    private Varint() {
    }
}

