/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.timestamper.format;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.plugins.timestamper.Timestamp;
import hudson.plugins.timestamper.format.FormatParseException;
import hudson.plugins.timestamper.format.FormatStringUtils;
import hudson.plugins.timestamper.format.InvalidHtmlException;
import hudson.plugins.timestamper.format.TimestampFormat;
import hudson.plugins.timestamper.format.TimestampFormatUtils;
import java.util.Objects;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.time.DurationFormatUtils;

public final class ElapsedTimestampFormat
extends TimestampFormat {
    private final String elapsedTimeFormat;

    public ElapsedTimestampFormat(String elapsedTimeFormat) {
        this.elapsedTimeFormat = Objects.requireNonNull(elapsedTimeFormat);
    }

    @Override
    public String apply(@NonNull Timestamp timestamp) {
        if (timestamp.elapsedMillisKnown) {
            String result = DurationFormatUtils.formatDuration((long)timestamp.elapsedMillis, (String)this.elapsedTimeFormat);
            return TimestampFormatUtils.sanitize(result);
        }
        return "";
    }

    @Override
    public void validate() throws FormatParseException, InvalidHtmlException {
        String result;
        try {
            result = DurationFormatUtils.formatDuration((long)1000L, (String)this.elapsedTimeFormat);
        }
        catch (IllegalArgumentException e) {
            throw new FormatParseException(e);
        }
        String sanitized = TimestampFormatUtils.sanitize(result);
        if (!sanitized.equals(result)) {
            throw new InvalidHtmlException();
        }
    }

    @Override
    public String getPlainTextUrl() {
        String elapsedParamValue = this.elapsedTimeFormat;
        elapsedParamValue = FormatStringUtils.stripHtmlTags(elapsedParamValue);
        elapsedParamValue = FormatStringUtils.trim(elapsedParamValue);
        return "timestamps/?elapsed=" + elapsedParamValue + "&appendLog";
    }

    public int hashCode() {
        return this.elapsedTimeFormat.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof ElapsedTimestampFormat) {
            ElapsedTimestampFormat other = (ElapsedTimestampFormat)obj;
            return this.elapsedTimeFormat.equals(other.elapsedTimeFormat);
        }
        return false;
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("format", (Object)this.elapsedTimeFormat).toString();
    }
}

