/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.timestamper.action;

import hudson.plugins.timestamper.Timestamp;
import hudson.plugins.timestamper.action.PrecisionTimestampFormat;
import hudson.plugins.timestamper.format.ElapsedTimestampFormat;
import hudson.plugins.timestamper.format.SystemTimestampFormat;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import org.apache.commons.lang3.LocaleUtils;
import org.apache.commons.lang3.builder.ToStringBuilder;

public final class TimestampsActionQuery {
    final int startLine;
    final Optional<Integer> endLine;
    final List<Function<Timestamp, String>> timestampFormats;
    final boolean appendLogLine;
    final boolean currentTime;

    public static TimestampsActionQuery create(String query) {
        int startLine = 0;
        Optional<Integer> endLine = Optional.empty();
        ArrayList<Function<Timestamp, String>> timestampFormats = new ArrayList<Function<Timestamp, String>>();
        boolean appendLogLine = false;
        boolean currentTime = false;
        List<QueryParameter> queryParameters = TimestampsActionQuery.readQueryString(query);
        Optional<String> timeZoneId = Optional.empty();
        Locale locale = Locale.getDefault();
        for (QueryParameter parameter : queryParameters) {
            if (parameter.name.equalsIgnoreCase("timeZone")) {
                timeZoneId = Optional.of(parameter.value.replace("GMT ", "GMT+"));
                continue;
            }
            if (!parameter.name.equalsIgnoreCase("locale")) continue;
            locale = LocaleUtils.toLocale((String)parameter.value);
        }
        for (QueryParameter parameter : queryParameters) {
            if (parameter.name.equalsIgnoreCase("time")) {
                timestampFormats.add(new SystemTimestampFormat(parameter.value, timeZoneId, locale));
                continue;
            }
            if (parameter.name.equalsIgnoreCase("elapsed")) {
                timestampFormats.add(new ElapsedTimestampFormat(parameter.value));
                continue;
            }
            if (parameter.name.equalsIgnoreCase("precision")) {
                int precision = TimestampsActionQuery.readPrecision(parameter.value);
                timestampFormats.add(new PrecisionTimestampFormat(precision));
                continue;
            }
            if (parameter.name.equalsIgnoreCase("appendLog")) {
                appendLogLine = parameter.value.isEmpty() || Boolean.parseBoolean(parameter.value);
                continue;
            }
            if (parameter.name.equalsIgnoreCase("currentTime")) {
                currentTime = parameter.value.isEmpty() || Boolean.parseBoolean(parameter.value);
                continue;
            }
            if (parameter.name.equalsIgnoreCase("startLine")) {
                startLine = Integer.parseInt(parameter.value);
                continue;
            }
            if (!parameter.name.equalsIgnoreCase("endLine")) continue;
            endLine = Optional.of(Integer.valueOf(parameter.value));
        }
        if (timestampFormats.isEmpty()) {
            timestampFormats.add(new PrecisionTimestampFormat(3));
        }
        return new TimestampsActionQuery(startLine, endLine, timestampFormats, appendLogLine, currentTime);
    }

    private static List<QueryParameter> readQueryString(String query) {
        ArrayList<QueryParameter> parameters = new ArrayList<QueryParameter>();
        if (query != null) {
            String[] pairs;
            for (String pair : pairs = query.split("&")) {
                String[] nameAndValue = pair.split("=", 2);
                String name = TimestampsActionQuery.urlDecode(nameAndValue[0]);
                String value = nameAndValue.length == 1 ? "" : TimestampsActionQuery.urlDecode(nameAndValue[1]);
                parameters.add(new QueryParameter(name, value));
            }
        }
        return Collections.unmodifiableList(parameters);
    }

    private static String urlDecode(String string) {
        try {
            return URLDecoder.decode(string, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    private static int readPrecision(String precision) {
        if ("seconds".equalsIgnoreCase(precision)) {
            return 0;
        }
        if ("milliseconds".equalsIgnoreCase(precision)) {
            return 3;
        }
        if ("microseconds".equalsIgnoreCase(precision)) {
            return 6;
        }
        if ("nanoseconds".equalsIgnoreCase(precision)) {
            return 9;
        }
        int intPrecision = Integer.parseInt(precision);
        if (intPrecision < 0) {
            throw new IllegalArgumentException("Expected non-negative precision, but was: " + precision);
        }
        return intPrecision;
    }

    TimestampsActionQuery(int startLine, Optional<Integer> endLine, List<? extends Function<Timestamp, String>> timestampFormats, boolean appendLogLine, boolean currentTime) {
        this.startLine = startLine;
        this.endLine = Objects.requireNonNull(endLine);
        this.timestampFormats = Collections.unmodifiableList(new ArrayList<Function<Timestamp, String>>(timestampFormats));
        this.appendLogLine = appendLogLine;
        this.currentTime = currentTime;
    }

    public int hashCode() {
        return Objects.hash(this.startLine, this.endLine, this.timestampFormats, this.appendLogLine, this.currentTime);
    }

    public boolean equals(Object obj) {
        if (obj instanceof TimestampsActionQuery) {
            TimestampsActionQuery other = (TimestampsActionQuery)obj;
            return this.startLine == other.startLine && this.endLine.equals(other.endLine) && this.timestampFormats.equals(other.timestampFormats) && this.appendLogLine == other.appendLogLine && this.currentTime == other.currentTime;
        }
        return false;
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("startLine", this.startLine).append("endLine", this.endLine).append("timestampFormats", this.timestampFormats).append("appendLogLine", this.appendLogLine).append("currentTime", this.currentTime).toString();
    }

    private static class QueryParameter {
        final String name;
        final String value;

        QueryParameter(String name, String value) {
            this.name = Objects.requireNonNull(name);
            this.value = Objects.requireNonNull(value);
        }

        public String toString() {
            return this.name + "=" + this.value;
        }
    }
}

