/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.throttleconcurrents;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.Util;
import hudson.matrix.MatrixProject;
import hudson.model.AbstractDescribableImpl;
import hudson.model.Descriptor;
import hudson.model.Item;
import hudson.model.ItemGroup;
import hudson.model.Job;
import hudson.model.JobProperty;
import hudson.model.JobPropertyDescriptor;
import hudson.model.Queue;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.plugins.throttleconcurrents.Messages;
import hudson.plugins.throttleconcurrents.ThrottleMatrixProjectOptions;
import hudson.util.CopyOnWriteMap;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.WeakHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.BinaryOperator;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import jenkins.model.Jenkins;
import net.sf.json.JSONObject;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.Symbol;
import org.jenkinsci.plugins.workflow.flow.FlowExecution;
import org.jenkinsci.plugins.workflow.flow.FlowExecutionOwner;
import org.jenkinsci.plugins.workflow.graph.FlowNode;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest2;

public class ThrottleJobProperty
extends JobProperty<Job<?, ?>> {
    @Deprecated
    transient String category;
    private Integer maxConcurrentPerNode;
    private Integer maxConcurrentTotal;
    private List<String> categories;
    private boolean throttleEnabled;
    private String throttleOption;
    private boolean limitOneJobWithMatchingParams;
    private transient boolean throttleConfiguration;
    @CheckForNull
    private ThrottleMatrixProjectOptions matrixOptions;
    private String paramsToUseForLimit;
    private transient List<String> paramsToCompare;
    private static final String PARAMS_LIMIT_SEPARATOR = "[\\s,]+";
    private Long configVersion;

    @DataBoundConstructor
    public ThrottleJobProperty(Integer maxConcurrentPerNode, Integer maxConcurrentTotal, List<String> categories, boolean throttleEnabled, String throttleOption, boolean limitOneJobWithMatchingParams, String paramsToUseForLimit, @CheckForNull ThrottleMatrixProjectOptions matrixOptions) {
        this.maxConcurrentPerNode = maxConcurrentPerNode;
        this.maxConcurrentTotal = maxConcurrentTotal;
        this.categories = categories == null ? new CopyOnWriteArrayList<String>() : new CopyOnWriteArrayList<String>(categories);
        this.throttleEnabled = throttleEnabled;
        this.throttleOption = throttleOption;
        this.limitOneJobWithMatchingParams = limitOneJobWithMatchingParams;
        this.matrixOptions = matrixOptions;
        this.paramsToUseForLimit = paramsToUseForLimit;
        this.paramsToCompare = ThrottleJobProperty.parseParamsToUseForLimit(this.paramsToUseForLimit);
    }

    public Object readResolve() {
        if (this.configVersion == null) {
            this.configVersion = 0L;
        }
        if (this.categories == null) {
            this.categories = new CopyOnWriteArrayList<String>();
        }
        if (this.category != null) {
            this.categories.add(this.category);
            this.category = null;
        }
        if (this.configVersion < 1L && this.throttleOption == null) {
            if (this.categories.isEmpty()) {
                this.throttleOption = "project";
            } else {
                this.throttleOption = "category";
                this.maxConcurrentPerNode = 0;
                this.maxConcurrentTotal = 0;
            }
        }
        this.configVersion = 1L;
        if (this.throttleConfiguration && this.matrixOptions == null) {
            this.matrixOptions = new ThrottleMatrixProjectOptions(false, true);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setOwner(Job<?, ?> owner) {
        super.setOwner(owner);
        if (this.throttleEnabled && this.categories != null) {
            DescriptorImpl descriptor = (DescriptorImpl)this.getDescriptor();
            Object object = descriptor.propertiesByCategoryLock;
            synchronized (object) {
                for (String c : this.categories) {
                    Map properties = descriptor.propertiesByCategory.computeIfAbsent(c, k -> new WeakHashMap());
                    properties.put(this, null);
                }
            }
        }
    }

    public boolean getThrottleEnabled() {
        return this.throttleEnabled;
    }

    public boolean isLimitOneJobWithMatchingParams() {
        return this.limitOneJobWithMatchingParams;
    }

    public String getThrottleOption() {
        return this.throttleOption;
    }

    public List<String> getCategories() {
        return this.categories;
    }

    public Integer getMaxConcurrentPerNode() {
        if (this.maxConcurrentPerNode == null) {
            this.maxConcurrentPerNode = 0;
        }
        return this.maxConcurrentPerNode;
    }

    public Integer getMaxConcurrentTotal() {
        if (this.maxConcurrentTotal == null) {
            this.maxConcurrentTotal = 0;
        }
        return this.maxConcurrentTotal;
    }

    public String getParamsToUseForLimit() {
        return this.paramsToUseForLimit;
    }

    @CheckForNull
    public ThrottleMatrixProjectOptions getMatrixOptions() {
        return this.matrixOptions;
    }

    public boolean isThrottleMatrixBuilds() {
        return this.matrixOptions != null ? this.matrixOptions.isThrottleMatrixBuilds() : ThrottleMatrixProjectOptions.DEFAULT.isThrottleMatrixBuilds();
    }

    public boolean isThrottleMatrixConfigurations() {
        return this.matrixOptions != null ? this.matrixOptions.isThrottleMatrixConfigurations() : ThrottleMatrixProjectOptions.DEFAULT.isThrottleMatrixConfigurations();
    }

    public List<String> getParamsToCompare() {
        if (this.paramsToCompare == null) {
            this.paramsToCompare = ThrottleJobProperty.parseParamsToUseForLimit(this.paramsToUseForLimit);
        }
        return this.paramsToCompare;
    }

    private static List<String> parseParamsToUseForLimit(String paramsToUseForLimit) {
        if (paramsToUseForLimit != null) {
            if (!paramsToUseForLimit.isEmpty()) {
                String[] split = ArrayUtils.nullToEmpty((String[])paramsToUseForLimit.split(PARAMS_LIMIT_SEPARATOR));
                ArrayList<String> result = new ArrayList<String>(Arrays.asList(split));
                result.removeAll(Collections.singletonList(""));
                return result;
            }
            return new ArrayList<String>();
        }
        return new ArrayList<String>();
    }

    @NonNull
    static Map<String, List<String>> getCategoriesForRunByFlowNode(@NonNull Run<?, ?> run) {
        HashMap<String, List<String>> categoriesByNode = new HashMap<String, List<String>>();
        DescriptorImpl descriptor = ThrottleJobProperty.fetchDescriptor();
        for (ThrottleCategory cat : descriptor.getCategories()) {
            Map<String, List<String>> runs = descriptor.getThrottledPipelinesForCategory(cat.getCategoryName());
            List<String> nodeIds = runs.get(run.getExternalizableId());
            if (nodeIds == null) continue;
            for (String nodeId : nodeIds) {
                List categories = categoriesByNode.computeIfAbsent(nodeId, k -> new ArrayList());
                categories.add(cat.getCategoryName());
            }
        }
        return categoriesByNode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static List<Queue.Task> getCategoryTasks(@NonNull String category) {
        Collection<Object> properties;
        assert (!StringUtils.isEmpty((String)category));
        ArrayList<Queue.Task> categoryTasks = new ArrayList<Queue.Task>();
        DescriptorImpl descriptor = ThrottleJobProperty.fetchDescriptor();
        Iterator<Object> iterator = descriptor.propertiesByCategoryLock;
        synchronized (iterator) {
            Map<ThrottleJobProperty, Void> map = descriptor.propertiesByCategory.get(category);
            properties = map != null ? new ArrayList<ThrottleJobProperty>(map.keySet()) : Collections.emptySet();
        }
        for (ThrottleJobProperty throttleJobProperty : properties) {
            Job p;
            if (!throttleJobProperty.getThrottleEnabled() || throttleJobProperty.getCategories() == null || !throttleJobProperty.getCategories().contains(category) || !((p = throttleJobProperty.owner) instanceof Queue.Task) || ThrottleJobProperty.getItem(p.getParent(), p.getName()) != p || p.getProperty(ThrottleJobProperty.class) != throttleJobProperty) continue;
            categoryTasks.add((Queue.Task)p);
            if (!(p instanceof MatrixProject) || !throttleJobProperty.isThrottleMatrixConfigurations()) continue;
            categoryTasks.addAll(((MatrixProject)p).getActiveConfigurations());
        }
        return categoryTasks;
    }

    @NonNull
    static Map<String, List<FlowNode>> getThrottledPipelineRunsForCategory(@NonNull String category) {
        TreeMap<String, List<FlowNode>> throttledPipelines = new TreeMap<String, List<FlowNode>>();
        DescriptorImpl descriptor = ThrottleJobProperty.fetchDescriptor();
        for (Map.Entry<String, List<String>> currentPipeline : descriptor.getThrottledPipelinesForCategory(category).entrySet()) {
            Run flowNodeRun = Run.fromExternalizableId((String)currentPipeline.getKey());
            ArrayList<FlowNode> flowNodes = new ArrayList<FlowNode>();
            if (flowNodeRun == null || !(flowNodeRun instanceof FlowExecutionOwner.Executable) || !flowNodeRun.isBuilding()) {
                descriptor.removeAllFromPipelineRunForCategory(currentPipeline.getKey(), category, null);
            } else {
                FlowExecutionOwner executionOwner = ((FlowExecutionOwner.Executable)flowNodeRun).asFlowExecutionOwner();
                if (executionOwner != null) {
                    FlowExecution execution = executionOwner.getOrNull();
                    if (execution == null) {
                        descriptor.removeAllFromPipelineRunForCategory(currentPipeline.getKey(), category, null);
                    } else {
                        for (String flowNodeId : currentPipeline.getValue()) {
                            try {
                                FlowNode node = execution.getNode(flowNodeId);
                                if (node != null) {
                                    flowNodes.add(node);
                                    continue;
                                }
                                descriptor.removeThrottledPipelineForCategory(currentPipeline.getKey(), flowNodeId, category, null);
                            }
                            catch (IOException iOException) {}
                        }
                    }
                }
            }
            if (flowNodes.isEmpty()) continue;
            throttledPipelines.put(currentPipeline.getKey(), flowNodes);
        }
        return throttledPipelines;
    }

    private static Item getItem(ItemGroup<?> group, String name) {
        if (group instanceof Jenkins) {
            return (Item)((Jenkins)group).getItemMap().get(name);
        }
        return group.getItem(name);
    }

    public static DescriptorImpl fetchDescriptor() {
        return (DescriptorImpl)Jenkins.get().getDescriptorByType(DescriptorImpl.class);
    }

    @Extension
    @Symbol(value={"throttleJobProperty"})
    public static final class DescriptorImpl
    extends JobPropertyDescriptor {
        private static final Logger LOGGER = Logger.getLogger(DescriptorImpl.class.getName());
        private List<ThrottleCategory> categories;
        private Map<String, Map<String, List<String>>> throttledPipelinesByCategory;
        private transient Map<String, Map<ThrottleJobProperty, Void>> propertiesByCategory = new HashMap<String, Map<ThrottleJobProperty, Void>>();
        private final transient Object propertiesByCategoryLock;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public DescriptorImpl() {
            super(ThrottleJobProperty.class);
            Object object = this.propertiesByCategoryLock = new Object();
            synchronized (object) {
                this.load();
                if (this.propertiesByCategory == null) {
                    this.propertiesByCategory = new HashMap<String, Map<ThrottleJobProperty, Void>>();
                }
                if (!this.propertiesByCategory.isEmpty()) {
                    this.propertiesByCategory.clear();
                    this.save();
                }
            }
        }

        public String getDisplayName() {
            return "Throttle Concurrent Builds";
        }

        public boolean isApplicable(Class<? extends Job> jobType) {
            return Job.class.isAssignableFrom(jobType) && Queue.Task.class.isAssignableFrom(jobType);
        }

        public boolean isMatrixProject(Job<?, ?> job) {
            return job instanceof MatrixProject;
        }

        public boolean configure(StaplerRequest2 req, JSONObject formData) throws Descriptor.FormException {
            if (!formData.has("categories")) {
                this.categories = null;
            }
            req.bindJSON((Object)this, formData);
            this.save();
            return true;
        }

        public FormValidation doCheckCategoryName(@QueryParameter String value) {
            if (Util.fixEmptyAndTrim((String)value) == null) {
                return FormValidation.error((String)"Empty category names are not allowed.");
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckMaxConcurrentPerNode(@QueryParameter String value) {
            return this.checkNullOrInt(value);
        }

        private FormValidation checkNullOrInt(String value) {
            if (Util.fixEmptyAndTrim((String)value) != null) {
                return FormValidation.validateNonNegativeInteger((String)value);
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckMaxConcurrentTotal(@QueryParameter String value) {
            return this.checkNullOrInt(value);
        }

        public ThrottleCategory getCategoryByName(String categoryName) {
            ThrottleCategory category = null;
            if (this.categories != null) {
                for (ThrottleCategory tc : this.categories) {
                    if (!tc.getCategoryName().equals(categoryName)) continue;
                    category = tc;
                }
            }
            return category;
        }

        public void setCategories(List<ThrottleCategory> categories) {
            this.categories = new CopyOnWriteArrayList<ThrottleCategory>(categories);
        }

        public List<ThrottleCategory> getCategories() {
            if (this.categories == null) {
                this.categories = new CopyOnWriteArrayList<ThrottleCategory>();
            }
            return this.categories;
        }

        public ListBoxModel doFillCategoryItems(@AncestorInPath Item item) {
            if (item != null) {
                item.checkPermission(Item.CONFIGURE);
            } else {
                Jenkins.get().checkPermission(Jenkins.ADMINISTER);
            }
            ListBoxModel m = new ListBoxModel();
            m.add("(none)", "");
            for (ThrottleCategory tc : this.getCategories()) {
                m.add(tc.getCategoryName());
            }
            return m;
        }

        public void load() {
            super.load();
            this.initThrottledPipelines();
            LOGGER.log(Level.FINE, "load: {0}", this.throttledPipelinesByCategory);
        }

        private synchronized void initThrottledPipelines() {
            if (this.throttledPipelinesByCategory == null) {
                this.throttledPipelinesByCategory = new TreeMap<String, Map<String, List<String>>>();
            } else if (this.throttledPipelinesByCategory.entrySet().stream().anyMatch(e -> !(e.getValue() instanceof CopyOnWriteMap.Tree))) {
                LOGGER.log(Level.INFO, "Migrating throttled pipelines by category to copy-on-write data structures.");
                LOGGER.log(Level.FINE, "Original values: {0}", this.throttledPipelinesByCategory);
                this.throttledPipelinesByCategory = this.throttledPipelinesByCategory.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, DescriptorImpl::convertValueToCopyOnWriteDataStructures, DescriptorImpl.throwingMerger(), TreeMap::new));
                LOGGER.log(Level.INFO, "Finished migrating throttled pipelines by category to copy-on-write data structures. Immediately persisting migrated state.");
                LOGGER.log(Level.FINE, "New values: {0}", this.throttledPipelinesByCategory);
                this.save();
                LOGGER.log(Level.INFO, "Migrated state persisted successfully.");
            }
        }

        private static Map<String, List<String>> convertValueToCopyOnWriteDataStructures(Map.Entry<String, Map<String, List<String>>> original) {
            return (Map)original.getValue().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> new CopyOnWriteArrayList((Collection)e.getValue()), DescriptorImpl.throwingMerger(), CopyOnWriteMap.Tree::new));
        }

        private static <T> BinaryOperator<T> throwingMerger() {
            return (u, v) -> {
                throw new IllegalStateException(String.format("Duplicate key %s", u));
            };
        }

        public void save() {
            super.save();
            LOGGER.log(Level.FINE, "save: {0}", this.throttledPipelinesByCategory);
        }

        @NonNull
        public synchronized Map<String, List<String>> getThrottledPipelinesForCategory(@NonNull String category) {
            return this.internalGetThrottledPipelinesForCategory(category);
        }

        @NonNull
        private Map<String, List<String>> internalGetThrottledPipelinesForCategory(@NonNull String category) {
            if (this.getCategoryByName(category) != null && this.throttledPipelinesByCategory.containsKey(category)) {
                return this.throttledPipelinesByCategory.get(category);
            }
            return new CopyOnWriteMap.Tree();
        }

        public synchronized void addThrottledPipelineForCategory(@NonNull String runId, @NonNull String flowNodeId, @NonNull String category, TaskListener listener) {
            if (this.getCategoryByName(category) == null) {
                if (listener != null) {
                    listener.getLogger().println(Messages.ThrottleJobProperty_DescriptorImpl_NoSuchCategory(category));
                }
            } else {
                Map<String, List<String>> currentPipelines = this.internalGetThrottledPipelinesForCategory(category);
                List<String> flowNodes = currentPipelines.get(runId);
                if (flowNodes == null) {
                    flowNodes = new CopyOnWriteArrayList<String>();
                }
                flowNodes.add(flowNodeId);
                currentPipelines.put(runId, flowNodes);
                this.throttledPipelinesByCategory.put(category, currentPipelines);
            }
        }

        public synchronized void removeThrottledPipelineForCategory(@NonNull String runId, @NonNull String flowNodeId, @NonNull String category, TaskListener listener) {
            if (this.getCategoryByName(category) == null) {
                if (listener != null) {
                    listener.getLogger().println(Messages.ThrottleJobProperty_DescriptorImpl_NoSuchCategory(category));
                }
            } else {
                Map<String, List<String>> currentPipelines = this.internalGetThrottledPipelinesForCategory(category);
                if (!currentPipelines.isEmpty()) {
                    List<String> flowNodes = currentPipelines.get(runId);
                    if (flowNodes != null) {
                        flowNodes.remove(flowNodeId);
                    }
                    if (flowNodes != null && !flowNodes.isEmpty()) {
                        currentPipelines.put(runId, flowNodes);
                    } else {
                        currentPipelines.remove(runId);
                    }
                }
                if (currentPipelines.isEmpty()) {
                    this.throttledPipelinesByCategory.remove(category);
                } else {
                    this.throttledPipelinesByCategory.put(category, currentPipelines);
                }
            }
        }

        public synchronized void removeAllFromPipelineRunForCategory(@NonNull String runId, @NonNull String category, TaskListener listener) {
            if (this.getCategoryByName(category) == null) {
                if (listener != null) {
                    listener.getLogger().println(Messages.ThrottleJobProperty_DescriptorImpl_NoSuchCategory(category));
                }
            } else {
                Map<String, List<String>> currentPipelines = this.internalGetThrottledPipelinesForCategory(category);
                if (!currentPipelines.isEmpty()) {
                    currentPipelines.remove(runId);
                }
                if (currentPipelines.isEmpty()) {
                    this.throttledPipelinesByCategory.remove(category);
                } else {
                    this.throttledPipelinesByCategory.put(category, currentPipelines);
                }
            }
        }
    }

    public static final class ThrottleCategory
    extends AbstractDescribableImpl<ThrottleCategory> {
        private Integer maxConcurrentPerNode;
        private Integer maxConcurrentTotal;
        private String categoryName;
        private List<NodeLabeledPair> nodeLabeledPairs;

        @DataBoundConstructor
        public ThrottleCategory(String categoryName, Integer maxConcurrentPerNode, Integer maxConcurrentTotal, List<NodeLabeledPair> nodeLabeledPairs) {
            this.maxConcurrentPerNode = maxConcurrentPerNode;
            this.maxConcurrentTotal = maxConcurrentTotal;
            this.categoryName = categoryName;
            this.nodeLabeledPairs = nodeLabeledPairs == null ? new ArrayList() : nodeLabeledPairs;
        }

        public Integer getMaxConcurrentPerNode() {
            if (this.maxConcurrentPerNode == null) {
                this.maxConcurrentPerNode = 0;
            }
            return this.maxConcurrentPerNode;
        }

        public Integer getMaxConcurrentTotal() {
            if (this.maxConcurrentTotal == null) {
                this.maxConcurrentTotal = 0;
            }
            return this.maxConcurrentTotal;
        }

        public String getCategoryName() {
            return this.categoryName;
        }

        public List<NodeLabeledPair> getNodeLabeledPairs() {
            if (this.nodeLabeledPairs == null) {
                this.nodeLabeledPairs = new ArrayList<NodeLabeledPair>();
            }
            return this.nodeLabeledPairs;
        }

        @Extension
        public static class DescriptorImpl
        extends Descriptor<ThrottleCategory> {
            public String getDisplayName() {
                return "";
            }
        }
    }

    public static final class NodeLabeledPair
    extends AbstractDescribableImpl<NodeLabeledPair> {
        private String throttledNodeLabel;
        private Integer maxConcurrentPerNodeLabeled;

        @DataBoundConstructor
        public NodeLabeledPair(String throttledNodeLabel, Integer maxConcurrentPerNodeLabeled) {
            this.throttledNodeLabel = throttledNodeLabel == null ? "" : throttledNodeLabel;
            this.maxConcurrentPerNodeLabeled = maxConcurrentPerNodeLabeled;
        }

        public String getThrottledNodeLabel() {
            if (this.throttledNodeLabel == null) {
                this.throttledNodeLabel = "";
            }
            return this.throttledNodeLabel;
        }

        public Integer getMaxConcurrentPerNodeLabeled() {
            if (this.maxConcurrentPerNodeLabeled == null) {
                this.maxConcurrentPerNodeLabeled = 0;
            }
            return this.maxConcurrentPerNodeLabeled;
        }

        @Extension
        public static class DescriptorImpl
        extends Descriptor<NodeLabeledPair> {
            public String getDisplayName() {
                return "";
            }
        }
    }
}

