/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.throttleconcurrents;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.Extension;
import hudson.matrix.MatrixConfiguration;
import hudson.matrix.MatrixProject;
import hudson.model.Action;
import hudson.model.Computer;
import hudson.model.Executor;
import hudson.model.Job;
import hudson.model.Node;
import hudson.model.ParameterValue;
import hudson.model.ParametersAction;
import hudson.model.Queue;
import hudson.model.Run;
import hudson.model.labels.LabelAtom;
import hudson.model.queue.CauseOfBlockage;
import hudson.model.queue.QueueTaskDispatcher;
import hudson.model.queue.SubTask;
import hudson.model.queue.WorkUnit;
import hudson.plugins.throttleconcurrents.Messages;
import hudson.plugins.throttleconcurrents.ThrottleJobProperty;
import hudson.plugins.throttleconcurrents.ThrottleMatrixProjectOptions;
import hudson.plugins.throttleconcurrents.pipeline.ThrottleStep;
import hudson.security.ACL;
import hudson.security.ACLContext;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.model.Jenkins;
import org.acegisecurity.Authentication;
import org.jenkinsci.plugins.workflow.actions.BodyInvocationAction;
import org.jenkinsci.plugins.workflow.flow.FlowExecution;
import org.jenkinsci.plugins.workflow.flow.FlowExecutionList;
import org.jenkinsci.plugins.workflow.graph.BlockStartNode;
import org.jenkinsci.plugins.workflow.graph.FlowNode;
import org.jenkinsci.plugins.workflow.graph.StepNode;
import org.jenkinsci.plugins.workflow.graphanalysis.LinearBlockHoppingScanner;
import org.jenkinsci.plugins.workflow.steps.StepDescriptor;
import org.jenkinsci.plugins.workflow.support.concurrent.Timeout;
import org.jenkinsci.plugins.workflow.support.steps.ExecutorStepExecution;
import org.jvnet.localizer.Localizable;

@Extension
public class ThrottleQueueTaskDispatcher
extends QueueTaskDispatcher {
    @SuppressFBWarnings(value={"MS_SHOULD_BE_FINAL"}, justification="deliberately mutable")
    public static boolean USE_FLOW_EXECUTION_LIST = Boolean.parseBoolean(System.getProperty(ThrottleQueueTaskDispatcher.class.getName() + ".USE_FLOW_EXECUTION_LIST", "true"));
    private static final Logger LOGGER = Logger.getLogger(ThrottleQueueTaskDispatcher.class.getName());

    @Deprecated
    @CheckForNull
    public CauseOfBlockage canTake(Node node, Queue.Task task) {
        if (Jenkins.getAuthentication().equals((Object)ACL.SYSTEM)) {
            return this.canTakeImpl(node, task);
        }
        try (ACLContext ctx = ACL.as((Authentication)ACL.SYSTEM);){
            CauseOfBlockage causeOfBlockage = this.canTakeImpl(node, task);
            return causeOfBlockage;
        }
    }

    private CauseOfBlockage canTakeImpl(Node node, Queue.Task task) {
        Jenkins jenkins = Jenkins.get();
        ThrottleJobProperty tjp = this.getThrottleJobProperty(task);
        List<String> pipelineCategories = this.categoriesForPipeline(task);
        if (!this.shouldBeThrottled(task, tjp) && pipelineCategories.isEmpty()) {
            return null;
        }
        if (!pipelineCategories.isEmpty() || tjp != null && tjp.getThrottleEnabled()) {
            CauseOfBlockage cause = this.canRunImpl(task, tjp, pipelineCategories);
            if (cause != null) {
                return cause;
            }
            if (tjp != null) {
                if (tjp.getThrottleOption().equals("project")) {
                    if (tjp.getMaxConcurrentPerNode() > 0) {
                        int maxConcurrentPerNode = tjp.getMaxConcurrentPerNode();
                        int runCount = this.buildsOfProjectOnNode(node, task);
                        if (runCount >= maxConcurrentPerNode) {
                            return CauseOfBlockage.fromMessage((Localizable)Messages._ThrottleQueueTaskDispatcher_MaxCapacityOnNode(runCount));
                        }
                    }
                } else if (tjp.getThrottleOption().equals("category")) {
                    return this.throttleCheckForCategoriesOnNode(node, jenkins, tjp.getCategories());
                }
            } else if (!pipelineCategories.isEmpty()) {
                return this.throttleCheckForCategoriesOnNode(node, jenkins, pipelineCategories);
            }
        }
        return null;
    }

    private CauseOfBlockage throttleCheckForCategoriesOnNode(Node node, Jenkins jenkins, List<String> categories) {
        if (!categories.isEmpty()) {
            for (String catNm : categories) {
                if (catNm == null || catNm.equals("")) continue;
                List<Queue.Task> categoryTasks = ThrottleJobProperty.getCategoryTasks(catNm);
                ThrottleJobProperty.ThrottleCategory category = ThrottleJobProperty.fetchDescriptor().getCategoryByName(catNm);
                if (category == null) continue;
                int runCount = 0;
                int maxConcurrentPerNode = this.getMaxConcurrentPerNodeBasedOnMatchingLabels(node, category, category.getMaxConcurrentPerNode());
                if (maxConcurrentPerNode <= 0) continue;
                for (Queue.Task catTask : categoryTasks) {
                    if (jenkins.getQueue().isPending(catTask)) {
                        return CauseOfBlockage.fromMessage((Localizable)Messages._ThrottleQueueTaskDispatcher_BuildPending());
                    }
                    runCount += this.buildsOfProjectOnNode(node, catTask);
                }
                Map<String, List<FlowNode>> throttledPipelines = ThrottleJobProperty.getThrottledPipelineRunsForCategory(catNm);
                for (Map.Entry<String, List<FlowNode>> entry : throttledPipelines.entrySet()) {
                    if (this.hasPendingPipelineForCategory(entry.getValue())) {
                        return CauseOfBlockage.fromMessage((Localizable)Messages._ThrottleQueueTaskDispatcher_BuildPending());
                    }
                    Run r = Run.fromExternalizableId((String)entry.getKey());
                    if (r == null) continue;
                    List<FlowNode> flowNodes = entry.getValue();
                    if (!r.isBuilding()) continue;
                    runCount += this.pipelinesOnNode(node, r, flowNodes);
                }
                if (runCount < maxConcurrentPerNode) continue;
                return CauseOfBlockage.fromMessage((Localizable)Messages._ThrottleQueueTaskDispatcher_MaxCapacityOnNode(runCount));
            }
        }
        return null;
    }

    private boolean hasPendingPipelineForCategory(List<FlowNode> flowNodes) {
        for (Queue.BuildableItem pending : Jenkins.get().getQueue().getPendingItems()) {
            if (!this.isTaskThrottledPipeline(pending.task, flowNodes)) continue;
            return true;
        }
        return false;
    }

    @CheckForNull
    public CauseOfBlockage canRun(Queue.Item item) {
        ThrottleJobProperty tjp = this.getThrottleJobProperty(item.task);
        List<String> pipelineCategories = this.categoriesForPipeline(item.task);
        if (!pipelineCategories.isEmpty() || tjp != null && tjp.getThrottleEnabled()) {
            if (tjp != null && tjp.isLimitOneJobWithMatchingParams() && this.isAnotherBuildWithSameParametersRunningOnAnyNode(item)) {
                return CauseOfBlockage.fromMessage((Localizable)Messages._ThrottleQueueTaskDispatcher_OnlyOneWithMatchingParameters());
            }
            return this.canRun(item.task, tjp, pipelineCategories);
        }
        return null;
    }

    @NonNull
    private ThrottleMatrixProjectOptions getMatrixOptions(Queue.Task task) {
        ThrottleJobProperty tjp = this.getThrottleJobProperty(task);
        if (tjp == null) {
            return ThrottleMatrixProjectOptions.DEFAULT;
        }
        ThrottleMatrixProjectOptions matrixOptions = tjp.getMatrixOptions();
        return matrixOptions != null ? matrixOptions : ThrottleMatrixProjectOptions.DEFAULT;
    }

    private boolean shouldBeThrottled(@NonNull Queue.Task task, @CheckForNull ThrottleJobProperty tjp) {
        if (tjp == null) {
            return false;
        }
        if (!tjp.getThrottleEnabled()) {
            return false;
        }
        ThrottleMatrixProjectOptions matrixOptions = tjp.getMatrixOptions();
        if (matrixOptions == null) {
            matrixOptions = ThrottleMatrixProjectOptions.DEFAULT;
        }
        if (!matrixOptions.isThrottleMatrixConfigurations() && task instanceof MatrixConfiguration) {
            return false;
        }
        return matrixOptions.isThrottleMatrixBuilds() || !(task instanceof MatrixProject);
    }

    private CauseOfBlockage canRun(Queue.Task task, ThrottleJobProperty tjp, List<String> pipelineCategories) {
        if (Jenkins.getAuthentication().equals((Object)ACL.SYSTEM)) {
            return this.canRunImpl(task, tjp, pipelineCategories);
        }
        try (ACLContext ctx = ACL.as((Authentication)ACL.SYSTEM);){
            CauseOfBlockage causeOfBlockage = this.canRunImpl(task, tjp, pipelineCategories);
            return causeOfBlockage;
        }
    }

    private CauseOfBlockage canRunImpl(Queue.Task task, ThrottleJobProperty tjp, List<String> pipelineCategories) {
        Jenkins jenkins = Jenkins.get();
        if (!this.shouldBeThrottled(task, tjp) && pipelineCategories.isEmpty()) {
            return null;
        }
        if (jenkins.getQueue().isPending(task)) {
            return CauseOfBlockage.fromMessage((Localizable)Messages._ThrottleQueueTaskDispatcher_BuildPending());
        }
        if (tjp != null) {
            if (tjp.getThrottleOption().equals("project")) {
                if (tjp.getMaxConcurrentTotal() > 0) {
                    int maxConcurrentTotal = tjp.getMaxConcurrentTotal();
                    int totalRunCount = this.buildsOfProjectOnAllNodes(task);
                    if (totalRunCount >= maxConcurrentTotal) {
                        return CauseOfBlockage.fromMessage((Localizable)Messages._ThrottleQueueTaskDispatcher_MaxCapacityTotal(totalRunCount));
                    }
                }
            } else if (tjp.getThrottleOption().equals("category")) {
                return this.throttleCheckForCategoriesAllNodes(jenkins, tjp.getCategories());
            }
        } else if (!pipelineCategories.isEmpty()) {
            return this.throttleCheckForCategoriesAllNodes(jenkins, pipelineCategories);
        }
        return null;
    }

    private CauseOfBlockage throttleCheckForCategoriesAllNodes(Jenkins jenkins, @NonNull List<String> categories) {
        for (String catNm : categories) {
            if (catNm == null || catNm.equals("")) continue;
            List<Queue.Task> categoryTasks = ThrottleJobProperty.getCategoryTasks(catNm);
            ThrottleJobProperty.ThrottleCategory category = ThrottleJobProperty.fetchDescriptor().getCategoryByName(catNm);
            if (category == null || category.getMaxConcurrentTotal() <= 0) continue;
            int maxConcurrentTotal = category.getMaxConcurrentTotal();
            int totalRunCount = 0;
            for (Queue.Task catTask : categoryTasks) {
                if (jenkins.getQueue().isPending(catTask)) {
                    return CauseOfBlockage.fromMessage((Localizable)Messages._ThrottleQueueTaskDispatcher_BuildPending());
                }
                totalRunCount += this.buildsOfProjectOnAllNodes(catTask);
            }
            Map<String, List<FlowNode>> throttledPipelines = ThrottleJobProperty.getThrottledPipelineRunsForCategory(catNm);
            for (Map.Entry<String, List<FlowNode>> entry : throttledPipelines.entrySet()) {
                if (this.hasPendingPipelineForCategory(entry.getValue())) {
                    return CauseOfBlockage.fromMessage((Localizable)Messages._ThrottleQueueTaskDispatcher_BuildPending());
                }
                Run r = Run.fromExternalizableId((String)entry.getKey());
                if (r == null) continue;
                List<FlowNode> flowNodes = entry.getValue();
                if (!r.isBuilding()) continue;
                totalRunCount += this.pipelinesOnAllNodes(r, flowNodes);
            }
            if (totalRunCount < maxConcurrentTotal) continue;
            return CauseOfBlockage.fromMessage((Localizable)Messages._ThrottleQueueTaskDispatcher_MaxCapacityTotal(totalRunCount));
        }
        return null;
    }

    private boolean isAnotherBuildWithSameParametersRunningOnAnyNode(Queue.Item item) {
        Jenkins jenkins = Jenkins.get();
        if (this.isAnotherBuildWithSameParametersRunningOnNode((Node)jenkins, item)) {
            return true;
        }
        for (Node node : jenkins.getNodes()) {
            if (!this.isAnotherBuildWithSameParametersRunningOnNode(node, item)) continue;
            return true;
        }
        return false;
    }

    private boolean isAnotherBuildWithSameParametersRunningOnNode(Node node, Queue.Item item) {
        ThrottleJobProperty tjp = this.getThrottleJobProperty(item.task);
        if (tjp == null) {
            return false;
        }
        Computer computer = node.toComputer();
        List<String> paramsToCompare = tjp.getParamsToCompare();
        List<ParameterValue> itemParams = this.getParametersFromQueueItem(item);
        if (paramsToCompare.size() > 0) {
            itemParams = this.doFilterParams(paramsToCompare, itemParams);
        }
        if (computer != null) {
            for (Executor exec : computer.getAllExecutors()) {
                SubTask parentTask;
                Queue.Executable currentExecutable = exec.getCurrentExecutable();
                SubTask subTask = parentTask = currentExecutable != null ? currentExecutable.getParent() : null;
                if (currentExecutable == null || !parentTask.getOwnerTask().getName().equals(item.task.getName())) continue;
                List<ParameterValue> executingUnitParams = this.getParametersFromWorkUnit(exec.getCurrentWorkUnit());
                if (!(executingUnitParams = this.doFilterParams(paramsToCompare, executingUnitParams)).containsAll(itemParams)) continue;
                LOGGER.log(Level.FINE, "build (" + String.valueOf(exec.getCurrentWorkUnit()) + ") with identical parameters (" + String.valueOf(executingUnitParams) + ") is already running.");
                return true;
            }
        }
        return false;
    }

    private List<ParameterValue> doFilterParams(List<String> params, List<ParameterValue> OriginalParams) {
        if (params.isEmpty()) {
            return OriginalParams;
        }
        ArrayList<ParameterValue> newParams = new ArrayList<ParameterValue>();
        for (ParameterValue p : OriginalParams) {
            if (!params.contains(p.getName())) continue;
            newParams.add(p);
        }
        return newParams;
    }

    public List<ParameterValue> getParametersFromWorkUnit(WorkUnit unit) {
        List<Object> paramsList;
        block2: {
            block3: {
                paramsList = new ArrayList<ParameterValue>();
                if (unit == null || unit.context == null) break block2;
                if (unit.context.actions == null || unit.context.actions.isEmpty()) break block3;
                List actions = unit.context.actions;
                for (Action action : actions) {
                    if (!(action instanceof ParametersAction)) continue;
                    paramsList = ((ParametersAction)action).getParameters();
                }
                break block2;
            }
            Queue.Executable ownerExecutable = unit.context.task.getOwnerExecutable();
            if (!(ownerExecutable instanceof Run)) break block2;
            Run run = (Run)ownerExecutable;
            List actions = run.getActions(ParametersAction.class);
            for (ParametersAction action : actions) {
                paramsList = action.getParameters();
            }
        }
        return paramsList;
    }

    public List<ParameterValue> getParametersFromQueueItem(Queue.Item item) {
        ParametersAction params = (ParametersAction)item.getAction(ParametersAction.class);
        ArrayList<ParameterValue> paramsList = params != null ? params.getParameters() : new ArrayList<ParameterValue>();
        return paramsList;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NonNull
    private List<String> categoriesForPipeline(Queue.Task task) {
        if (!(task instanceof ExecutorStepExecution.PlaceholderTask)) return new ArrayList<String>();
        ExecutorStepExecution.PlaceholderTask placeholderTask = (ExecutorStepExecution.PlaceholderTask)task;
        Queue.Executable ownerExecutable = task.getOwnerExecutable();
        if (!(ownerExecutable instanceof Run)) return new ArrayList<String>();
        Run run = (Run)ownerExecutable;
        Map<String, List<String>> categoriesByFlowNode = ThrottleJobProperty.getCategoriesForRunByFlowNode(run);
        if (categoriesByFlowNode.isEmpty()) return new ArrayList<String>();
        try (Timeout t = Timeout.limit((long)100L, (TimeUnit)TimeUnit.MILLISECONDS);){
            FlowNode firstThrottle = this.firstThrottleStartNode(placeholderTask.getNode());
            if (firstThrottle == null) return new ArrayList<String>();
            List<String> categories = categoriesByFlowNode.get(firstThrottle.getId());
            if (categories == null) return new ArrayList<String>();
            List<String> list = categories;
            return list;
        }
        catch (IOException | InterruptedException e) {
            LOGGER.log(Level.WARNING, "Error getting categories for pipeline {0}: {1}", new Object[]{task.getDisplayName(), e});
            return new ArrayList<String>();
        }
    }

    @CheckForNull
    private ThrottleJobProperty getThrottleJobProperty(Queue.Task task) {
        if (task instanceof Job) {
            Job p = (Job)task;
            if (task instanceof MatrixConfiguration) {
                p = ((MatrixConfiguration)task).getParent();
            }
            return (ThrottleJobProperty)p.getProperty(ThrottleJobProperty.class);
        }
        return null;
    }

    private int pipelinesOnNode(@NonNull Node node, @NonNull Run<?, ?> run, @NonNull List<FlowNode> flowNodes) {
        int runCount = 0;
        LOGGER.log(Level.FINE, "Checking for pipelines of {0} on node {1}", new Object[]{run.getDisplayName(), node.getDisplayName()});
        Computer computer = node.toComputer();
        if (computer != null) {
            for (Executor e : computer.getExecutors()) {
                runCount += this.pipelinesOnExecutor(run, e, flowNodes);
            }
        }
        return runCount;
    }

    private int pipelinesOnAllNodes(@NonNull Run<?, ?> run, @NonNull List<FlowNode> flowNodes) {
        Jenkins jenkins = Jenkins.get();
        int totalRunCount = this.pipelinesOnNode((Node)jenkins, run, flowNodes);
        for (Node node : jenkins.getNodes()) {
            totalRunCount += this.pipelinesOnNode(node, run, flowNodes);
        }
        return totalRunCount;
    }

    private int buildsOfProjectOnNode(Node node, Queue.Task task) {
        if (!this.shouldBeThrottled(task, this.getThrottleJobProperty(task))) {
            return 0;
        }
        return this.buildsOfProjectOnNodeImpl(node, task);
    }

    private int buildsOfProjectOnAllNodes(Queue.Task task) {
        if (!this.shouldBeThrottled(task, this.getThrottleJobProperty(task))) {
            return 0;
        }
        if (USE_FLOW_EXECUTION_LIST && task.getClass().getName().equals("org.jenkinsci.plugins.workflow.job.WorkflowJob")) {
            return this.buildsOfPipelineJob(task);
        }
        return this.buildsOfProjectOnAllNodesImpl(task);
    }

    private int buildsOfPipelineJob(Queue.Task task) {
        int runCount = 0;
        for (FlowExecution flowExecution : FlowExecutionList.get()) {
            try {
                Queue.Executable executable = flowExecution.getOwner().getExecutable();
                if (executable == null || !task.equals((Object)executable.getParent())) continue;
                ++runCount;
            }
            catch (IOException e) {
                LOGGER.log(Level.WARNING, "Error getting number of builds for pipeline {0}: {1}", new Object[]{task.getDisplayName(), e});
            }
        }
        return runCount;
    }

    private int buildsOfProjectOnNodeImpl(Node node, Queue.Task task) {
        int runCount = 0;
        LOGGER.log(Level.FINE, "Checking for builds of {0} on node {1}", new Object[]{task.getName(), node.getDisplayName()});
        Computer computer = node.toComputer();
        if (computer != null) {
            for (Executor e : computer.getOneOffExecutors()) {
                runCount += this.buildsOnExecutor(task, e);
            }
            for (Executor e : computer.getExecutors()) {
                runCount += this.buildsOnExecutor(task, e);
            }
        }
        return runCount;
    }

    private int buildsOfProjectOnAllNodesImpl(Queue.Task task) {
        Jenkins jenkins = Jenkins.get();
        int totalRunCount = this.buildsOfProjectOnNode((Node)jenkins, task);
        for (Node node : jenkins.getNodes()) {
            totalRunCount += this.buildsOfProjectOnNodeImpl(node, task);
        }
        return totalRunCount;
    }

    private int buildsOnExecutor(Queue.Task task, Executor exec) {
        int runCount = 0;
        Queue.Executable currentExecutable = exec.getCurrentExecutable();
        if (currentExecutable != null && task.equals((Object)currentExecutable.getParent())) {
            ++runCount;
        }
        return runCount;
    }

    private int pipelinesOnExecutor(@NonNull Run<?, ?> run, @NonNull Executor exec, @NonNull List<FlowNode> flowNodes) {
        Run run2;
        Queue.Executable ownerExecutable;
        SubTask parent;
        Queue.Executable currentExecutable = exec.getCurrentExecutable();
        if (currentExecutable != null && (parent = currentExecutable.getParent()) instanceof Queue.Task && (ownerExecutable = parent.getOwnerExecutable()) instanceof Run && run.equals((Object)(run2 = (Run)ownerExecutable)) && this.isTaskThrottledPipeline((Queue.Task)parent, flowNodes)) {
            return 1;
        }
        return 0;
    }

    private boolean isTaskThrottledPipeline(Queue.Task origTask, List<FlowNode> flowNodes) {
        if (origTask instanceof ExecutorStepExecution.PlaceholderTask) {
            ExecutorStepExecution.PlaceholderTask task = (ExecutorStepExecution.PlaceholderTask)origTask;
            try {
                FlowNode firstThrottle = this.firstThrottleStartNode(task.getNode());
                return firstThrottle != null && flowNodes.contains(firstThrottle);
            }
            catch (IOException | InterruptedException exception) {
                // empty catch block
            }
        }
        return false;
    }

    @CheckForNull
    private FlowNode firstThrottleStartNode(@CheckForNull FlowNode inner) {
        if (inner != null) {
            LinearBlockHoppingScanner scanner = new LinearBlockHoppingScanner();
            scanner.setup(inner);
            for (FlowNode enclosing : scanner) {
                StepDescriptor desc;
                if (enclosing == null || !(enclosing instanceof BlockStartNode) || !(enclosing instanceof StepNode) || enclosing.getAction(BodyInvocationAction.class) != null || (desc = ((StepNode)enclosing).getDescriptor()) == null || !desc.getClass().equals(ThrottleStep.DescriptorImpl.class)) continue;
                return enclosing;
            }
        }
        return null;
    }

    private int getMaxConcurrentPerNodeBasedOnMatchingLabels(Node node, ThrottleJobProperty.ThrottleCategory category, int maxConcurrentPerNode) {
        List<ThrottleJobProperty.NodeLabeledPair> nodeLabeledPairs = category.getNodeLabeledPairs();
        int maxConcurrentPerNodeLabeledIfMatch = maxConcurrentPerNode;
        boolean nodeLabelsMatch = false;
        Set nodeLabels = node.getAssignedLabels();
        block0: for (ThrottleJobProperty.NodeLabeledPair nodeLabeledPair : nodeLabeledPairs) {
            String throttledNodeLabel = nodeLabeledPair.getThrottledNodeLabel();
            if (nodeLabelsMatch || throttledNodeLabel.isEmpty()) continue;
            for (LabelAtom aNodeLabel : nodeLabels) {
                String nodeLabel = aNodeLabel.getDisplayName();
                if (!nodeLabel.equals(throttledNodeLabel)) continue;
                maxConcurrentPerNodeLabeledIfMatch = nodeLabeledPair.getMaxConcurrentPerNodeLabeled();
                LOGGER.log(Level.FINE, "node labels match; => maxConcurrentPerNode'' = {0}", maxConcurrentPerNodeLabeledIfMatch);
                nodeLabelsMatch = true;
                continue block0;
            }
        }
        if (!nodeLabelsMatch) {
            LOGGER.fine("node labels mismatch");
        }
        return maxConcurrentPerNodeLabeledIfMatch;
    }
}

