/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.throttleconcurrents.pipeline;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.plugins.throttleconcurrents.ThrottleJobProperty;
import hudson.plugins.throttleconcurrents.pipeline.ThrottleStep;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.plugins.workflow.graph.FlowNode;
import org.jenkinsci.plugins.workflow.steps.BodyExecutionCallback;
import org.jenkinsci.plugins.workflow.steps.StepContext;
import org.jenkinsci.plugins.workflow.steps.StepExecution;

public class ThrottleStepExecution
extends StepExecution {
    private final ThrottleStep step;

    public ThrottleStepExecution(@NonNull ThrottleStep step, StepContext context) {
        super(context);
        this.step = step;
    }

    @NonNull
    public List<String> getCategories() {
        return Collections.unmodifiableList(this.step.getCategories());
    }

    private List<String> validateCategories(ThrottleJobProperty.DescriptorImpl descriptor, TaskListener listener) {
        ArrayList<String> undefinedCategories = new ArrayList<String>();
        HashSet<String> duplicates = new HashSet<String>();
        ArrayList<String> unique = new ArrayList<String>();
        if (descriptor.getCategories().isEmpty()) {
            undefinedCategories.addAll(this.getCategories());
        } else {
            for (String c : this.getCategories()) {
                if (!unique.contains(c)) {
                    unique.add(c);
                } else {
                    duplicates.add(c);
                }
                if (descriptor.getCategoryByName(c) != null) continue;
                undefinedCategories.add(c);
            }
        }
        if (!duplicates.isEmpty()) {
            listener.getLogger().println("One or more duplicate categories (" + StringUtils.join(duplicates, (String)", ") + ") specified. Duplicates will be ignored.");
        }
        if (!undefinedCategories.isEmpty()) {
            throw new IllegalArgumentException("One or more specified categories do not exist: " + StringUtils.join(undefinedCategories, (String)", "));
        }
        return unique;
    }

    public boolean start() throws Exception {
        Run r = (Run)this.getContext().get(Run.class);
        TaskListener listener = (TaskListener)this.getContext().get(TaskListener.class);
        FlowNode flowNode = (FlowNode)this.getContext().get(FlowNode.class);
        ThrottleJobProperty.DescriptorImpl descriptor = ThrottleJobProperty.fetchDescriptor();
        String runId = null;
        String flowNodeId = null;
        if (r != null && flowNode != null) {
            runId = r.getExternalizableId();
            flowNodeId = flowNode.getId();
            for (String category : this.validateCategories(descriptor, listener)) {
                descriptor.addThrottledPipelineForCategory(runId, flowNodeId, category, listener);
            }
        }
        this.getContext().newBodyInvoker().withCallback((BodyExecutionCallback)new Callback(runId, flowNodeId, this.getCategories())).start();
        return false;
    }

    public void stop(Throwable cause) throws Exception {
    }

    private static final class Callback
    extends BodyExecutionCallback.TailCall {
        @CheckForNull
        private String runId;
        @CheckForNull
        private String flowNodeId;
        private List<String> categories = new ArrayList<String>();
        private static final long serialVersionUID = 1L;

        Callback(@CheckForNull String runId, @CheckForNull String flowNodeId, @NonNull List<String> categories) {
            this.runId = runId;
            this.flowNodeId = flowNodeId;
            this.categories.addAll(categories);
        }

        protected void finished(StepContext context) throws Exception {
            if (this.runId != null && this.flowNodeId != null) {
                for (String category : this.categories) {
                    ThrottleJobProperty.fetchDescriptor().removeThrottledPipelineForCategory(this.runId, this.flowNodeId, category, (TaskListener)context.get(TaskListener.class));
                }
            }
        }
    }
}

