/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.textfinder;

import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.Extension;
import hudson.FilePath;
import hudson.Functions;
import hudson.Launcher;
import hudson.console.ConsoleNote;
import hudson.model.AbstractProject;
import hudson.model.Result;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.plugins.textfinder.Messages;
import hudson.plugins.textfinder.TextFinder;
import hudson.plugins.textfinder.TextFinderChangeCondition;
import hudson.remoting.RemoteOutputStream;
import hudson.remoting.VirtualChannel;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.BuildStepMonitor;
import hudson.tasks.Publisher;
import hudson.tasks.Recorder;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.Reader;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import jenkins.MasterToSlaveFileCallable;
import jenkins.tasks.SimpleBuildStep;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.types.FileSet;
import org.jenkinsci.Symbol;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.DoNotUse;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;

public class TextFinderPublisher
extends Recorder
implements Serializable,
SimpleBuildStep {
    @NonNull
    private List<TextFinder> textFinders = new ArrayList<TextFinder>();
    @Deprecated
    @Restricted(value={NoExternalUse.class})
    @SuppressFBWarnings(value={"PA_PUBLIC_PRIMITIVE_ATTRIBUTE"}, justification="Preserve API compatibility.")
    public transient String fileSet;
    @Deprecated
    @Restricted(value={NoExternalUse.class})
    @SuppressFBWarnings(value={"PA_PUBLIC_PRIMITIVE_ATTRIBUTE"}, justification="Preserve API compatibility.")
    public transient String regexp;
    @Deprecated
    @Restricted(value={NoExternalUse.class})
    @SuppressFBWarnings(value={"PA_PUBLIC_PRIMITIVE_ATTRIBUTE"}, justification="Preserve API compatibility.")
    public transient boolean succeedIfFound;
    @Deprecated
    @Restricted(value={NoExternalUse.class})
    @SuppressFBWarnings(value={"PA_PUBLIC_PRIMITIVE_ATTRIBUTE"}, justification="Preserve API compatibility.")
    public transient boolean unstableIfFound;
    @Deprecated
    @Restricted(value={NoExternalUse.class})
    @SuppressFBWarnings(value={"PA_PUBLIC_PRIMITIVE_ATTRIBUTE"}, justification="Preserve API compatibility.")
    public transient boolean notBuiltIfFound;
    @Deprecated
    @Restricted(value={NoExternalUse.class})
    @SuppressFBWarnings(value={"PA_PUBLIC_PRIMITIVE_ATTRIBUTE"}, justification="Preserve API compatibility.")
    public transient boolean alsoCheckConsoleOutput;
    @Deprecated
    @Restricted(value={DoNotUse.class})
    public transient String buildResult;
    private static final long serialVersionUID = 1L;

    @DataBoundConstructor
    public TextFinderPublisher() {
    }

    @Deprecated
    @Restricted(value={NoExternalUse.class})
    public TextFinderPublisher(String regexp) {
        this();
        this.textFinders.add(new TextFinder(regexp));
    }

    @Deprecated
    @Restricted(value={NoExternalUse.class})
    public TextFinderPublisher(String fileSet, String regexp, boolean succeedIfFound, boolean unstableIfFound, boolean alsoCheckConsoleOutput) {
        this(regexp);
        this.setFileSet(fileSet);
        this.setSucceedIfFound(succeedIfFound);
        this.setUnstableIfFound(unstableIfFound);
        this.setAlsoCheckConsoleOutput(alsoCheckConsoleOutput);
    }

    @NonNull
    public List<TextFinder> getTextFinders() {
        return this.textFinders;
    }

    @DataBoundSetter
    public void setTextFinders(List<TextFinder> textFinders) {
        this.textFinders = textFinders != null ? new ArrayList<TextFinder>(textFinders) : new ArrayList();
    }

    @DataBoundSetter
    @Deprecated
    @Restricted(value={NoExternalUse.class})
    public void setRegexp(String regexp) {
        this.getFirst().setRegexp(regexp);
    }

    @DataBoundSetter
    @Deprecated
    @Restricted(value={NoExternalUse.class})
    public void setFileSet(String fileSet) {
        this.getFirst().setFileSet(fileSet);
    }

    @DataBoundSetter
    @Deprecated
    @Restricted(value={NoExternalUse.class})
    public void setBuildResult(String buildResult) {
        this.getFirst().setBuildResult(buildResult);
    }

    @DataBoundSetter
    @Deprecated
    @Restricted(value={NoExternalUse.class})
    public void setSucceedIfFound(boolean succeedIfFound) {
        if (succeedIfFound) {
            this.getFirst().setChangeCondition(TextFinderChangeCondition.MATCH_NOT_FOUND);
        }
    }

    @DataBoundSetter
    @Deprecated
    @Restricted(value={NoExternalUse.class})
    public void setUnstableIfFound(boolean unstableIfFound) {
        if (unstableIfFound && !this.getFirst().getBuildResult().equals(Result.NOT_BUILT.toString())) {
            this.getFirst().setBuildResult(Result.UNSTABLE.toString());
        }
    }

    @DataBoundSetter
    @Deprecated
    @Restricted(value={NoExternalUse.class})
    public void setNotBuiltIfFound(boolean notBuiltIfFound) {
        if (notBuiltIfFound) {
            this.getFirst().setBuildResult(Result.NOT_BUILT.toString());
        }
    }

    @DataBoundSetter
    @Deprecated
    @Restricted(value={NoExternalUse.class})
    public void setAlsoCheckConsoleOutput(boolean alsoCheckConsoleOutput) {
        this.getFirst().setAlsoCheckConsoleOutput(alsoCheckConsoleOutput);
    }

    private TextFinder getFirst() {
        if (this.textFinders.isEmpty()) {
            TextFinder first = new TextFinder("");
            this.textFinders.add(first);
            return first;
        }
        return this.textFinders.get(0);
    }

    protected Object readResolve() {
        if (this.regexp != null) {
            this.setTextFinders(Collections.singletonList(new TextFinder(this.regexp)));
            this.regexp = null;
        }
        if (this.fileSet != null) {
            this.setFileSet(this.fileSet);
            this.fileSet = null;
        }
        if (this.succeedIfFound) {
            this.setSucceedIfFound(this.succeedIfFound);
            this.succeedIfFound = false;
        }
        if (this.unstableIfFound) {
            this.setUnstableIfFound(this.unstableIfFound);
            this.unstableIfFound = false;
        }
        if (this.notBuiltIfFound) {
            this.setNotBuiltIfFound(this.notBuiltIfFound);
            this.notBuiltIfFound = false;
        }
        if (this.alsoCheckConsoleOutput) {
            this.setAlsoCheckConsoleOutput(this.alsoCheckConsoleOutput);
            this.alsoCheckConsoleOutput = false;
        }
        return this;
    }

    public BuildStepMonitor getRequiredMonitorService() {
        return BuildStepMonitor.NONE;
    }

    public void perform(@NonNull Run<?, ?> run, @NonNull FilePath workspace, @NonNull Launcher launcher, @NonNull TaskListener listener) throws InterruptedException, IOException {
        for (TextFinder textFinder : this.textFinders) {
            TextFinderPublisher.findText(textFinder, run, workspace, listener);
        }
    }

    private static void findText(TextFinder textFinder, Run<?, ?> run, FilePath workspace, TaskListener listener) throws IOException, InterruptedException {
        try {
            PrintStream logger = listener.getLogger();
            boolean foundText = false;
            if (textFinder.isAlsoCheckConsoleOutput()) {
                logger.println("[Text Finder] Searching console output...");
                foundText = TextFinderPublisher.checkConsole(run, TextFinderPublisher.compilePattern(logger, textFinder.getRegexp()), logger);
                logger.println("[Text Finder] Finished searching for pattern '" + textFinder.getRegexp() + "' in console output.");
            }
            if (textFinder.getFileSet() != null) {
                logger.println("[Text Finder] Searching for pattern '" + textFinder.getRegexp() + "' in file set '" + textFinder.getFileSet() + "'...");
                RemoteOutputStream ros = new RemoteOutputStream((OutputStream)logger);
                foundText |= ((Boolean)workspace.act((FilePath.FileCallable)new FileChecker(ros, textFinder.getFileSet(), textFinder.getRegexp()))).booleanValue();
                logger.println("[Text Finder] Finished searching for pattern '" + textFinder.getRegexp() + "' in file set '" + textFinder.getFileSet() + "'.");
            }
            Result result = Result.SUCCESS;
            switch (textFinder.getChangeCondition()) {
                case MATCH_FOUND: {
                    if (!foundText) break;
                    result = Result.fromString((String)textFinder.getBuildResult());
                    break;
                }
                case MATCH_NOT_FOUND: {
                    if (foundText) break;
                    result = Result.fromString((String)textFinder.getBuildResult());
                    break;
                }
                default: {
                    throw new IllegalStateException("Unexpected value: " + String.valueOf((Object)textFinder.getChangeCondition()));
                }
            }
            if (!result.equals(Result.SUCCESS)) {
                logger.println("[Text Finder] Setting build result to '" + String.valueOf(result) + "'.");
                run.setResult(result);
            }
        }
        catch (AbortException e) {
            run.setResult(Result.UNSTABLE);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean checkPattern(Reader r, Pattern pattern, PrintStream logger, String header, boolean isConsoleLog) throws IOException {
        boolean logFilename = true;
        boolean foundText = false;
        try (BufferedReader reader = new BufferedReader(r);){
            block11: {
                String line;
                while ((line = reader.readLine()) != null) {
                    Matcher matcher;
                    if (isConsoleLog) {
                        line = ConsoleNote.removeNotes((String)line);
                    }
                    if (!(matcher = pattern.matcher(line)).find()) continue;
                    if (logFilename) {
                        if (header != null) {
                            logger.println(header);
                        }
                        logFilename = false;
                    }
                    logger.println(line);
                    foundText = true;
                    if (!isConsoleLog) {
                        continue;
                    }
                    break block11;
                }
                return foundText;
            }
            boolean bl = true;
            return bl;
        }
    }

    private static boolean checkConsole(Run<?, ?> build, Pattern pattern, PrintStream logger) {
        boolean bl;
        block8: {
            Reader r = build.getLogReader();
            try {
                bl = TextFinderPublisher.checkPattern(r, pattern, logger, null, true);
                if (r == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (r != null) {
                        try {
                            r.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    logger.println("[Text Finder] Error reading console output -- ignoring");
                    Functions.printStackTrace((Throwable)e, (PrintStream)logger);
                    return false;
                }
            }
            r.close();
        }
        return bl;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private static boolean checkFile(File f, Pattern pattern, PrintStream logger, Charset charset) {
        try (FileInputStream is = new FileInputStream(f);){
            boolean bl;
            try (InputStreamReader r = new InputStreamReader((InputStream)is, charset);){
                bl = TextFinderPublisher.checkPattern(r, pattern, logger, String.valueOf(f) + ":", false);
            }
            return bl;
        }
        catch (IOException e) {
            logger.println("[Text Finder] Error reading file '" + String.valueOf(f) + "' -- ignoring");
            Functions.printStackTrace((Throwable)e, (PrintStream)logger);
            return false;
        }
    }

    private static Pattern compilePattern(PrintStream logger, String regexp) {
        Pattern pattern;
        try {
            pattern = Pattern.compile(regexp);
        }
        catch (PatternSyntaxException e) {
            logger.println("[Text Finder] Unable to compile regular expression '" + regexp + "'");
            throw new AbortException();
        }
        return pattern;
    }

    private static class FileChecker
    extends MasterToSlaveFileCallable<Boolean> {
        private final RemoteOutputStream ros;
        private final String fileSet;
        private final String regexp;

        public FileChecker(RemoteOutputStream ros, String fileSet, String regexp) {
            this.ros = ros;
            this.fileSet = fileSet;
            this.regexp = regexp;
        }

        public Boolean invoke(File ws, VirtualChannel channel) throws IOException {
            PrintStream logger = new PrintStream((OutputStream)this.ros, true, Charset.defaultCharset().toString());
            FileSet fs = new FileSet();
            Project p = new Project();
            fs.setProject(p);
            fs.setDir(ws);
            fs.setIncludes(this.fileSet);
            DirectoryScanner ds = fs.getDirectoryScanner(p);
            String[] files = ds.getIncludedFiles();
            if (files.length == 0) {
                logger.println("[Text Finder] File set '" + this.fileSet + "' is empty");
                throw new AbortException();
            }
            Pattern pattern = TextFinderPublisher.compilePattern(logger, this.regexp);
            boolean foundText = false;
            for (String file : files) {
                File f = new File(ws, file);
                if (!f.exists()) {
                    logger.println("[Text Finder] Unable to find file '" + String.valueOf(f) + "'");
                    continue;
                }
                if (!f.canRead()) {
                    logger.println("[Text Finder] Unable to read from file '" + String.valueOf(f) + "'");
                    continue;
                }
                foundText |= TextFinderPublisher.checkFile(f, pattern, logger, Charset.defaultCharset());
            }
            return foundText;
        }
    }

    private static final class AbortException
    extends RuntimeException {
        private AbortException() {
        }
    }

    @Symbol(value={"findText"})
    @Extension
    public static final class DescriptorImpl
    extends BuildStepDescriptor<Publisher> {
        @NonNull
        public String getDisplayName() {
            return Messages.TextFinderPublisher_DisplayName();
        }

        public String getHelpFile() {
            return "/plugin/text-finder/help.html";
        }

        public boolean isApplicable(Class<? extends AbstractProject> jobType) {
            return true;
        }
    }
}

